/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.rgbfilters;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.RgbFilter;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ImageUtil;
import de.enough.polish.util.RgbImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ScaleRgbFilter
extends RgbFilter {
    protected Dimension scaling;
    protected transient RgbImage output;
    protected boolean keepOriginalImageDimensions = false;

    public boolean isActive() {
        boolean isActive = false;
        if (this.scaling != null) {
            isActive = this.scaling.getValue(100) != 100;
        }
        return isActive;
    }

    public RgbImage process(RgbImage input) {
        if (!this.isActive()) {
            return input;
        }
        int width = input.getWidth();
        int height = input.getHeight();
        int scalePercent = this.scaling.getValue(100);
        int[] rgbInput = input.getRgbData();
        if (this.keepOriginalImageDimensions) {
            int[] rgbOutput;
            if (this.output == null || this.output.getWidth() != width || this.output.getHeight() != height) {
                this.output = new RgbImage(width, height);
            } else if (scalePercent < 100) {
                rgbOutput = this.output.getRgbData();
                for (int i = 0; i < rgbOutput.length; ++i) {
                    rgbOutput[i] = 0;
                }
            }
            rgbOutput = this.output.getRgbData();
            ImageUtil.scale(scalePercent, width, height, rgbInput, rgbOutput);
        } else {
            int newWidth = width * scalePercent / 100;
            int newHeight = height * scalePercent / 100;
            if (this.output == null || this.output.getWidth() != newWidth || this.output.getHeight() != newHeight) {
                this.output = new RgbImage(newWidth, newHeight);
            }
            int[] rgbOutput = this.output.getRgbData();
            ImageUtil.scale(rgbInput, newWidth, newHeight, width, height, rgbOutput);
        }
        return this.output;
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
    }

    public void releaseResources() {
        this.output = null;
    }

    public void setScaleFactor(int factor) {
        this.scaling = new Dimension(factor, true);
    }

    public void setCropImage(boolean keepOriginalDimensions) {
        this.keepOriginalImageDimensions = keepOriginalDimensions;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.keepOriginalImageDimensions = dataInputStream.readBoolean();
        this.scaling = (Dimension)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.keepOriginalImageDimensions);
        Serializer.serialize(this.scaling, dataOutputStream);
    }
}

