/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.rgbfilters;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.RgbFilter;
import de.enough.polish.ui.Style;
import de.enough.polish.util.RgbImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class OpacityRgbFilter
extends RgbFilter {
    protected Dimension opacity;
    protected transient RgbImage output;

    public boolean isActive() {
        if (this.opacity == null) {
            return false;
        }
        return this.opacity.getValue(255) != 255;
    }

    public RgbImage process(RgbImage input) {
        if (!this.isActive()) {
            return input;
        }
        if (this.output == null || this.output.getWidth() != input.getWidth() || this.output.getHeight() != input.getHeight()) {
            this.output = new RgbImage(input.getWidth(), input.getHeight());
        }
        int[] rgbInput = input.getRgbData();
        int[] rgbOutput = this.output.getRgbData();
        int alpha = this.opacity.getValue(255);
        int alphaMask = alpha << 24 | 0xFFFFFF;
        int pixel = 0;
        for (int i = 0; i < rgbOutput.length; ++i) {
            pixel = rgbInput[i];
            rgbOutput[i] = (pixel & 0xFF000000) >>> 24 > alpha ? pixel & alphaMask : pixel;
        }
        return this.output;
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
    }

    public void releaseResources() {
        this.output = null;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.opacity = (Dimension)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.opacity, dataOutputStream);
    }
}

