/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.rgbfilters;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.RgbFilter;
import de.enough.polish.ui.Style;
import de.enough.polish.util.RgbImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GaussianBlurRgbFilter
extends RgbFilter {
    protected Dimension blur;
    protected transient RgbImage output;
    int width;
    int height;

    public boolean isActive() {
        if (this.blur == null) {
            return false;
        }
        return this.blur.getValue(255) != 0;
    }

    private RgbImage horizontalPass(RgbImage input) {
        if (!this.isActive()) {
            return input;
        }
        int[] rgbInput = input.getRgbData();
        int[] rgbOutput = this.output.getRgbData();
        int red = 0;
        int green = 0;
        int blue = 0;
        int totalPercentage = 100;
        int startY = 0;
        int endY = 0;
        int x = 0;
        int y = 0;
        int c = 0;
        int percentage = 0;
        int yTimesWidth = 0;
        int tempEnd = 0;
        int dimensionDivTwo = 0;
        int imgWidth = this.width;
        int imgHeight = this.height;
        int arraySize = imgHeight + 1;
        int[] redArray = new int[arraySize];
        int[] greenArray = new int[arraySize];
        int[] blueArray = new int[arraySize];
        int[] alphaArray = new int[arraySize];
        int dimension = this.blur.getValue(100);
        dimension = Math.max(2, imgHeight * dimension / 100);
        dimensionDivTwo = dimension / 2;
        yTimesWidth = 0;
        for (x = 0; x < imgWidth; ++x) {
            redArray[0] = 0;
            greenArray[0] = 0;
            blueArray[0] = 0;
            alphaArray[0] = 0;
            yTimesWidth = 0;
            for (y = 0; y < imgHeight; ++y) {
                c = rgbInput[x + yTimesWidth];
                percentage = c >>> 25;
                redArray[y + 1] = redArray[y] + ((c & 0xFF0000) >> 16) * percentage;
                greenArray[y + 1] = greenArray[y] + ((c & 0xFF00) >> 8) * percentage;
                blueArray[y + 1] = blueArray[y] + (c & 0xFF) * percentage;
                alphaArray[y + 1] = alphaArray[y] + percentage;
                yTimesWidth += imgWidth;
            }
            yTimesWidth = 0;
            tempEnd = dimension / 2;
            for (y = 0; y < tempEnd; ++y) {
                startY = 0;
                endY = y + tempEnd;
                totalPercentage = alphaArray[endY] - alphaArray[startY] + 1;
                red = (redArray[endY] - redArray[startY]) / totalPercentage << 16;
                green = (greenArray[endY] - greenArray[startY]) / totalPercentage << 8;
                blue = (blueArray[endY] - blueArray[startY]) / totalPercentage;
                rgbOutput[x + yTimesWidth] = rgbInput[x + yTimesWidth] & 0xFF000000 | red | green | blue;
                yTimesWidth += imgWidth;
            }
            tempEnd = imgHeight - dimension / 2;
            for (y = dimensionDivTwo; y < tempEnd; ++y) {
                startY = y - dimensionDivTwo + 1;
                endY = y + dimensionDivTwo;
                totalPercentage = alphaArray[endY] - alphaArray[startY] + 1;
                red = (redArray[endY] - redArray[startY]) / totalPercentage << 16;
                green = (greenArray[endY] - greenArray[startY]) / totalPercentage << 8;
                blue = (blueArray[endY] - blueArray[startY]) / totalPercentage;
                rgbOutput[x + yTimesWidth] = rgbInput[x + yTimesWidth] & 0xFF000000 | red | green | blue;
                yTimesWidth += imgWidth;
            }
            tempEnd = imgHeight;
            for (y = imgHeight - dimensionDivTwo; y < imgHeight; ++y) {
                startY = y - dimensionDivTwo + 1;
                endY = imgHeight;
                totalPercentage = alphaArray[endY] - alphaArray[startY] + 1;
                red = (redArray[endY] - redArray[startY]) / totalPercentage << 16;
                green = (greenArray[endY] - greenArray[startY]) / totalPercentage << 8;
                blue = (blueArray[endY] - blueArray[startY]) / totalPercentage;
                rgbOutput[x + yTimesWidth] = rgbInput[x + yTimesWidth] & 0xFF000000 | red | green | blue;
                yTimesWidth += imgWidth;
            }
        }
        return this.output;
    }

    private RgbImage verticalPass(RgbImage input) {
        if (!this.isActive()) {
            return input;
        }
        int[] rgbInput = input.getRgbData();
        int[] rgbOutput = this.output.getRgbData();
        int red = 0;
        int green = 0;
        int blue = 0;
        int totalPercentage = 100;
        int x = 0;
        int y = 0;
        int startX = 0;
        int c = 0;
        int percentage = 0;
        int yTimesWidth = 0;
        int tempEnd = 0;
        int dimensionDivTwo = 0;
        int imgWidth = this.width;
        int imgHeight = this.height;
        int arraySize = imgWidth + 1;
        int[] redArray = new int[arraySize];
        int[] greenArray = new int[arraySize];
        int[] blueArray = new int[arraySize];
        int[] alphaArray = new int[arraySize];
        int dimension = this.blur.getValue(100);
        dimension = Math.max(2, imgWidth * dimension / 100);
        dimensionDivTwo = dimension / 2;
        yTimesWidth = 0;
        for (y = 0; y < imgHeight; ++y) {
            int endX;
            redArray[0] = 0;
            greenArray[0] = 0;
            blueArray[0] = 0;
            alphaArray[0] = 0;
            for (x = 0; x < imgWidth; ++x) {
                c = rgbInput[x + yTimesWidth];
                percentage = c >>> 25;
                redArray[x + 1] = redArray[x] + ((c & 0xFF0000) >> 16) * percentage;
                greenArray[x + 1] = greenArray[x] + ((c & 0xFF00) >> 8) * percentage;
                blueArray[x + 1] = blueArray[x] + (c & 0xFF) * percentage;
                alphaArray[x + 1] = alphaArray[x] + percentage;
            }
            tempEnd = dimension / 2;
            for (x = 0; x < tempEnd; ++x) {
                startX = 0;
                endX = x + tempEnd;
                totalPercentage = alphaArray[endX] - alphaArray[startX] + 1;
                red = (redArray[endX] - redArray[startX]) / totalPercentage << 16;
                green = (greenArray[endX] - greenArray[startX]) / totalPercentage << 8;
                blue = (blueArray[endX] - blueArray[startX]) / totalPercentage;
                rgbOutput[x + yTimesWidth] = rgbInput[x + yTimesWidth] & 0xFF000000 | red | green | blue;
            }
            tempEnd = imgWidth - dimension / 2;
            for (x = dimensionDivTwo; x < tempEnd; ++x) {
                startX = x - dimensionDivTwo + 1;
                endX = x + dimensionDivTwo;
                totalPercentage = alphaArray[endX] - alphaArray[startX] + 1;
                red = (redArray[endX] - redArray[startX]) / totalPercentage << 16;
                green = (greenArray[endX] - greenArray[startX]) / totalPercentage << 8;
                blue = (blueArray[endX] - blueArray[startX]) / totalPercentage;
                rgbOutput[x + yTimesWidth] = rgbInput[x + yTimesWidth] & 0xFF000000 | red | green | blue;
            }
            tempEnd = imgWidth;
            for (x = imgWidth - dimensionDivTwo; x < imgWidth; ++x) {
                startX = x - dimensionDivTwo + 1;
                endX = imgWidth;
                totalPercentage = alphaArray[endX] - alphaArray[startX] + 1;
                red = (redArray[endX] - redArray[startX]) / totalPercentage << 16;
                green = (greenArray[endX] - greenArray[startX]) / totalPercentage << 8;
                blue = (blueArray[endX] - blueArray[startX]) / totalPercentage;
                rgbOutput[x + yTimesWidth] = rgbInput[x + yTimesWidth] & 0xFF000000 | red | green | blue;
            }
            yTimesWidth += imgWidth;
        }
        return this.output;
    }

    public final RgbImage process(RgbImage input) {
        this.width = input.getWidth();
        this.height = input.getHeight();
        if (this.output == null || this.output.getWidth() != input.getWidth() || this.output.getHeight() != input.getHeight()) {
            this.output = new RgbImage(input.getWidth(), input.getHeight());
        }
        this.output = this.verticalPass(this.horizontalPass(input));
        return this.output;
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
        Dimension blurInt = (Dimension)style.getObjectProperty(348);
        if (blurInt != null) {
            this.blur = blurInt;
        }
    }

    public void releaseResources() {
        this.output = null;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.blur = (Dimension)Serializer.deserialize(dataInputStream);
        this.height = dataInputStream.readInt();
        this.width = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.blur, dataOutputStream);
        dataOutputStream.writeInt(this.height);
        dataOutputStream.writeInt(this.width);
    }
}

