/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.itemviews;

import de.enough.polish.ui.AnimationThread;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.ImageUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class FadeOutItemView
extends ItemView {
    private int[] rgbData;
    private int currentTransparency;
    private int startTransparency = 240;
    private int endTransparency = 0;
    private int deltaTransparency = 20;

    protected void initContent(Item parent, int firstLineWidth, int availWidth, int availHeight) {
        this.currentTransparency = this.startTransparency;
        this.initContentByParent(parent, firstLineWidth, availWidth, availHeight);
        int[] itemRgbData = UiAccess.getRgbDataOfContent(parent);
        this.rgbData = itemRgbData;
        AnimationThread.addAnimationItem(parent);
    }

    public boolean animate() {
        int transparency = this.currentTransparency - this.deltaTransparency;
        if (transparency <= this.endTransparency) {
            transparency = this.endTransparency;
            AnimationThread.removeAnimationItem(this.parentItem);
        }
        this.currentTransparency = transparency;
        int[] data = this.rgbData;
        if (data != null) {
            ImageUtil.setTransparencyOnlyForOpaque(transparency, data);
        }
        return true;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    public void showNotify() {
        super.showNotify();
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (this.currentTransparency != 0) {
            DrawUtil.drawRgb(this.rgbData, x, y, this.contentWidth, this.contentHeight, true, g);
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.currentTransparency = dataInputStream.readInt();
        this.deltaTransparency = dataInputStream.readInt();
        this.endTransparency = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.rgbData = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.rgbData[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.startTransparency = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.currentTransparency);
        dataOutputStream.writeInt(this.deltaTransparency);
        dataOutputStream.writeInt(this.endTransparency);
        if (this.rgbData == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.rgbData.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.rgbData[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeInt(this.startTransparency);
    }
}

