/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.gaugeviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScanningGaugeView
extends ItemView {
    private int width = 5;
    private int height = 5;
    private int number = 4;
    private int selectedColor = 0xFF00FF;
    private int unSelectedColor = 0xFFFFFF;
    private int valuePosition = 0;
    private long animationInterval = 300L;
    private long lastAnimationTime;
    private Image selectedImage;
    private Image selectedImageRight;
    private Image selectedImageLeft;
    private int step = 1;
    private Image selectedBackgroundImage;
    private Image selectedBackgroundImageRight;
    private Image selectedBackgroundImageLeft;

    public boolean animate() {
        long time;
        boolean animated = super.animate();
        Gauge gauge = (Gauge)this.parentItem;
        if (gauge.getMaxValue() == -1 && gauge.getValue() == 2 && (time = System.currentTimeMillis()) - this.lastAnimationTime >= this.animationInterval) {
            this.lastAnimationTime = time;
            int position = this.valuePosition + this.step;
            if (position >= this.number - 1) {
                this.step *= -1;
            } else if (position <= 0) {
                this.step *= -1;
            }
            this.valuePosition = position;
            animated = true;
        }
        return animated;
    }

    protected void initContent(Item parent, int firstLineWidth, int availWidth, int availHeight) {
        int imageWidth = 0;
        int imageHeight = 0;
        if (this.selectedImageLeft != null) {
            imageWidth += this.selectedImageLeft.getWidth();
            imageHeight = Math.max(imageHeight, this.selectedImageLeft.getHeight());
        }
        if (this.selectedImage != null) {
            imageWidth += this.selectedImage.getWidth();
            imageHeight = Math.max(imageHeight, this.selectedImage.getHeight());
        }
        if (this.selectedImageRight != null) {
            imageWidth += this.selectedImageRight.getWidth();
            imageHeight = Math.max(imageHeight, this.selectedImageRight.getHeight());
        }
        if (imageWidth > 0) {
            this.width = imageWidth;
        }
        if (imageHeight > 0) {
            this.height = imageHeight;
        }
        this.contentWidth = (this.width + this.paddingHorizontal) * this.number - this.paddingHorizontal;
        this.contentHeight = this.height;
        if (this.contentWidth > availWidth) {
            this.contentWidth = availWidth;
            this.width = availWidth / this.number;
        }
        System.out.println("--------- Available Height:" + parent.itemHeight);
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        Gauge gauge = (Gauge)parent;
        int position = this.valuePosition;
        if (gauge.getMaxValue() != -1) {
            int valuePercent = gauge.getValue() * 100 / gauge.getMaxValue();
            position = valuePercent * this.number / 100;
        }
        int backRight = rightBorder;
        int backX = leftBorder;
        if (this.selectedBackgroundImageLeft != null) {
            g.drawImage(this.selectedBackgroundImageLeft, backX, y, 20);
            backX += this.selectedBackgroundImageLeft.getWidth();
        }
        if (this.selectedBackgroundImageRight != null) {
            g.drawImage(this.selectedBackgroundImageRight, rightBorder - this.selectedBackgroundImageRight.getWidth(), y, 20);
            backRight -= this.selectedBackgroundImageRight.getWidth();
        }
        if (this.selectedBackgroundImage != null) {
            while (backX < backRight) {
                g.drawImage(this.selectedBackgroundImage, backX, y, 20);
                backX += this.selectedBackgroundImage.getWidth();
            }
        }
        int imageWidth = 0;
        if (this.selectedImageLeft != null) {
            imageWidth += this.selectedImageLeft.getWidth();
        }
        if (this.selectedImage != null) {
            imageWidth += this.selectedImage.getWidth();
        }
        if (this.selectedImageRight != null) {
            imageWidth += this.selectedImageRight.getWidth();
        }
        int pixelStep = (this.contentWidth - imageWidth) / (this.number - 1);
        System.out.println("PixelStep: " + pixelStep + "ImageWidth: " + imageWidth + " Position: " + position);
        for (int i = 0; i < this.number; ++i) {
            int newX = x + leftBorder;
            if (i == position) {
                int imageOffset = 0;
                if (this.selectedImageLeft != null) {
                    imageOffset = this.selectedImageLeft.getWidth();
                    g.drawImage(this.selectedImageLeft, newX + pixelStep * i, y, 20);
                }
                if (this.selectedImage != null) {
                    g.drawImage(this.selectedImage, newX + pixelStep * i + imageOffset, y, 20);
                    imageOffset += this.selectedImage.getWidth();
                } else {
                    g.setColor(this.selectedColor);
                    g.fillRect(newX + this.width * i, y, this.width, this.height);
                }
                if (this.selectedImageRight == null) continue;
                g.drawImage(this.selectedImageRight, newX + pixelStep * i + imageOffset, y, 20);
                continue;
            }
            g.setColor(this.unSelectedColor);
        }
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    protected boolean isValid(Item parent, Style style) {
        return parent instanceof Gauge;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.animationInterval = dataInputStream.readLong();
        this.height = dataInputStream.readInt();
        this.lastAnimationTime = dataInputStream.readLong();
        this.number = dataInputStream.readInt();
        this.selectedBackgroundImage = (Image)Serializer.deserialize(dataInputStream);
        this.selectedBackgroundImageLeft = (Image)Serializer.deserialize(dataInputStream);
        this.selectedBackgroundImageRight = (Image)Serializer.deserialize(dataInputStream);
        this.selectedColor = dataInputStream.readInt();
        this.selectedImage = (Image)Serializer.deserialize(dataInputStream);
        this.selectedImageLeft = (Image)Serializer.deserialize(dataInputStream);
        this.selectedImageRight = (Image)Serializer.deserialize(dataInputStream);
        this.step = dataInputStream.readInt();
        this.unSelectedColor = dataInputStream.readInt();
        this.valuePosition = dataInputStream.readInt();
        this.width = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeLong(this.animationInterval);
        dataOutputStream.writeInt(this.height);
        dataOutputStream.writeLong(this.lastAnimationTime);
        dataOutputStream.writeInt(this.number);
        Serializer.serialize(this.selectedBackgroundImage, dataOutputStream);
        Serializer.serialize(this.selectedBackgroundImageLeft, dataOutputStream);
        Serializer.serialize(this.selectedBackgroundImageRight, dataOutputStream);
        dataOutputStream.writeInt(this.selectedColor);
        Serializer.serialize(this.selectedImage, dataOutputStream);
        Serializer.serialize(this.selectedImageLeft, dataOutputStream);
        Serializer.serialize(this.selectedImageRight, dataOutputStream);
        dataOutputStream.writeInt(this.step);
        dataOutputStream.writeInt(this.unSelectedColor);
        dataOutputStream.writeInt(this.valuePosition);
        dataOutputStream.writeInt(this.width);
    }
}

