/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.gaugeviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Style;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class RotatingCirclesGaugeView
extends ItemView {
    private int[] xCord = new int[12];
    private int[] yCord = new int[12];
    int arrayIndex = 0;
    private static int[] sinetable = new int[]{0, 286, 572, 857, 1143, 1428, 1713, 1997, 2280, 2563, 2845, 3126, 3406, 3686, 3964, 4240, 4516, 4790, 5063, 5334, 5604, 5872, 6138, 6402, 6664, 6924, 7182, 7438, 7692, 7943, 8192, 8438, 8682, 8923, 9162, 9397, 9630, 9860, 10087, 10311, 10531, 10749, 10963, 11174, 11381, 11585, 11786, 11982, 12176, 12365, 12551, 12733, 12911, 13085, 13255, 13421, 13583, 13741, 13894, 14044, 14189, 14330, 14466, 14598, 14726, 14849, 14968, 15082, 15191, 15296, 15396, 15491, 15582, 15668, 15749, 15826, 15897, 15964, 16026, 16083, 16135, 16182, 16225, 16262, 16294, 16322, 16344, 16362, 16374, 16382, 16384};
    private int sineval = 0;
    private int cosval = 0;
    private int colorStart;
    private Dimension maxWidth;
    private int colorEnd = 0x666666;
    private int[] colors;

    private void setSinCosValues(int currentAngle) {
        if (currentAngle > 360 && (currentAngle -= 360) >= 360) {
            this.sineval = 0;
            this.cosval = 0;
            return;
        }
        if (currentAngle >= 270) {
            currentAngle -= 360;
            currentAngle = 0 - currentAngle;
            this.sineval = 0 - sinetable[currentAngle];
            currentAngle -= 90;
            currentAngle = 0 - currentAngle;
            this.cosval = sinetable[currentAngle];
            return;
        }
        if (currentAngle >= 180) {
            this.sineval = 0 - sinetable[currentAngle -= 180];
            currentAngle -= 90;
            currentAngle = 0 - currentAngle;
            this.cosval = 0 - sinetable[currentAngle];
            return;
        }
        if (currentAngle >= 90) {
            currentAngle -= 180;
            currentAngle = 0 - currentAngle;
            this.sineval = sinetable[currentAngle];
            currentAngle -= 90;
            currentAngle = 0 - currentAngle;
            this.cosval = 0 - sinetable[currentAngle];
            return;
        }
        if (currentAngle < 90) {
            this.sineval = sinetable[currentAngle];
            currentAngle -= 90;
            currentAngle = 0 - currentAngle;
            this.cosval = sinetable[currentAngle];
            return;
        }
    }

    protected void setStyle(Style style, boolean resetStyle) {
        Dimension widthInt;
        super.setStyle(style, resetStyle);
        boolean changed = false;
        if (changed) {
            this.colors = DrawUtil.getGradient(this.colorStart, this.colorEnd, 6);
        }
        if ((widthInt = (Dimension)style.getObjectProperty(59)) != null) {
            this.maxWidth = widthInt;
        }
    }

    protected void initContent(Item parent, int firstLineWidth, int availWidth, int availHeight) {
        int i;
        if (this.maxWidth != null) {
            this.contentWidth = this.maxWidth.getValue(availWidth);
            this.contentHeight = this.maxWidth.getValue(availWidth);
        } else {
            this.contentWidth = availWidth / 2;
            this.contentHeight = availWidth / 2;
        }
        int max = 0;
        int angle = 0;
        int x = 100;
        int y = 100;
        int xOffset = 0;
        int yOffset = 0;
        for (i = 0; i < 12; ++i) {
            if (angle >= 360) {
                angle = 0;
                x = 98;
                y = 98;
            }
            this.setSinCosValues(angle);
            xOffset = this.sineval * 20;
            yOffset = this.cosval * 20;
            this.xCord[i] = x += xOffset >> 14;
            this.yCord[i] = y += yOffset >> 14;
            if (x > max) {
                max = x;
            }
            if (y > max) {
                max = y;
            }
            angle += 60;
        }
        for (i = 0; i < 12; ++i) {
            this.xCord[i] = this.xCord[i] * this.contentWidth / max - 50;
            this.yCord[i] = this.yCord[i] * this.contentWidth / max - 50;
        }
        if (this.colors == null) {
            this.colors = DrawUtil.getGradient(this.colorStart, this.colorEnd, 6);
        }
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        g.setColor(this.colors[0]);
        g.fillArc(x + this.xCord[this.arrayIndex], y + this.yCord[this.arrayIndex], 16, 16, 0, 360);
        g.drawArc(x + this.xCord[this.arrayIndex], y + this.yCord[this.arrayIndex], 16, 16, 0, 360);
        g.setColor(this.colors[1]);
        g.fillArc(x + this.xCord[this.arrayIndex + 1], y + this.yCord[this.arrayIndex + 1], 13, 13, 0, 360);
        g.drawArc(x + this.xCord[this.arrayIndex + 1], y + this.yCord[this.arrayIndex + 1], 13, 13, 0, 360);
        g.setColor(this.colors[2]);
        g.fillArc(x + this.xCord[this.arrayIndex + 2], y + this.yCord[this.arrayIndex + 2], 10, 10, 0, 360);
        g.drawArc(x + this.xCord[this.arrayIndex + 2], y + this.yCord[this.arrayIndex + 2], 10, 10, 0, 360);
        g.setColor(this.colors[3]);
        g.fillArc(x + this.xCord[this.arrayIndex + 3], y + this.yCord[this.arrayIndex + 3], 7, 7, 0, 360);
        g.drawArc(x + this.xCord[this.arrayIndex + 3], y + this.yCord[this.arrayIndex + 3], 7, 7, 0, 360);
        g.setColor(this.colors[4]);
        g.fillArc(x + this.xCord[this.arrayIndex + 4], y + this.yCord[this.arrayIndex + 4], 5, 5, 0, 360);
        g.drawArc(x + this.xCord[this.arrayIndex + 4], y + this.yCord[this.arrayIndex + 4], 5, 5, 0, 360);
        g.setColor(this.colors[5]);
        g.fillArc(x + this.xCord[this.arrayIndex + 5], y + this.yCord[this.arrayIndex + 5], 2, 2, 0, 360);
        g.drawArc(x + this.xCord[this.arrayIndex + 5], y + this.yCord[this.arrayIndex + 5], 2, 2, 0, 360);
    }

    public boolean animate() {
        ++this.arrayIndex;
        if (this.arrayIndex > 5) {
            this.arrayIndex = 0;
        }
        return true;
    }

    protected boolean isValid(Item parent, Style style) {
        return parent instanceof Gauge;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.arrayIndex = dataInputStream.readInt();
        this.colorEnd = dataInputStream.readInt();
        this.colorStart = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.colors = new int[n2];
            n = 0;
            while (n < n2) {
                this.colors[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.cosval = dataInputStream.readInt();
        this.maxWidth = (Dimension)Serializer.deserialize(dataInputStream);
        this.sineval = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.xCord = new int[n2];
            n = 0;
            while (n < n2) {
                this.xCord[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.yCord = new int[n2];
            n = 0;
            while (n < n2) {
                this.yCord[n] = dataInputStream.readInt();
                ++n;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arrayIndex);
        dataOutputStream.writeInt(this.colorEnd);
        dataOutputStream.writeInt(this.colorStart);
        if (this.colors == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.colors.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.colors[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.cosval);
        Serializer.serialize(this.maxWidth, dataOutputStream);
        dataOutputStream.writeInt(this.sineval);
        if (this.xCord == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.xCord.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.xCord[n]);
                ++n;
            }
        }
        if (this.yCord == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.yCord.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.yCord[n]);
                ++n;
            }
        }
    }
}

