/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.gaugeviews;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Style;
import de.enough.polish.util.Debug;
import de.enough.polish.util.TextUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImagesGaugeView
extends ItemView {
    transient Gauge gauge;
    boolean isContinuousRunning;
    transient Image[] images;
    int current = 0;
    int interval = 500;
    long lastAnimationTime = 0L;

    protected void initContent(Item parent, int firstLineWidth, int availWidth, int availHeight) {
        this.gauge = (Gauge)parent;
        boolean bl = this.isContinuousRunning = this.gauge.getMaxValue() == -1 && this.gauge.getValue() == 2;
        if (this.images == null) {
            Debug.debug("error", "de.enough.polish.ui.gaugeviews.ImagesGaugeView", 95, (Object)("Unable to initialize ImageGaugeView with style " + (parent.getStyle() == null ? "<null>" : parent.getStyle().name)), ": no gauge-images-sources defined.");
            return;
        }
        int maxHeight = 0;
        int maxWidth = 0;
        for (int i = 0; i < this.images.length; ++i) {
            Image image = this.images[i];
            int width = image.getWidth();
            int height = image.getWidth();
            if (width > maxWidth) {
                maxWidth = width;
            }
            if (height <= maxHeight) continue;
            maxHeight = height;
        }
        this.contentHeight = maxHeight;
        this.contentWidth = maxWidth;
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        if (this.isContinuousRunning) {
            if (this.lastAnimationTime == -1L) {
                this.lastAnimationTime = currentTime;
            }
            if (currentTime - this.lastAnimationTime > (long)this.interval && this.images != null) {
                this.current = (this.current + 1) % this.images.length;
                this.lastAnimationTime = currentTime;
                this.addFullRepaintRegion(this.parentItem, repaintRegion);
            }
        }
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, Graphics g) {
        g.drawImage(this.images[this.current], x, y, 20);
    }

    protected void setStyle(Style style, boolean resetStyle) {
        Integer intervalObj;
        super.setStyle(style, resetStyle);
        String sources = style.getProperty(367);
        if (sources != null) {
            this.setImages(sources);
        }
        if ((intervalObj = style.getIntProperty(368)) != null) {
            this.interval = intervalObj;
        }
        if (this.images == null) {
            Debug.debug("error", "de.enough.polish.ui.gaugeviews.ImagesGaugeView", 176, "no images set for image gauge");
        }
    }

    void setImages(String sources) {
        String[] urls = TextUtil.split(sources, ',');
        this.images = new Image[urls.length];
        String image = null;
        try {
            for (int i = 0; i < urls.length; ++i) {
                image = urls[i].trim();
                if (image.charAt(0) != '/') {
                    image = "/" + image;
                }
                this.images[i] = Image.createImage(image);
            }
        }
        catch (IOException e) {
            Debug.debug("error", "de.enough.polish.ui.gaugeviews.ImagesGaugeView", 203, (Object)("unable to read image " + image + " : "), e.toString());
            this.images = null;
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.current = dataInputStream.readInt();
        this.interval = dataInputStream.readInt();
        this.isContinuousRunning = dataInputStream.readBoolean();
        this.lastAnimationTime = dataInputStream.readLong();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.current);
        dataOutputStream.writeInt(this.interval);
        dataOutputStream.writeBoolean(this.isContinuousRunning);
        dataOutputStream.writeLong(this.lastAnimationTime);
    }
}

