/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.gaugeviews;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Gauge;
import de.enough.polish.ui.Graphics;
import de.enough.polish.ui.Image;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.Point;
import de.enough.polish.ui.Style;
import de.enough.polish.util.MathUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClockInstrumentGaugeView
extends ItemView {
    transient Image backgroundImage = null;
    transient Image needleImage = null;
    transient Image needleShadowImage = null;
    int needleX = -1;
    int needleY = -1;
    int needleCenterX = -1;
    int needleCenterY = -1;
    int shadowCenterX = -1;
    int shadowCenterY = -1;
    int shadowOffsetX = 0;
    int shadowOffsetY = 0;
    int startAngle = 180;
    int endAngle = 0;
    long lastAnimationTime = 0L;
    transient Gauge gauge = null;

    protected void initContent(Item parent, int firstLineWidth, int availWidth, int availHeight) {
        this.gauge = (Gauge)parent;
        this.contentWidth = this.backgroundImage.getWidth();
        this.contentHeight = this.backgroundImage.getHeight();
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    protected void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
        this.removeParentBackground();
        this.removeParentBorder();
        Object currentFilters = null;
    }

    protected void paintContent(Item parent, int x, int y, int leftBorder, int rightBorder, javax.microedition.lcdui.Graphics g) {
        Graphics graphics = new Graphics(g);
        double degreesPerTick = 1.0 * (double)(this.endAngle - this.startAngle) / (double)this.gauge.getMaxValue();
        int currentAngle = this.startAngle + (int)(degreesPerTick * (double)this.gauge.getValue());
        int bgLeft = x + (this.contentWidth - this.backgroundImage.getWidth()) / 2;
        int bgTop = y + (this.contentHeight - this.backgroundImage.getHeight()) / 2;
        Object rgbImage = null;
        graphics.drawImage(this.backgroundImage, bgLeft, bgTop, 20);
        if (this.needleShadowImage != null) {
            graphics.drawRotatedImage(this.needleShadowImage, this.shadowCenterX, this.shadowCenterY, bgLeft + this.needleX + this.shadowOffsetX, bgTop + this.needleY + this.shadowOffsetY, currentAngle);
        }
        graphics.drawRotatedImage(this.needleImage, this.needleCenterX, this.needleCenterY, bgLeft + this.needleX, bgTop + this.needleY, currentAngle);
    }

    protected void valueBasedOnPointerPosition(int x, int y) {
        boolean anglesHaveDifferentSigns;
        Point p = this.adjustToContentArea(x, y);
        x = p.x;
        y = p.y;
        int bgLeft = (this.contentWidth - this.backgroundImage.getWidth()) / 2;
        int bgTop = (this.contentHeight - this.backgroundImage.getHeight()) / 2;
        int ndlX = bgLeft + this.needleX;
        int ndlY = bgTop + this.needleY;
        int dX = x - ndlX;
        int dY = ndlY - y;
        int angle = (int)(MathUtil.atan2(dX, dY) * 180.0 / Math.PI);
        int processedStartAngle = this.startAngle;
        int processedEndAngle = this.endAngle;
        int totalArcLength = Math.abs(processedEndAngle - processedStartAngle);
        boolean initialArcFollowsTrigonometricDirection = this.startAngle <= this.endAngle;
        boolean bl = anglesHaveDifferentSigns = processedStartAngle * processedEndAngle <= 0;
        if (!initialArcFollowsTrigonometricDirection) {
            int temp = processedStartAngle;
            processedStartAngle = processedEndAngle;
            processedEndAngle = temp;
        }
        processedStartAngle = (360 + processedStartAngle) % 360;
        processedEndAngle = (360 + processedEndAngle) % 360;
        int newGaugeValue = 0;
        int arcType = 0;
        boolean isInsideArc = false;
        if (anglesHaveDifferentSigns) {
            if (angle >= processedStartAngle || angle <= processedEndAngle) {
                isInsideArc = true;
                arcType = 1;
            }
        } else if (angle >= processedStartAngle && angle <= processedEndAngle) {
            isInsideArc = true;
            arcType = 2;
        }
        if (isInsideArc) {
            int semiArcLength = 0;
            if (arcType == 2) {
                semiArcLength = initialArcFollowsTrigonometricDirection ? Math.abs(angle - processedStartAngle) : Math.abs(angle - processedEndAngle);
                newGaugeValue = this.gauge.getMaxValue() * semiArcLength / totalArcLength;
            } else {
                semiArcLength = angle >= processedStartAngle ? (initialArcFollowsTrigonometricDirection ? Math.abs(angle - processedStartAngle) : totalArcLength - Math.abs(angle - processedStartAngle)) : (initialArcFollowsTrigonometricDirection ? totalArcLength - Math.abs(angle - processedEndAngle) : Math.abs(angle - processedEndAngle));
                newGaugeValue = this.gauge.getMaxValue() * semiArcLength / totalArcLength;
            }
            this.gauge.setValue(newGaugeValue);
        }
    }

    public boolean handlePointerDragged(int x, int y, ClippingRegion repaintRegion) {
        if (this.gauge.isInteractive()) {
            this.valueBasedOnPointerPosition(x, y);
            this.addFullRepaintRegion(this.gauge, repaintRegion);
            return true;
        }
        return false;
    }

    public boolean handlePointerPressed(int x, int y) {
        if (this.gauge.isInteractive()) {
            this.valueBasedOnPointerPosition(x, y);
            return true;
        }
        return false;
    }

    public boolean handlePointerReleased(int x, int y) {
        if (this.gauge.isInteractive()) {
            this.valueBasedOnPointerPosition(x, y);
            return true;
        }
        return false;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.endAngle = dataInputStream.readInt();
        this.lastAnimationTime = dataInputStream.readLong();
        this.needleCenterX = dataInputStream.readInt();
        this.needleCenterY = dataInputStream.readInt();
        this.needleX = dataInputStream.readInt();
        this.needleY = dataInputStream.readInt();
        this.shadowCenterX = dataInputStream.readInt();
        this.shadowCenterY = dataInputStream.readInt();
        this.shadowOffsetX = dataInputStream.readInt();
        this.shadowOffsetY = dataInputStream.readInt();
        this.startAngle = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.endAngle);
        dataOutputStream.writeLong(this.lastAnimationTime);
        dataOutputStream.writeInt(this.needleCenterX);
        dataOutputStream.writeInt(this.needleCenterY);
        dataOutputStream.writeInt(this.needleX);
        dataOutputStream.writeInt(this.needleY);
        dataOutputStream.writeInt(this.shadowCenterX);
        dataOutputStream.writeInt(this.shadowCenterY);
        dataOutputStream.writeInt(this.shadowOffsetX);
        dataOutputStream.writeInt(this.shadowOffsetY);
        dataOutputStream.writeInt(this.startAngle);
    }
}

