/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.cssanimations;

import de.enough.polish.ui.CssAnimation;
import de.enough.polish.ui.Style;

public class CombinedCssAnimation
extends CssAnimation {
    private final CssAnimation[] animations;

    public CombinedCssAnimation(int cssAttributeId, String triggerEvent, long duration, long delay, int function, int repeat, String fireEvent, CssAnimation[] animations) {
        super(cssAttributeId, triggerEvent, duration, delay, function, repeat, fireEvent, animations[0].getStartValue(), animations[animations.length - 1].getEndValue());
        this.animations = animations;
    }

    public Object animate(Style style, Object styleValue, long passedTime) {
        for (int i = 0; i < this.animations.length; ++i) {
            CssAnimation animation = this.animations[i];
            long animationDelay = animation.getDelay();
            long animationDuration = animation.getDuration();
            if (passedTime < animationDelay) {
                return styleValue;
            }
            if (passedTime <= animationDelay + animationDuration) {
                Object value = animation.animate(style, styleValue, passedTime -= animationDelay);
                if (value == ANIMATION_FINISHED && i < this.animations.length - 1) {
                    return styleValue;
                }
                return value;
            }
            passedTime -= animationDelay + animationDuration;
        }
        return ANIMATION_FINISHED;
    }
}

