/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class ShuffleView
extends ContainerView {
    private int speed = -1;
    private boolean animationInitialised;
    private boolean isAnimationRunning;
    private int[] xAdjustments;

    protected void initContent(Item parentItm, int firstLineWidth, int availWidth, int availHeight) {
        super.initContent(parentItm, firstLineWidth, availWidth, availHeight);
        if (!this.animationInitialised) {
            Container parent = (Container)parentItm;
            Item[] myItems = parent.getItems();
            this.xAdjustments = new int[myItems.length];
            this.initAnimation(myItems, this.xAdjustments);
        }
    }

    protected void paintItem(Item item, int index, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        super.paintItem(item, index, x -= this.xAdjustments[index], y, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    private void initAnimation(Item[] items, int[] xValues) {
        int factor = 1;
        int column = 0;
        for (int i = 0; i < xValues.length; ++i) {
            xValues[i] = this.contentWidth * factor;
            if (++column < this.numberOfColumns) continue;
            factor *= -1;
            column = 0;
        }
        this.isAnimationRunning = true;
        this.animationInitialised = true;
    }

    public boolean animate() {
        if (this.isAnimationRunning) {
            int counter = 0;
            for (int i = 0; i < this.xAdjustments.length; ++i) {
                int adjustment;
                int x = this.xAdjustments[i];
                if (x < 0) {
                    adjustment = this.speed;
                    if (adjustment == -1 && (adjustment = -x / 3) < 3) {
                        adjustment = 3;
                    }
                    if ((x += adjustment) > 0) {
                        x = 0;
                    }
                } else if (x > 0) {
                    adjustment = this.speed;
                    if (adjustment == -1 && (adjustment = x / 3) < 3) {
                        adjustment = 3;
                    }
                    if ((x -= adjustment) < 0) {
                        x = 0;
                    }
                } else {
                    ++counter;
                }
                this.xAdjustments[i] = x;
            }
            this.isAnimationRunning = counter < this.xAdjustments.length;
            return true;
        }
        return false;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.animationInitialised = dataInputStream.readBoolean();
        this.isAnimationRunning = dataInputStream.readBoolean();
        this.speed = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.xAdjustments = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.xAdjustments[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.animationInitialised);
        dataOutputStream.writeBoolean(this.isAnimationRunning);
        dataOutputStream.writeInt(this.speed);
        if (this.xAdjustments == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.xAdjustments.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.xAdjustments[n2]);
                ++n2;
            }
        }
    }
}

