/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class RemoveTextContainerView
extends ContainerView {
    private static final int POSITION_BOTTOM = 0;
    private static final int POSITION_TOP = 1;
    protected boolean isRemoveText = true;
    protected boolean isShowTextInTitle;
    protected String[] labels;
    protected transient StringItem removeTextItem;

    protected void initContent(Item parentContainerItem, int firstLineWidth, int availWidth, int availHeight) {
        Container parent;
        this.isVertical = false;
        this.isHorizontal = true;
        this.parentContainer = parent = (Container)parentContainerItem;
        Item[] myItems = parent.getItems();
        int length = myItems.length;
        if (this.focusedIndex == -1 && length != 0) {
            this.focusedIndex = parent.focusedIndex != -1 ? parent.focusedIndex : 0;
            this.focusedItem = myItems[this.focusedIndex];
        }
        if (this.isRemoveText && this.removeTextItem == null) {
            this.removeTextItem = new StringItem(null, null);
        }
        if (this.isRemoveText && (this.labels == null || this.labels.length != length)) {
            this.labels = new String[length];
        }
        String longestText = null;
        if (this.isRemoveText) {
            for (int i = 0; i < length; ++i) {
                IconItem iconItem;
                Item item = myItems[i];
                String text = item.getLabel();
                if (text != null) {
                    this.labels[i] = text;
                    item.setLabel(null);
                } else if (item instanceof IconItem && (text = (iconItem = (IconItem)item).getText()) != null) {
                    this.labels[i] = text;
                    iconItem.setTextVisible(false);
                }
                if (text == null) {
                    text = this.labels[i];
                }
                if (text == null || longestText != null && longestText.length() >= text.length()) continue;
                longestText = text;
            }
        }
        super.initContent(parentContainerItem, firstLineWidth, availWidth, availHeight);
        if (this.removeTextItem != null) {
            int height;
            if (this.isFocused && this.removeTextItem.getText() == null && this.focusedIndex != -1 && this.focusedItem != null) {
                this.removeTextItem.setText(this.labels[this.focusedIndex]);
                if (this.removeTextItem.getStyle() != this.focusedItem.getStyle()) {
                    this.removeTextItem.setStyle(this.focusedItem.getStyle());
                    this.removeItemBackground(this.removeTextItem);
                    this.removeItemBorder(this.removeTextItem);
                }
            }
            if (this.removeTextItem.getText() == null) {
                this.removeTextItem.setText(longestText);
                height = this.removeTextItem.getItemHeight(availWidth, availWidth, availHeight);
                this.removeTextItem.setText(null);
            } else {
                height = this.removeTextItem.getItemHeight(availWidth, availWidth, availHeight);
            }
            this.removeTextItem.relativeY = this.contentHeight + this.paddingVertical;
            this.contentHeight += height + this.paddingVertical;
            if (this.removeTextItem.itemWidth > this.contentWidth) {
                this.contentWidth = this.removeTextItem.itemWidth;
            }
        }
    }

    public Style focusItem(int focIndex, Item item, int direction, Style focStyle) {
        if (this.labels == null) {
            return super.focusItem(focIndex, item, direction, focStyle);
        }
        if (this.isRemoveText) {
            if (this.isShowTextInTitle) {
                Screen scr = this.getScreen();
                if (scr != null) {
                    scr.setTitle(this.labels[focIndex]);
                }
            } else if (this.removeTextItem != null) {
                this.removeTextItem.setText(this.labels[focIndex]);
                if (this.removeTextItem.getStyle() != item.getStyle()) {
                    this.removeTextItem.setStyle(item.getStyle());
                    this.removeItemBackground(this.removeTextItem);
                    this.removeItemBorder(this.removeTextItem);
                }
            }
        }
        return super.focusItem(focIndex, item, direction, focStyle);
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        if (this.removeTextItem != null) {
            this.removeTextItem.paint(x + this.removeTextItem.relativeX, y + this.removeTextItem.relativeY, leftBorder, rightBorder, g);
        }
        super.paintContent(container, myItems, x, y, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    protected void defocus(Style originalStyle) {
        super.defocus(originalStyle);
        if (this.removeTextItem != null) {
            this.removeTextItem.setText(null);
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.isRemoveText = dataInputStream.readBoolean();
        this.isShowTextInTitle = dataInputStream.readBoolean();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.labels = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.labels[n2] = (String)Serializer.deserialize(dataInputStream);
                ++n2;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.isRemoveText);
        dataOutputStream.writeBoolean(this.isShowTextInTitle);
        if (this.labels == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.labels.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                Serializer.serialize(this.labels[n2], dataOutputStream);
                ++n2;
            }
        }
    }
}

