/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HorizontalContainerView
extends ContainerView {
    private static final int DISTRIBUTE_EQUALS = 1;
    private boolean allowRoundTrip;
    private boolean isExpandRightLayout;
    private boolean isClippingRequired;
    private Image arrowRight;
    private Image arrowLeft;
    private int arrowLeftYAdjust;
    private int arrowRightYAdjust;

    public HorizontalContainerView() {
        this.allowsAutoTraversal = false;
        this.isHorizontal = true;
        this.isVertical = false;
    }

    protected void initContent(Item parentItm, int firstLineWidth, int availWidth, int availHeight) {
        Item item;
        int i;
        Container parent = (Container)parentItm;
        this.availableWidth = availWidth;
        int arrowWidth = 0;
        if (this.arrowLeft != null && this.arrowRight != null) {
            arrowWidth = this.arrowLeft.getWidth() + this.arrowRight.getWidth() + this.paddingHorizontal * 2;
            availWidth -= arrowWidth;
            firstLineWidth -= arrowWidth;
        }
        int selectedItemIndex = parent.getFocusedIndex();
        int maxHeight = 0;
        int completeWidth = 0;
        if (arrowWidth > 0) {
            completeWidth = this.arrowLeft.getWidth() + this.paddingHorizontal;
        }
        Item[] items = parent.getItems();
        int availItemWidth = availWidth;
        boolean availItemWidthWithPaddingShift8 = false;
        for (i = 0; i < items.length; ++i) {
            boolean isLast;
            item = items[i];
            int itemHeight = item.getItemHeight(availItemWidth, availItemWidth, availHeight);
            int itemWidth = item.itemWidth;
            if (itemHeight > maxHeight) {
                maxHeight = itemHeight;
            }
            boolean bl = isLast = i == items.length - 1;
            if (isLast && item.isLayoutRight() && completeWidth + item.itemWidth < availWidth) {
                completeWidth = availWidth - item.itemWidth;
            }
            int startX = completeWidth;
            item.relativeX = completeWidth;
            item.relativeY = 0;
            completeWidth += itemWidth + (isLast ? 0 : this.paddingHorizontal);
            if (i == selectedItemIndex) {
                if (startX + this.getScrollXOffset() < 0) {
                    this.setScrollXOffset(-startX, true);
                } else if (completeWidth + this.getScrollTargetXOffset() > availWidth) {
                    this.setScrollXOffset(availWidth - completeWidth, true);
                }
                this.focusedItem = item;
            }
            if (item.appearanceMode == 0) continue;
            this.appearanceMode = 3;
        }
        for (i = 0; i < items.length; ++i) {
            item = items[i];
            if (item.isLayoutVerticalCenter()) {
                item.relativeY += maxHeight - item.itemHeight >> 1;
            } else if (item.isLayoutBottom()) {
                item.relativeY += maxHeight - item.itemHeight;
            }
            if (i != items.length - 1 || !item.isLayoutRight() || completeWidth >= availWidth) continue;
            item.relativeX = availWidth - item.itemWidth;
            completeWidth = availWidth;
        }
        this.contentHeight = maxHeight;
        if (arrowWidth > 0) {
            if (parent.isLayoutVerticalCenter()) {
                this.arrowLeftYAdjust = (maxHeight - this.arrowLeft.getHeight()) / 2;
                this.arrowRightYAdjust = (maxHeight - this.arrowRight.getHeight()) / 2;
            } else if (parent.isLayoutBottom()) {
                this.arrowLeftYAdjust = maxHeight - this.arrowLeft.getHeight();
                this.arrowRightYAdjust = maxHeight - this.arrowRight.getHeight();
            }
        }
        this.isClippingRequired = completeWidth > availWidth;
        if (arrowWidth > 0) {
            completeWidth += this.arrowRight.getWidth() + this.paddingHorizontal;
        }
        this.contentWidth = completeWidth;
        this.isExpandRightLayout = parent.isLayoutRight() && parent.isLayoutExpand();
    }

    public Style focusItem(int focIndex, Item item, int direction, Style focStyle) {
        if (item != null) {
            if (this.isClippingRequired) {
                int leftStart = 0;
                Image right = this.arrowRight;
                Image left = this.arrowLeft;
                boolean paintArrows = right != null && left != null;
                int availWidth = this.availableWidth;
                if (paintArrows) {
                    leftStart = left.getWidth() + this.paddingHorizontal;
                    availWidth -= right.getWidth() + this.paddingHorizontal;
                }
                int scrollXOffset = this.getScrollTargetXOffset();
                int targetScrollXOffset = -1;
                if (scrollXOffset + item.relativeX < leftStart) {
                    targetScrollXOffset = leftStart - item.relativeX;
                } else if (scrollXOffset + item.relativeX + item.itemWidth > availWidth) {
                    targetScrollXOffset = availWidth - item.relativeX - item.itemWidth;
                }
                if (targetScrollXOffset != -1) {
                    this.setScrollXOffset(targetScrollXOffset, true);
                }
            }
            return super.focusItem(focIndex, item, direction, focStyle);
        }
        return null;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    public boolean setArrowRight(String urlRight) {
        if (urlRight == null) {
            this.setArrowRight((Image)null);
        }
        try {
            this.setArrowRight(StyleSheet.getImage(urlRight, null, false));
            return true;
        }
        catch (IOException e) {
            Debug.debug("error", "de.enough.polish.ui.containerviews.HorizontalContainerView", 359, (Object)("Unable to load image " + urlRight), e);
            return false;
        }
    }

    public void setArrowRight(Image image) {
        this.arrowRight = image;
    }

    public boolean setArrowLeft(String urlLeft) {
        if (urlLeft == null) {
            this.setArrowLeft((Image)null);
        }
        try {
            this.setArrowLeft(StyleSheet.getImage(urlLeft, null, false));
            return true;
        }
        catch (IOException e) {
            Debug.debug("error", "de.enough.polish.ui.containerviews.HorizontalContainerView", 385, (Object)("Unable to load image " + urlLeft), e);
            return false;
        }
    }

    public void setArrowLeft(Image image) {
        this.arrowLeft = image;
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        boolean paintArrows;
        if (this.isExpandRightLayout) {
            x = rightBorder - this.contentWidth;
        }
        Image right = this.arrowRight;
        Image left = this.arrowLeft;
        boolean bl = paintArrows = right != null && left != null;
        if (paintArrows) {
            x += left.getWidth() + this.paddingHorizontal;
            rightBorder -= right.getWidth() + this.paddingHorizontal;
        }
        if (this.isClippingRequired) {
            g.clipRect(x, y, rightBorder - x, this.contentHeight + 1);
        }
        if (paintArrows) {
            x -= left.getWidth() + this.paddingHorizontal;
        }
        super.paintContent(container, myItems, x, y, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
        if (this.isClippingRequired) {
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
        if (paintArrows) {
            if (container.isLayoutExpand()) {
                g.drawImage(left, leftBorder, y + this.arrowLeftYAdjust, 20);
                g.drawImage(right, rightBorder += this.paddingHorizontal, y + this.arrowRightYAdjust, 20);
            } else {
                g.drawImage(left, x, y + this.arrowLeftYAdjust, 20);
                g.drawImage(right, x + this.contentWidth, y + this.arrowRightYAdjust, 24);
            }
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.allowRoundTrip = dataInputStream.readBoolean();
        this.arrowLeft = (Image)Serializer.deserialize(dataInputStream);
        this.arrowLeftYAdjust = dataInputStream.readInt();
        this.arrowRight = (Image)Serializer.deserialize(dataInputStream);
        this.arrowRightYAdjust = dataInputStream.readInt();
        this.isClippingRequired = dataInputStream.readBoolean();
        this.isExpandRightLayout = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.allowRoundTrip);
        Serializer.serialize(this.arrowLeft, dataOutputStream);
        dataOutputStream.writeInt(this.arrowLeftYAdjust);
        Serializer.serialize(this.arrowRight, dataOutputStream);
        dataOutputStream.writeInt(this.arrowRightYAdjust);
        dataOutputStream.writeBoolean(this.isClippingRequired);
        dataOutputStream.writeBoolean(this.isExpandRightLayout);
    }
}

