/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.borders;

import de.enough.polish.ui.Border;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class TopBorder
extends Border {
    private int color;
    private boolean isArgb;

    public TopBorder(int color2, int borderWidth) {
        super(0, 0, borderWidth, 0);
        this.color = color2;
        this.isArgb = (color2 & 0xFF000000) != 0 && (color2 & 0xFF000000) != 255;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int border;
        int endX = x + width - 1;
        int col = this.color;
        if (this.isArgb) {
            DrawUtil.drawLine(col, x, y, endX, y, g);
            for (border = this.borderWidthTop - 1; border > 0; --border) {
                DrawUtil.drawLine(col, x, y + border, endX, y + border, g);
            }
        } else {
            g.setColor(col);
            g.drawLine(x, y, endX, y);
            while (border > 0) {
                g.drawLine(x, y + border, endX, y + border);
                --border;
            }
        }
    }

    public TopBorder() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.color = dataInputStream.readInt();
        this.isArgb = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeBoolean(this.isArgb);
    }
}

