/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.borders;

import de.enough.polish.ui.Border;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class LeftBorder
extends Border {
    private int color;
    private boolean isArgb;

    public LeftBorder(int color2, int borderWidth) {
        super(borderWidth, 0, 0, 0);
        this.color = color2;
        this.isArgb = (color2 & 0xFF000000) != 0 && (color2 & 0xFF000000) != 255;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int border;
        int endY = y + height;
        int col = this.color;
        if (this.isArgb) {
            DrawUtil.drawLine(col, x, y, x, endY, g);
            for (border = this.borderWidthLeft - 1; border > 0; --border) {
                DrawUtil.drawLine(col, x + border, y, x + border, endY, g);
            }
        } else {
            g.setColor(col);
            g.drawLine(x, y, x, endY);
            while (border > 0) {
                g.drawLine(x + border, y, x + border, endY);
                --border;
            }
        }
    }

    public LeftBorder() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.color = dataInputStream.readInt();
        this.isArgb = dataInputStream.readBoolean();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeBoolean(this.isArgb);
    }
}

