/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class VerticalSplitRoundRectBackground
extends Background {
    private int topColor;
    private int bottomColor;
    private int splitPos;
    private boolean isPercent;
    private int arcWidth;
    private int arcHeight;

    public VerticalSplitRoundRectBackground(int topColor, int bottomColor, int splitPos, int arcWidth, int arcHeight) {
        this.topColor = topColor;
        this.bottomColor = bottomColor;
        this.splitPos = splitPos < 0 ? -splitPos : splitPos;
        this.isPercent = splitPos < 0;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int split = this.splitPos;
        if (this.isPercent) {
            split = height * split / 100;
        }
        g.setColor(this.topColor);
        g.fillRoundRect(x, y, width, split + 1, this.arcWidth, this.arcHeight);
        g.fillRect(x, y + split - this.arcHeight, width, this.arcHeight);
        g.setColor(this.bottomColor);
        g.fillRoundRect(x, y + split, width, height - split, this.arcWidth, this.arcHeight);
        g.fillRect(x, y + split, width, this.arcHeight);
    }

    public VerticalSplitRoundRectBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.arcHeight = dataInputStream.readInt();
        this.arcWidth = dataInputStream.readInt();
        this.bottomColor = dataInputStream.readInt();
        this.isPercent = dataInputStream.readBoolean();
        this.splitPos = dataInputStream.readInt();
        this.topColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arcHeight);
        dataOutputStream.writeInt(this.arcWidth);
        dataOutputStream.writeInt(this.bottomColor);
        dataOutputStream.writeBoolean(this.isPercent);
        dataOutputStream.writeInt(this.splitPos);
        dataOutputStream.writeInt(this.topColor);
    }
}

