/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class TigerStripesBackground
extends Background {
    private int color;
    private int stripesColor;
    private transient Random random;
    private int startX;
    private int endX;
    private int endStartX;
    private int endEndX;
    private int number;
    private int maxNumber;
    private int minimalAbstand = 6;
    private int maximalAbstand = 10;

    public TigerStripesBackground() {
        this.random = new Random();
    }

    public TigerStripesBackground(int color2, int stripesColor, int number) {
        this.color = color2;
        this.stripesColor = stripesColor;
        this.random = new Random();
        this.maxNumber = number;
    }

    private void stripe(int x, int y, int width, int height) {
        do {
            this.startX = this.random.nextInt() % (x + width - this.maximalAbstand);
        } while (this.startX < x);
        do {
            this.endX = this.random.nextInt() % (x + width - this.maximalAbstand);
        } while (this.endX < x);
        do {
            this.endStartX = this.random.nextInt() % (this.startX + this.maximalAbstand);
        } while (this.endStartX <= this.startX + this.minimalAbstand);
        do {
            this.endEndX = this.random.nextInt() % (this.endX + this.maximalAbstand);
        } while (this.endEndX <= this.endX + this.minimalAbstand);
    }

    private void stripeCounter(int count) {
        do {
            this.number = Math.abs(this.random.nextInt()) % count;
        } while (this.number < 1);
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        g.setColor(this.color);
        g.fillRect(x, y, width, height);
        g.setColor(this.stripesColor);
        g.setStrokeStyle(1);
        g.drawRect(x, y + 8, width, 2);
        g.drawRect(x, y, width, height);
        this.stripeCounter(this.maxNumber);
        for (int i = 0; i < this.number; ++i) {
            this.stripe(x, y, width, height);
            while (this.startX < this.endStartX || this.endX < this.endEndX) {
                g.drawLine(this.startX, y + 1, this.endX, y + height - 1);
                if (this.startX < this.endStartX) {
                    ++this.startX;
                }
                if (this.endX >= this.endEndX) continue;
                ++this.endX;
            }
        }
        g.setStrokeStyle(0);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.color = dataInputStream.readInt();
        this.endEndX = dataInputStream.readInt();
        this.endStartX = dataInputStream.readInt();
        this.endX = dataInputStream.readInt();
        this.maxNumber = dataInputStream.readInt();
        this.maximalAbstand = dataInputStream.readInt();
        this.minimalAbstand = dataInputStream.readInt();
        this.number = dataInputStream.readInt();
        this.startX = dataInputStream.readInt();
        this.stripesColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeInt(this.endEndX);
        dataOutputStream.writeInt(this.endStartX);
        dataOutputStream.writeInt(this.endX);
        dataOutputStream.writeInt(this.maxNumber);
        dataOutputStream.writeInt(this.maximalAbstand);
        dataOutputStream.writeInt(this.minimalAbstand);
        dataOutputStream.writeInt(this.number);
        dataOutputStream.writeInt(this.startX);
        dataOutputStream.writeInt(this.stripesColor);
    }
}

