/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class ThinSimpleBackground
extends Background {
    private int color;
    private int maxWidth;
    private boolean isPercent;
    private int pixelWidth;
    private int lastWidth;
    private int xOffset;
    private int borderColor;

    public ThinSimpleBackground(int color2, int maxWidth, boolean isPercent, int borderWidth, int borderColor) {
        this.color = color2;
        this.maxWidth = maxWidth;
        this.isPercent = isPercent;
        this.borderWidth = borderWidth;
        this.borderColor = borderColor;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (width != this.lastWidth) {
            int pw = this.isPercent ? width * this.maxWidth / 100 : Math.max(width, this.maxWidth);
            this.pixelWidth = pw;
            this.xOffset = (width - pw) / 2;
            this.lastWidth = width;
        }
        g.setColor(this.color);
        width = this.pixelWidth;
        g.fillRect((x += this.xOffset) + this.xOffset, y, this.pixelWidth, height);
        if (this.borderWidth > 0) {
            g.setColor(this.borderColor);
            for (int border = this.borderWidth; border > 0; --border) {
                g.drawRect(x + border, y + border, width - 2 * border, height - 2 * border);
            }
        }
    }

    public ThinSimpleBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.borderColor = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        this.isPercent = dataInputStream.readBoolean();
        this.lastWidth = dataInputStream.readInt();
        this.maxWidth = dataInputStream.readInt();
        this.pixelWidth = dataInputStream.readInt();
        this.xOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.borderColor);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeBoolean(this.isPercent);
        dataOutputStream.writeInt(this.lastWidth);
        dataOutputStream.writeInt(this.maxWidth);
        dataOutputStream.writeInt(this.pixelWidth);
        dataOutputStream.writeInt(this.xOffset);
    }
}

