/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.HashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class TextBackground
extends Background {
    private static HashMap localizations;
    private int color;
    private int anchor;
    private int xOffset;
    private int yOffset;
    private transient StringItem item;
    private String textStyleName;

    public TextBackground(String text, String textStyleName, int color2, int anchor, int xOffset, int yOffset) {
        this.textStyleName = textStyleName;
        this.color = color2;
        this.anchor = anchor;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.item = new StringItem(null, text);
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (this.color != -1) {
            g.setColor(this.color);
            g.fillRect(x, y, width, height);
        }
        x += this.xOffset;
        y += this.yOffset;
        if ((this.anchor & 2) == 2) {
            y += height - this.item.getItemHeight(width, width, height) / 2;
        } else if ((this.anchor & 0x20) == 32) {
            y += height - this.item.getItemHeight(width, width, height);
        }
        this.item.paint(x, y, x, x + width, g);
    }

    public void releaseResources() {
        this.item.releaseResources();
    }

    public void hideNotify() {
        UiAccess.hideNotify(this.item);
    }

    public void showNotify() {
        Style style;
        UiAccess.showNotify(this.item);
        if (this.textStyleName != null && (style = StyleSheet.getStyle(this.textStyleName)) != null) {
            this.item.setStyle(style);
        }
        if (localizations != null) {
            String translation;
            String originalText = (String)this.item.getAttribute("original");
            if (originalText == null) {
                originalText = this.item.getText();
                this.item.setAttribute("original", originalText);
            }
            if (originalText != null && (translation = (String)localizations.get(originalText)) != null && !translation.equals(originalText)) {
                this.item.setText(translation);
            }
        }
    }

    public void animate(Screen screen, Item parent, long currentTime, ClippingRegion repaintRegion) {
        this.item.animate(currentTime, repaintRegion);
    }

    public static void setLocalization(String original, String translation) {
        if (localizations == null) {
            localizations = new HashMap();
        }
        localizations.put(original, translation);
    }

    public TextBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.anchor = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        this.textStyleName = (String)Serializer.deserialize(dataInputStream);
        this.xOffset = dataInputStream.readInt();
        this.yOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.anchor);
        dataOutputStream.writeInt(this.color);
        Serializer.serialize(this.textStyleName, dataOutputStream);
        dataOutputStream.writeInt(this.xOffset);
        dataOutputStream.writeInt(this.yOffset);
    }
}

