/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class ImageResourceBackground
extends Background {
    protected String imageUrl;
    protected boolean isLoaded;
    protected Image image;
    protected int imageWidth;
    protected int imageHeight;
    int storedClipX;
    int storedClipY;
    int storedClipWidth;
    int storedClipHeight;

    public ImageResourceBackground(String url) {
        this.imageUrl = url;
    }

    protected void load() {
        if (!this.isLoaded) {
            try {
                this.image = StyleSheet.getImage(this.imageUrl, this, false);
                this.imageWidth = this.image.getWidth();
                this.imageHeight = this.image.getHeight();
            }
            catch (IOException e) {
                Debug.debug("error", "de.enough.polish.ui.backgrounds.ImageResourceBackground", 51, (Object)("unable to load image [" + this.imageUrl + "]"), e);
            }
            this.isLoaded = true;
        }
    }

    protected void storeClipping(Graphics g) {
        this.storedClipX = g.getClipX();
        this.storedClipY = g.getClipY();
        this.storedClipWidth = g.getClipWidth();
        this.storedClipHeight = g.getClipHeight();
    }

    protected void restoreClipping(Graphics g) {
        g.setClip(this.storedClipX, this.storedClipY, this.storedClipWidth, this.storedClipHeight);
    }

    public void setImage(Image image) {
        this.image = image;
        this.isLoaded = image != null;
    }

    public Image getImage() {
        return this.image;
    }

    public void releaseResources() {
        if (this.imageUrl != null) {
            this.isLoaded = false;
            this.image = null;
        }
    }

    protected void drawRegion(Image img, int xSrc, int ySrc, int width, int height, int xDest, int yDest, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        g.clipRect(xDest, yDest, width, height);
        g.drawImage(img, xDest - xSrc, yDest - ySrc, 20);
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public ImageResourceBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.image = (Image)Serializer.deserialize(dataInputStream);
        this.imageHeight = dataInputStream.readInt();
        this.imageUrl = (String)Serializer.deserialize(dataInputStream);
        this.imageWidth = dataInputStream.readInt();
        this.isLoaded = dataInputStream.readBoolean();
        this.storedClipHeight = dataInputStream.readInt();
        this.storedClipWidth = dataInputStream.readInt();
        this.storedClipX = dataInputStream.readInt();
        this.storedClipY = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.image, dataOutputStream);
        dataOutputStream.writeInt(this.imageHeight);
        Serializer.serialize(this.imageUrl, dataOutputStream);
        dataOutputStream.writeInt(this.imageWidth);
        dataOutputStream.writeBoolean(this.isLoaded);
        dataOutputStream.writeInt(this.storedClipHeight);
        dataOutputStream.writeInt(this.storedClipWidth);
        dataOutputStream.writeInt(this.storedClipX);
        dataOutputStream.writeInt(this.storedClipY);
    }
}

