/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.backgrounds.ImageResourceBackground;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class HorizontalPatchBackground
extends ImageResourceBackground {
    private int cornerWidth;
    private int marginLeft;
    private int marginTop;
    private int marginRight;
    private int marginBottom;

    public HorizontalPatchBackground(String imageUrl, int cornerWidth, int marginLeft, int marginTop, int marginRight, int marginBottom) {
        super(imageUrl);
        this.cornerWidth = cornerWidth;
        this.marginLeft = marginLeft;
        this.marginTop = marginTop;
        this.marginRight = marginRight;
        this.marginBottom = marginBottom;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (!this.isLoaded) {
            this.load();
        }
        width = width + this.marginLeft + this.marginRight;
        height = height + this.marginTop + this.marginBottom;
        this.paintTiles(x -= this.marginLeft, y -= this.marginTop, width, height, g);
        this.paintFill(x, y, width, height, g);
    }

    private void paintTiles(int x, int y, int width, int height, Graphics g) {
        int srcX = 0;
        int srcY = 0;
        int dstX = x;
        int dstY = y;
        g.drawRegion(this.image, srcX, srcY, this.cornerWidth, this.image.getHeight(), 0, dstX, dstY, 20);
        srcX = this.image.getWidth() - this.cornerWidth;
        srcY = 0;
        dstX = x + (width - this.cornerWidth);
        dstY = y;
        g.drawRegion(this.image, srcX, srcY, this.cornerWidth, this.image.getHeight(), 0, dstX, dstY, 20);
    }

    private void paintFill(int x, int y, int width, int height, Graphics g) {
        int srcX = this.cornerWidth;
        int srcY = 0;
        int srcWidth = this.image.getWidth() - this.cornerWidth * 2;
        int srcHeight = this.image.getHeight();
        int dstX = x + this.cornerWidth;
        int dstY = y;
        int fillWidth = width - this.cornerWidth * 2;
        int fillHeight = srcHeight;
        this.storeClipping(g);
        g.clipRect(dstX, dstY, fillWidth, fillHeight);
        for (int xOffset = 0; xOffset < fillWidth; xOffset += srcWidth) {
            g.drawRegion(this.image, srcX, srcY, srcWidth, srcHeight, 0, dstX + xOffset, dstY, 20);
        }
        this.restoreClipping(g);
    }

    public HorizontalPatchBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.cornerWidth = dataInputStream.readInt();
        this.marginBottom = dataInputStream.readInt();
        this.marginLeft = dataInputStream.readInt();
        this.marginRight = dataInputStream.readInt();
        this.marginTop = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.cornerWidth);
        dataOutputStream.writeInt(this.marginBottom);
        dataOutputStream.writeInt(this.marginLeft);
        dataOutputStream.writeInt(this.marginRight);
        dataOutputStream.writeInt(this.marginTop);
    }
}

