/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Dimension;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class GradientRadialBackground
extends Background {
    private int innerColor;
    private int outerColor;
    private Dimension start;
    private Dimension end;
    private Dimension centerX;
    private Dimension centerY;

    public GradientRadialBackground(int innerColor, int outerColor, int start, int end) {
        this(innerColor, outerColor, start, end, 0, 0);
    }

    public GradientRadialBackground(int innerColor, int outerColor, int start, int end, int centerX, int centerY) {
        this(innerColor, outerColor, new Dimension(start, true), new Dimension(end, true), new Dimension(centerX, true), new Dimension(centerY, true));
    }

    public GradientRadialBackground(int innerColor, int outerColor, Dimension start, Dimension end, Dimension centerX, Dimension centerY) {
        this.innerColor = innerColor;
        this.outerColor = outerColor;
        if (start != null && end != null && start.getValue(100) != end.getValue(100)) {
            this.start = start;
            this.end = end;
        }
        this.centerX = centerX;
        this.centerY = centerY;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int endOffset;
        int startOffset;
        int steps = (Math.max(width, height) >> 1) - 1;
        if (this.start != null) {
            startOffset = this.start.getValue(steps);
            endOffset = this.end.getValue(steps);
        } else {
            startOffset = 0;
            endOffset = steps;
        }
        int targetX = (width >> 1) + (width >> 1) * this.centerX.getValue(width) / 100 - startOffset;
        int targetY = (height >> 1) + (height >> 1) * this.centerY.getValue(height) - startOffset;
        int originalX = x;
        int originalY = y;
        g.setColor(this.innerColor);
        for (int i = 0; i < steps; ++i) {
            if (i >= startOffset && i < endOffset) {
                int color2 = DrawUtil.getGradientColor(this.outerColor, this.innerColor, i - startOffset, steps);
                g.setColor(color2);
            }
            g.fillArc(x, y, width, height, 0, 360);
            x = originalX + targetX * i / steps;
            y = originalY + targetY * i / steps;
            if (width > startOffset) {
                width -= 2;
            }
            if (height <= startOffset) continue;
            height -= 2;
        }
    }

    public GradientRadialBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.centerX = (Dimension)Serializer.deserialize(dataInputStream);
        this.centerY = (Dimension)Serializer.deserialize(dataInputStream);
        this.end = (Dimension)Serializer.deserialize(dataInputStream);
        this.innerColor = dataInputStream.readInt();
        this.outerColor = dataInputStream.readInt();
        this.start = (Dimension)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.centerX, dataOutputStream);
        Serializer.serialize(this.centerY, dataOutputStream);
        Serializer.serialize(this.end, dataOutputStream);
        dataOutputStream.writeInt(this.innerColor);
        dataOutputStream.writeInt(this.outerColor);
        Serializer.serialize(this.start, dataOutputStream);
    }
}

