/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.CommandItem;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.MenuBar;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import javax.microedition.lcdui.Graphics;

public class TitleMenuBar
extends MenuBar {
    Item titleItem = new StringItem(null, null, StyleSheet.titleStyle);

    public TitleMenuBar(Screen screen) {
        this(screen, null);
    }

    public TitleMenuBar(Screen screen, Style style) {
        super(screen, style);
    }

    public void setTitle(String title) {
        if (this.titleItem instanceof StringItem) {
            ((StringItem)this.titleItem).setText(title);
        }
    }

    public void setTitle(String title, Style style) {
        if (this.titleItem instanceof StringItem) {
            ((StringItem)this.titleItem).setText(title, style);
        }
    }

    public void setTitle(Item item) {
        this.setTitle(item, null);
    }

    public void setTitle(Item item, Style style) {
        this.titleItem = item;
        item.parent = this;
        if (style != null) {
            item.setStyle(style);
        }
        this.requestInit();
    }

    public void setStyle(Style style) {
        Style screenStyle;
        super.setStyle(style);
        Style titleStyle = (Style)style.getObjectProperty(2);
        if (titleStyle != null) {
            this.titleItem.setStyle(titleStyle);
        }
        if (this.screen != null && (titleStyle = (Style)(screenStyle = this.screen.style).getObjectProperty(2)) != null) {
            this.titleItem.setStyle(titleStyle);
        }
    }

    protected void init(int firstLineWidth, int availWidth, int availHeight) {
        super.init(firstLineWidth, availWidth, availHeight);
        Container cmds = this.commandsContainer;
        cmds.relativeY = cmds.isLayoutVerticalCenter() ? this.contentHeight + (availHeight - (this.contentHeight + cmds.itemHeight)) / 2 : (cmds.isLayoutBottom() ? this.contentHeight + (availHeight - (this.contentHeight + cmds.itemHeight)) : this.contentHeight);
        cmds.relativeX = cmds.isLayoutCenter() ? (availWidth - cmds.itemWidth) / 2 : (cmds.isLayoutRight ? availWidth - cmds.itemWidth : 0);
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        super.initContent(firstLineWidth, availWidth, availHeight);
        Item title = this.titleItem;
        int maxHeight = Math.max(this.contentHeight, title.getItemHeight(availWidth, availWidth, availHeight));
        CommandItem singleLeft = this.singleLeftCommandItem;
        CommandItem singleRight = this.singleRightCommandItem;
        if (maxHeight > title.itemHeight) {
            if (title.isLayoutVerticalCenter()) {
                title.relativeY = (maxHeight - title.itemHeight) / 2;
            } else if (title.isLayoutBottom()) {
                title.relativeY = maxHeight - title.itemHeight;
            }
            singleLeft.relativeY = 0;
            singleRight.relativeY = 0;
        } else {
            title.relativeY = 0;
            singleLeft.relativeY = singleLeft.isLayoutVerticalCenter() ? maxHeight - singleLeft.itemHeight >> 1 : (singleLeft.isLayoutBottom() ? maxHeight - singleLeft.itemHeight : 0);
            singleRight.relativeY = singleRight.isLayoutVerticalCenter() ? maxHeight - singleRight.itemHeight >> 1 : (singleRight.isLayoutBottom() ? maxHeight - singleRight.itemHeight : 0);
        }
        this.contentHeight = maxHeight;
        title.relativeX = title.isLayoutCenter() ? (availWidth - title.itemWidth) / 2 : (title.isLayoutRight() ? availWidth - title.itemWidth : 0);
    }

    protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        super.paintContent(x, y, leftBorder, rightBorder, g);
        Item title = this.titleItem;
        int itemX = x + title.relativeX;
        int itemY = y + title.relativeY;
        title.paint(itemX, itemY, itemX, itemX + title.itemWidth, g);
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        this.titleItem.animate(currentTime, repaintRegion);
    }

    protected boolean isInMenubar(int relativeY) {
        return relativeY < this.itemHeight;
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        Item title = this.titleItem;
        boolean handled = false;
        if (!this.isOpened && title.appearanceMode != 0) {
            handled = title.handleKeyPressed(keyCode, gameAction);
        }
        return handled || super.handleKeyPressed(keyCode, gameAction);
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        Item title = this.titleItem;
        boolean handled = false;
        if (!this.isOpened && title.appearanceMode != 0) {
            handled = title.handleKeyReleased(keyCode, gameAction);
        }
        return handled || super.handleKeyReleased(keyCode, gameAction);
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        Item title = this.titleItem;
        boolean handled = false;
        if (!this.isOpened && title.appearanceMode != 0) {
            handled = title.handleKeyRepeated(keyCode, gameAction);
        }
        return handled || super.handleKeyRepeated(keyCode, gameAction);
    }

    protected boolean handlePointerDragged(int relX, int relY, ClippingRegion repaintRegion) {
        Item title = this.titleItem;
        boolean handled = false;
        if (!this.isOpened && title.appearanceMode != 0) {
            handled = title.handlePointerDragged(relX - title.relativeX, relY - title.relativeY, repaintRegion);
        }
        return handled || super.handlePointerDragged(relX, relY, repaintRegion);
    }

    protected boolean handlePointerPressed(int relX, int relY) {
        Item title = this.titleItem;
        boolean handled = false;
        if (!this.isOpened && title.appearanceMode != 0) {
            handled = title.handlePointerPressed(relX - title.relativeX, relY - title.relativeY);
        }
        return handled || super.handlePointerPressed(relX, relY);
    }

    protected boolean handlePointerReleased(int relX, int relY) {
        Item title = this.titleItem;
        boolean handled = false;
        if (!this.isOpened && title.appearanceMode != 0) {
            handled = title.handlePointerReleased(relX - title.relativeX, relY - title.relativeY);
        }
        return handled || super.handlePointerReleased(relX, relY);
    }
}

