/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.ClockItem;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;

public class TimeTitleItem
extends StringItem {
    private ClockItem clockItem = new ClockItem(null);
    private int textYAdjust;

    public TimeTitleItem(String label, String text) {
        this(label, text, 0, null);
    }

    public TimeTitleItem(String label, String text, Style style) {
        this(label, text, 0, style);
    }

    public TimeTitleItem(String label, String text, int appearanceMode) {
        this(label, text, appearanceMode, null);
    }

    public TimeTitleItem(String label, String text, int appearanceMode, Style style) {
        super(label, text, appearanceMode, style);
        this.clockItem.parent = this;
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        this.clockItem.animate(currentTime, repaintRegion);
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        super.initContent(firstLineWidth, availWidth, availHeight);
        ClockItem clock = this.clockItem;
        int w = clock.getItemWidth(firstLineWidth, availWidth, availHeight);
        int h = clock.itemHeight;
        if (w > this.contentWidth) {
            this.contentWidth = w;
            clock.relativeX = 0;
        } else {
            clock.relativeX = clock.isLayoutRight() ? this.contentWidth - w : (clock.isLayoutCenter() ? (this.contentWidth - w) / 2 : 0);
        }
        if (h > this.contentHeight) {
            if (this.isLayoutVerticalCenter()) {
                this.textYAdjust = (h - this.contentHeight) / 2;
            } else if (this.isLayoutBottom()) {
                this.textYAdjust = h - this.contentHeight;
            }
            this.contentHeight = h;
            clock.relativeY = 0;
        } else {
            this.textYAdjust = 0;
            clock.relativeY = clock.isLayoutVerticalCenter() ? (this.contentHeight - h) / 2 : (clock.isLayoutBottom() ? this.contentHeight - h : 0);
        }
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        super.paintContent(x, y + this.textYAdjust, leftBorder, rightBorder, g);
        ClockItem clock = this.clockItem;
        clock.paint(x + clock.relativeX, y + clock.relativeY, leftBorder, rightBorder, g);
    }
}

