/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Background;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.backgrounds.TriangleBackground;
import java.util.Calendar;
import javax.microedition.lcdui.Graphics;

public class TimeEntryItem
extends StringItem {
    private int hour;
    private int minute;
    private Background bgArrowUp;
    private Background bgArrowDown;
    private int arrowLength;
    private int xAdjust;

    public TimeEntryItem(String label, int hour, int minute) {
        this(label, hour, minute, null);
    }

    public TimeEntryItem(String label, int hour, int minute, Style style) {
        super(label, TimeEntryItem.constructText(hour, minute), 3, style);
        this.hour = hour;
        this.minute = minute;
    }

    private static String constructText(int hour, int minute) {
        StringBuffer buffer = new StringBuffer(5);
        if (hour < 10) {
            buffer.append(' ');
        }
        buffer.append(hour);
        buffer.append(':');
        if (minute < 10) {
            buffer.append('0');
        }
        buffer.append(minute);
        return buffer.toString();
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        int minWidth;
        super.initContent(firstLineWidth, availWidth, availHeight);
        int w = this.stringWidth("99");
        this.contentHeight += w + w;
        this.arrowLength = w;
        if (this.bgArrowUp == null) {
            this.bgArrowUp = new TriangleBackground(this.textColor, 0);
        }
        if (this.bgArrowDown == null) {
            this.bgArrowDown = new TriangleBackground(this.textColor, 1);
        }
        if (this.contentWidth < (minWidth = w + w + 2)) {
            this.xAdjust = minWidth - this.contentWidth;
            this.contentWidth = minWidth;
        } else {
            this.xAdjust = 0;
        }
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int w = this.arrowLength;
        this.bgArrowUp.paint(x, y, w, w, g);
        this.bgArrowUp.paint(x + this.contentWidth - w, y, w, w, g);
        this.bgArrowDown.paint(x, y + this.contentHeight - w, w, w, g);
        this.bgArrowDown.paint(x + this.contentWidth - w, y + this.contentHeight - w, w, w, g);
        super.paintContent(x + this.xAdjust, y += w, leftBorder, rightBorder, g);
    }

    protected boolean handlePointerReleased(int relX, int relY) {
        boolean processed = false;
        if (this.isInItemArea(relX, relY)) {
            int w = this.arrowLength;
            if (relY <= w) {
                if (relX <= w) {
                    this.increaseHour();
                    processed = true;
                } else if (relX >= this.contentWidth - w) {
                    this.increaseMinute();
                    processed = true;
                }
            } else if (relY >= this.contentHeight - w) {
                if (relX <= w) {
                    this.decreaseHour();
                    processed = true;
                } else if (relX >= this.contentWidth - w) {
                    this.decreaseMinute();
                    processed = true;
                }
            }
        }
        return processed || super.handlePointerReleased(relX, relY);
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        boolean handled = super.handleKeyReleased(keyCode, gameAction);
        if (!handled) {
            if (gameAction == 1) {
                this.increaseMinute();
                handled = true;
            } else if (gameAction == 6) {
                this.decreaseMinute();
                handled = true;
            }
        }
        return handled;
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        boolean handled = super.handleKeyRepeated(keyCode, gameAction);
        if (!handled) {
            if (gameAction == 1) {
                this.increaseMinute();
                handled = true;
            } else if (gameAction == 6) {
                this.decreaseMinute();
                handled = true;
            }
        }
        return handled;
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        boolean handled = super.handleKeyPressed(keyCode, gameAction);
        if (!handled) {
            if (gameAction == 1) {
                handled = true;
            } else if (gameAction == 6) {
                handled = true;
            }
        }
        return handled;
    }

    private void increaseMinute() {
        int m = this.minute + 1;
        if (m >= 60) {
            m = 0;
            this.increaseHour();
        }
        this.minute = m;
        this.setText(TimeEntryItem.constructText(this.hour, m));
    }

    private void decreaseMinute() {
        int m = this.minute - 1;
        if (m < 0) {
            m = 59;
            this.decreaseHour();
        }
        this.minute = m;
        this.setText(TimeEntryItem.constructText(this.hour, m));
    }

    private void increaseHour() {
        int h = this.hour + 1;
        if (h >= 24) {
            h = 0;
        }
        this.hour = h;
        this.setText(TimeEntryItem.constructText(h, this.minute));
    }

    private void decreaseHour() {
        int h = this.hour - 1;
        if (h < 0) {
            h = 23;
        }
        this.hour = h;
        this.setText(TimeEntryItem.constructText(h, this.minute));
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void updateCalendar(Calendar cal) {
        cal.set(11, this.hour);
        cal.set(12, this.minute);
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
        if (this.bgArrowUp != null) {
            this.bgArrowUp.setStyle(style);
        }
        if (this.bgArrowDown != null) {
            this.bgArrowDown.setStyle(style);
        }
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }
}

