/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Canvas;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.CycleListener;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.MenuBar;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.ScreenInitializerListener;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TabListener;
import de.enough.polish.ui.TabbedFormListener;
import de.enough.polish.util.ArrayList;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TabbedPane
extends Screen
implements ScreenInitializerListener,
CycleListener {
    private static final int TAB_POSITION_TOP = 0;
    private static final int TAB_POSITION_BOTTOM = 1;
    private final ArrayList tabDisplayables;
    private final Container tabIconsContainer;
    private boolean isUseTabTitle;
    private TabListener tabListener;
    private Displayable currentDisplayable;
    private int currentDisplayableIndex = -1;
    private Screen currentScreen;
    private boolean isTabPositionTop;
    private TabbedFormListener tabbedFormListener;
    private boolean isSizeChangedCalled;
    private boolean isTabIconsContainerSelectable;
    private boolean isTabIconsContainerFocused;
    private Style tabIconsContainerStyle;

    public TabbedPane(String title) {
        this(title, null, null, true, null);
    }

    public TabbedPane(String title, Style style) {
        this(title, null, null, true, style);
    }

    public TabbedPane(String title, Displayable[] tabs, Image[] tabIcons, boolean useTabTitle) {
        this(title, tabs, tabIcons, useTabTitle, null);
    }

    public TabbedPane(String title, Displayable[] tabs, Image[] tabIcons, boolean useTabTitle, Style style) {
        super(title, false, style);
        this.isUseTabTitle = useTabTitle;
        this.tabDisplayables = new ArrayList();
        this.tabIconsContainer = new Container(true);
        this.tabIconsContainer.screen = this;
        if (tabs != null) {
            for (int i = 0; i < tabs.length; ++i) {
                Displayable screen = tabs[i];
                Image icon = tabIcons[i];
                this.addTab(screen, icon);
            }
        }
    }

    public void addTab(Displayable tab, Image icon) {
        this.addTab(tab, icon, null, null);
    }

    public void addTab(Displayable tab, Image icon, String text) {
        this.addTab(tab, icon, text, null);
    }

    public void addTab(Displayable tab, Image icon, String text, Style tabIconStyle) {
        if (tab == null || icon == null && text == null) {
            throw new NullPointerException();
        }
        IconItem iconItem = new IconItem(text, icon);
        this.addTab(tab, iconItem, tabIconStyle);
    }

    public void addTab(Displayable tab, IconItem iconItem) {
        this.addTab(tab, iconItem, null);
    }

    public void addTab(Displayable tab, IconItem iconItem, Style tabIconStyle) {
        if (tab == null || iconItem == null) {
            throw new NullPointerException();
        }
        this.tabIconsContainer.add(iconItem, tabIconStyle);
        this.tabDisplayables.add(tab);
        if (this.tabDisplayables.size() == 1 && this.isShown()) {
            this.setFocus(0);
        }
        if (this.isTabIconsContainerSelectable && tab instanceof Screen) {
            ((Screen)tab).getRootContainer().setCycleListener(this);
        }
    }

    public void addTabListener(TabListener listener) {
        this.tabListener = listener;
    }

    public void setTabListener(TabListener tabListener) {
        this.tabListener = tabListener;
    }

    public void setTabbedFormListener(TabbedFormListener listener) {
        this.tabbedFormListener = listener;
    }

    public void insertTab(int index, Displayable tab, Image icon) {
        this.insertTab(index, tab, icon, null);
    }

    public void insertTab(int index, Displayable tab, Image icon, String text) {
        this.insertTab(index, tab, icon, text, null);
    }

    public void insertTab(int index, Displayable tab, Image icon, String text, Style tabIconStyle) {
        if (tab == null || icon == null && text == null) {
            throw new NullPointerException();
        }
        IconItem iconItem = new IconItem(text, icon);
        this.insertTab(index, tab, iconItem, tabIconStyle);
    }

    public void insertTab(int index, Displayable tab, IconItem tabIconItem) {
        this.insertTab(index, tab, tabIconItem, null);
    }

    public void insertTab(int index, Displayable tab, IconItem tabIconItem, Style tabIconStyle) {
        if (tab == null || tabIconItem == null) {
            throw new NullPointerException();
        }
        this.tabDisplayables.add(index, tab);
        if (tabIconStyle != null) {
            tabIconItem.setStyle(tabIconStyle);
        }
        this.tabIconsContainer.add(index, tabIconItem);
    }

    public void setTab(int index, Displayable tab) {
        this.setTab(index, tab, this.getTabIconItem(index), null);
    }

    public void setTab(int index, Displayable tab, Image icon) {
        this.setTab(index, tab, icon, null);
    }

    public void setTab(int index, Displayable tab, Image icon, String text) {
        this.setTab(index, tab, icon, text, null);
    }

    public void setTab(int index, Displayable tab, Image icon, String text, Style tabIconStyle) {
        if (tab == null || icon == null && text == null) {
            throw new NullPointerException();
        }
        IconItem iconItem = new IconItem(text, icon);
        this.setTab(index, tab, iconItem, tabIconStyle);
    }

    public void setTab(int index, Displayable tab, IconItem tabIconItem) {
        this.setTab(index, tab, tabIconItem, null);
    }

    public void setTab(int index, Displayable tab, IconItem tabIconItem, Style tabIconStyle) {
        Displayable previous;
        if (tab == null || tabIconItem == null) {
            throw new NullPointerException();
        }
        if (this.isShown() && (previous = (Displayable)this.tabDisplayables.get(index)) instanceof Canvas) {
            ((Canvas)previous)._hideNotify();
        }
        this.tabDisplayables.set(index, tab);
        this.tabIconsContainer.set(index, tabIconItem, tabIconStyle);
        if (index == this.currentDisplayableIndex) {
            this.currentDisplayable = null;
            this.currentScreen = null;
            this.setFocus(index);
        }
    }

    public void setCurrentTab(Displayable tab) {
        if (tab == this.currentDisplayable) {
            this.repaint();
            return;
        }
        int index = this.currentDisplayableIndex;
        if (index == -1) {
            if (this.size() == 0) {
                throw new IndexOutOfBoundsException();
            }
            index = 0;
        }
        this.setTab(index, tab, this.getTabIconItem(index), null);
    }

    public void setCurrentTab(Displayable tab, Image icon) {
        this.setCurrentTab(tab, icon, null);
    }

    public void setCurrentTab(Displayable tab, Image icon, String text) {
        this.setCurrentTab(tab, icon, text, null);
    }

    public void setCurrentTab(Displayable tab, Image icon, String text, Style tabIconStyle) {
        if (tab == null || icon == null && text == null) {
            throw new NullPointerException();
        }
        IconItem iconItem = new IconItem(text, icon);
        this.setCurrentTab(tab, iconItem, tabIconStyle);
    }

    public void setCurrentTab(Displayable tab, IconItem tabIconItem) {
        this.setCurrentTab(tab, tabIconItem, null);
    }

    public void setCurrentTab(Displayable tab, IconItem tabIconItem, Style tabIconStyle) {
        int index = this.currentDisplayableIndex;
        if (index == -1) {
            if (this.size() == 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            index = 0;
        }
        this.setTab(index, tab, tabIconItem, tabIconStyle);
    }

    public void setCurrentTab(int tabIndex) {
        this.setFocus(tabIndex);
    }

    public void setFocus(int tabIndex) {
        Displayable disp;
        boolean allowTabChange;
        int previousIndex = this.currentDisplayableIndex;
        Displayable previousDisplayable = this.currentDisplayable;
        if (tabIndex == previousIndex && previousDisplayable != null) {
            return;
        }
        if (this.tabbedFormListener != null && tabIndex != previousIndex && !(allowTabChange = this.tabbedFormListener.notifyTabChangeRequested(previousIndex, tabIndex))) {
            return;
        }
        boolean isShown = this.isShown();
        if (isShown && previousDisplayable instanceof Canvas) {
            ((Canvas)previousDisplayable)._hideNotify();
        }
        this.currentDisplayable = disp = (Displayable)this.tabDisplayables.get(tabIndex);
        this.currentDisplayableIndex = tabIndex;
        this.tabIconsContainer.focusChild(tabIndex);
        if (disp instanceof Screen) {
            Screen screen = (Screen)disp;
            if (this.tabListener != null && tabIndex != previousIndex) {
                this.tabListener.tabChangeEvent(screen);
            }
            this.currentScreen = screen;
            screen.setScreenInitializerListener(this);
            int screenFullWidth = this.getScreenFullWidth();
            int screenFullHeight = this.getScreenFullHeight();
            if (screenFullWidth != 0 && screenFullHeight != 0) {
                this.init(screenFullWidth, screenFullHeight);
            }
            if (isShown) {
                screen._showNotify();
            }
        } else {
            this.currentScreen = null;
            if (isShown && disp instanceof Canvas) {
                ((Canvas)disp)._showNotify();
            }
        }
        StyleSheet.currentScreen = this;
        if (this.tabbedFormListener != null && tabIndex != previousIndex) {
            this.tabbedFormListener.notifyTabChangeCompleted(previousIndex, tabIndex);
        }
        if (isShown) {
            this.repaint();
        }
    }

    public void setTabIcon(int index, Image icon) {
        IconItem tabItem = (IconItem)this.tabIconsContainer.get(index);
        tabItem.setImage(icon);
    }

    public void removeTab(int index) {
        this.tabDisplayables.remove(index);
        this.tabIconsContainer.remove(index);
        if (index == this.currentDisplayableIndex) {
            this.currentDisplayableIndex = -1;
            if (this.tabDisplayables.size() > index) {
                this.setFocus(index);
            } else if (this.tabDisplayables.size() > 0) {
                this.setFocus(this.tabDisplayables.size() - 1);
            }
        }
    }

    public int getCount() {
        return this.tabDisplayables.size();
    }

    public int size() {
        return this.tabDisplayables.size();
    }

    public int getSelectedIndex() {
        return this.currentDisplayableIndex;
    }

    public Screen getScreen(int index) {
        try {
            Displayable screen = (Displayable)this.tabDisplayables.get(index);
            if (screen instanceof Screen) {
                return (Screen)screen;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    public Displayable getDisplayable(int index) {
        Displayable screen = null;
        try {
            screen = (Displayable)this.tabDisplayables.get(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return screen;
    }

    public Image getTabIcon(int index) {
        try {
            Item item = this.tabIconsContainer.get(index);
            if (item instanceof IconItem) {
                return ((IconItem)item).getImage();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    public String getTabText(int index) {
        try {
            Item item = this.tabIconsContainer.get(index);
            if (item instanceof StringItem) {
                return ((StringItem)item).getText();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    public IconItem getTabIconItem(int index) {
        try {
            Item item = this.tabIconsContainer.get(index);
            if (item instanceof IconItem) {
                return (IconItem)item;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    protected String createCssSelector() {
        return "tabbedpane";
    }

    protected void paintBackgroundAndBorder(Graphics g) {
        Screen scr = this.currentScreen;
        if (scr != null) {
            if (!scr.isInitialized) {
                int w = this.getScreenFullWidth();
                int h = Display.getScreenHeight();
                int tabHeight = this.tabIconsContainer.itemHeight;
                scr.init(w, h -= tabHeight);
            }
            scr.paintBackgroundAndBorder(g);
        } else {
            super.paintBackgroundAndBorder(g);
        }
    }

    protected void paintScreen(Graphics g) {
        Container cont = this.tabIconsContainer;
        cont.paint(cont.relativeX, cont.relativeY, cont.relativeX, cont.relativeX + cont.itemWidth, g);
        Screen screen = this.currentScreen;
        if (screen != null) {
            screen.paintScreen(g);
        } else {
            super.paintScreen(g);
        }
    }

    protected void paintMenuBar(Graphics g) {
        if (this.currentScreen != null) {
            this.currentScreen.paintMenuBar(g);
        } else {
            super.paintMenuBar(g);
        }
    }

    protected void paintScrollBar(Graphics g) {
        if (this.currentScreen != null) {
            this.currentScreen.paintScrollBar(g);
        } else {
            super.paintMenuBar(g);
        }
    }

    protected void paintTitleAndSubtitle(Graphics g) {
        if (this.isUseTabTitle && this.currentScreen != null) {
            this.currentScreen.paintTitleAndSubtitle(g);
        } else {
            super.paintTitleAndSubtitle(g);
        }
    }

    protected void init(int width, int height) {
        if (width == 0 || height == 0) {
            return;
        }
        super.init(width, height);
        int tabHeight = this.tabIconsContainer.itemHeight;
        height -= tabHeight;
        Screen scr = this.currentScreen;
        if (scr != null) {
            scr.init(width, height);
            boolean alignWithMenuBar = false;
            MenuBar currentMenuBar = scr.getMenuBar();
            currentMenuBar.onScreenSizeChanged(width, height + tabHeight);
            if (currentMenuBar.relativeY > height / 2) {
                alignWithMenuBar = true;
            }
            if (!this.isTabPositionTop) {
                this.tabIconsContainer.relativeY = alignWithMenuBar ? currentMenuBar.relativeY - tabHeight : height;
            }
        }
    }

    protected void calculateContentArea(int x, int y, int width, int height) {
        super.calculateContentArea(x, y, width, height);
        int tabHeight = this.tabIconsContainer.getItemHeight(width, width, height);
        this.contentHeight -= tabHeight;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        Screen screen = this.currentScreen;
        if (screen != null) {
            screen.animate(currentTime, repaintRegion);
        }
        this.tabIconsContainer.animate(currentTime, repaintRegion);
    }

    public void setTabbarIsSelectable(boolean isSelectable) {
        this.isTabIconsContainerSelectable = isSelectable;
    }

    public boolean onCycle(Item item, int direction) {
        if (direction == 2 || direction == 1) {
            this.tabIconsContainerStyle = this.tabIconsContainer.focus(null, 0);
            this.isTabIconsContainerFocused = true;
            Screen scr = this.currentScreen;
            if (scr != null) {
                MenuBar currentMenuBar = scr.getMenuBar();
                int relY = currentMenuBar.relativeY;
                Container rc = scr.getRootContainer();
                rc.defocus(rc.style);
                if (currentMenuBar.relativeY != relY) {
                    int tabHeight = this.tabIconsContainer.itemHeight;
                    currentMenuBar.relativeY += tabHeight;
                }
            }
            this.repaint();
            return false;
        }
        return true;
    }

    public boolean _keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        if (this.isTabIconsContainerFocused) {
            if (this.tabIconsContainer.handleKeyPressed(keyCode, gameAction)) {
                Displayable disp = this.getDisplayable(this.tabIconsContainer.getFocusedIndex());
                if (disp instanceof Screen) {
                    Container rc = ((Screen)disp).getRootContainer();
                    rc.defocus(rc.style);
                }
                this.setFocus(this.tabIconsContainer.getFocusedIndex());
            } else if (gameAction == 6 || gameAction == 1) {
                this.tabIconsContainer.defocus(this.tabIconsContainerStyle);
                this.isTabIconsContainerFocused = false;
                if (this.currentScreen != null) {
                    Container rc = this.currentScreen.getRootContainer();
                    rc.focus(rc.style, gameAction);
                }
            }
            this.repaint();
            return true;
        }
        if (this.currentScreen != null) {
            this.lastInteractionTime = System.currentTimeMillis();
            boolean processed = this.currentScreen._keyPressed(keyCode);
            if (!processed) {
                Container rc;
                if (gameAction == 5 && this.currentDisplayableIndex < this.tabDisplayables.size() - 1) {
                    this.setFocus(this.currentDisplayableIndex + 1);
                    processed = true;
                } else if (gameAction == 2 && this.currentDisplayableIndex > 0) {
                    this.setFocus(this.currentDisplayableIndex - 1);
                    processed = true;
                }
                if (processed && this.currentScreen != null && !(rc = this.currentScreen.getRootContainer()).isFocused()) {
                    rc.focus(rc.style, 6);
                }
            }
            return processed;
        }
        return super._keyPressed(keyCode);
    }

    public boolean _keyRepeated(int keyCode) {
        if (!this.isTabIconsContainerFocused) {
            if (this.currentScreen != null) {
                return this.currentScreen._keyRepeated(keyCode);
            }
            return super._keyRepeated(keyCode);
        }
        return false;
    }

    public boolean _keyReleased(int keyCode) {
        if (!this.isTabIconsContainerFocused) {
            if (this.currentScreen != null) {
                return this.currentScreen._keyReleased(keyCode);
            }
            return super._keyReleased(keyCode);
        }
        return false;
    }

    public boolean _pointerDragged(int x, int y) {
        Container tabs = this.tabIconsContainer;
        Screen scr = this.currentScreen;
        if ((scr == null || !scr.isMenuOpened()) && tabs.isInItemArea(x - tabs.relativeX, y - tabs.relativeY)) {
            ClippingRegion repaintRegion = this.userEventRepaintRegion;
            repaintRegion.reset();
            tabs.handlePointerDragged(x - tabs.relativeX, y - tabs.relativeY, repaintRegion);
            if (repaintRegion.containsRegion()) {
                this.repaint(tabs.relativeX, tabs.relativeY, tabs.itemWidth, tabs.itemHeight);
                return true;
            }
        }
        if (scr != null) {
            return scr._pointerDragged(x, y);
        }
        return super._pointerDragged(x, y);
    }

    public boolean _pointerPressed(int x, int y) {
        Container tabs = this.tabIconsContainer;
        Screen scr = this.currentScreen;
        if ((scr == null || !scr.isMenuOpened()) && tabs.isInItemArea(x - tabs.relativeX, y - tabs.relativeY)) {
            if (tabs.handlePointerPressed(x - tabs.relativeX, y - tabs.relativeY)) {
                this.lastInteractionTime = System.currentTimeMillis();
                this.repaint();
                return true;
            }
            return false;
        }
        if (scr != null) {
            this.lastInteractionTime = System.currentTimeMillis();
            return scr._pointerPressed(x, y);
        }
        return super._pointerPressed(x, y);
    }

    public boolean _pointerReleased(int x, int y) {
        Container tabs = this.tabIconsContainer;
        Screen scr = this.currentScreen;
        if (!(scr != null && scr.isMenuOpened() || !tabs.isInItemArea(x - tabs.relativeX, y - tabs.relativeY) || scr != null && scr.getRootContainer() != null && scr.getRootContainer().isPressed())) {
            this.lastInteractionTime = System.currentTimeMillis();
            tabs.handlePointerReleased(x - tabs.relativeX, y - tabs.relativeY);
            int index = tabs.getFocusedIndex();
            if (index != -1) {
                Container rc;
                this.setFocus(index);
                if (this.isTabIconsContainerFocused) {
                    this.tabIconsContainer.defocus(this.tabIconsContainerStyle);
                    this.isTabIconsContainerFocused = false;
                }
                if (this.currentScreen != null && !(rc = this.currentScreen.getRootContainer()).isFocused()) {
                    rc.focus(rc.style, 6);
                }
                return true;
            }
            return false;
        }
        if (scr != null) {
            this.lastInteractionTime = System.currentTimeMillis();
            return scr._pointerReleased(x, y);
        }
        return super._pointerReleased(x, y);
    }

    public Item getItemAt(int x, int y) {
        Container tabs = this.tabIconsContainer;
        if (tabs.isInItemArea(x - tabs.relativeX, y - tabs.relativeY)) {
            return tabs.getItemAt(x - tabs.relativeX, y - tabs.relativeY);
        }
        Screen scr = this.currentScreen;
        if (scr != null) {
            return scr.getItemAt(x, y);
        }
        return super.getItemAt(x, y);
    }

    public void notifyScreenStateChanged() {
        if (this.currentScreen != null) {
            this.currentScreen.notifyScreenStateChanged();
        }
        super.notifyScreenStateChanged();
    }

    public void notifyStateListener(Item item) {
        if (this.currentScreen != null) {
            this.currentScreen.notifyStateListener(item);
        }
        super.notifyStateListener(item);
    }

    public void hideNotify() {
        if (this.currentScreen != null) {
            this.currentScreen._hideNotify();
        }
        super.hideNotify();
    }

    public void showNotify() {
        if (this.currentDisplayableIndex == -1 && this.tabDisplayables.size() > 0) {
            this.setFocus(0);
        }
        if (this.currentScreen != null) {
            this.currentScreen._showNotify();
        }
        super.showNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sizeChanged(int width, int height) {
        if (!this.isSizeChangedCalled) {
            this.isSizeChangedCalled = true;
            try {
                this.tabIconsContainer.onScreenSizeChanged(width, height);
                if (this.currentScreen != null) {
                    int tabAdjustedHeight = height - this.tabIconsContainer.itemHeight;
                    this.currentScreen.sizeChanged(width, tabAdjustedHeight);
                }
                super.sizeChanged(width, height);
                Object var5_4 = null;
                this.isSizeChangedCalled = false;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.isSizeChangedCalled = false;
                throw throwable;
            }
        }
    }

    protected boolean handleCommand(Command cmd) {
        if (this.currentScreen != null) {
            return this.currentScreen.handleCommand(cmd);
        }
        return super.handleCommand(cmd);
    }

    public int getCurrentIndex() {
        if (this.currentScreen != null) {
            return this.currentScreen.getCurrentIndex();
        }
        return super.getCurrentIndex();
    }

    public Item getCurrentItem() {
        if (this.currentScreen != null) {
            return this.currentScreen.getCurrentItem();
        }
        return super.getCurrentItem();
    }

    public void setScrollYOffset(int offset, boolean smooth) {
        if (this.currentScreen != null) {
            this.currentScreen.setScrollYOffset(offset, smooth);
        } else {
            super.setScrollYOffset(offset, smooth);
        }
    }

    public int getScrollHeight() {
        if (this.currentScreen != null) {
            return this.currentScreen.getScrollHeight();
        }
        return super.getScrollHeight();
    }

    public int getScrollYOffset() {
        if (this.currentScreen != null) {
            return this.currentScreen.getScrollYOffset();
        }
        return super.getScrollYOffset();
    }

    public int getScreenContentHeight() {
        if (this.currentScreen != null) {
            return this.currentScreen.getScreenContentHeight();
        }
        return super.getScreenContentHeight();
    }

    public int getScreenContentWidth() {
        if (this.currentScreen != null) {
            return this.currentScreen.getScreenContentWidth();
        }
        return super.getScreenContentWidth();
    }

    public int getScreenContentX() {
        if (this.currentScreen != null) {
            return this.currentScreen.getScreenContentX();
        }
        return super.getScreenContentX();
    }

    public int getScreenContentY() {
        if (this.currentScreen != null) {
            return this.currentScreen.getScreenContentY();
        }
        return super.getScreenContentY();
    }

    public Container getRootContainer() {
        if (this.currentScreen != null) {
            return this.currentScreen.getRootContainer();
        }
        return super.getRootContainer();
    }

    public void notifyScreenInitialized(Screen scr) {
        int tabHeight = this.tabIconsContainer.itemHeight;
        if (this.isTabPositionTop) {
            int titleH;
            this.tabIconsContainer.relativeY = titleH = scr.getTitleHeight();
            Item subtitle = scr.getSubTitleItem();
            if (subtitle != null) {
                subtitle.relativeY += tabHeight;
            }
            scr.backgroundHeight += tabHeight;
        }
        MenuBar currentMenuBar = scr.getMenuBar();
        currentMenuBar.relativeY = scr.screenHeight + tabHeight;
    }

    public void adjustContentArea(Screen scr) {
        if (this.isTabPositionTop) {
            int tabHeight = this.tabIconsContainer.itemHeight;
            scr.contentY += tabHeight;
        }
    }
}

