/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Background;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScreenInfo {
    public static Item item;
    private static boolean visible;
    private static int itemY;
    private static int itemX;
    private static boolean positionSet;

    private ScreenInfo() {
    }

    public static void setVisible(boolean isVisible) {
        if (isVisible) {
            item.showNotify();
        } else {
            item.hideNotify();
        }
        visible = isVisible;
        ScreenInfo.repaint();
    }

    public static boolean isVisible() {
        return visible;
    }

    private static void repaint() {
        Display display = Display.getInstance();
        if (display != null) {
            display.repaint();
        }
    }

    public static void setText(String text) {
        ((IconItem)item).setText(text);
        ScreenInfo.repaint();
    }

    public static String getText() {
        return ((IconItem)item).getText();
    }

    public static void setText(String text, Style style) {
        ((IconItem)item).setText(text, style);
        ScreenInfo.repaint();
    }

    public static void setImage(Image image) {
        ((IconItem)item).setImage(image);
    }

    public static void setImage(Image image, Style style) {
        ((IconItem)item).setImage(image, style);
    }

    public static void setItem(Item newItem) {
        item = newItem;
        if (visible) {
            newItem.showNotify();
        }
        ScreenInfo.repaint();
    }

    public static void setItem(Item newItem, Style style) {
        if (style != null) {
            item.setStyle(style);
        }
        item = newItem;
        if (visible) {
            newItem.showNotify();
        }
        ScreenInfo.repaint();
    }

    public static void setPosition(int x, int y) {
        itemX = x;
        itemY = y;
        ScreenInfo.item.relativeX = x;
        ScreenInfo.item.relativeY = y;
        positionSet = true;
        ScreenInfo.repaint();
    }

    public static void setScreen(Screen screen) {
        ScreenInfo.item.screen = screen;
    }

    public static void setBackground(Background background) {
        ScreenInfo.item.background = background;
        ScreenInfo.repaint();
    }

    public static void setFontColor(int color2) {
        ((IconItem)ScreenInfo.item).textColor = color2;
        ScreenInfo.repaint();
    }

    public static void paint(Graphics g, int titleHeight, int screenWidth) {
        if (!visible) {
            return;
        }
        if (positionSet) {
            item.paint(itemX, itemY, itemX, screenWidth, g);
        } else {
            item.paint(0, 0, 0, screenWidth, g);
        }
    }

    static {
        visible = true;
        item = new IconItem(null, null, StyleSheet.defaultStyle);
    }
}

