/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.event.EventManager;
import de.enough.polish.event.UiEventListener;
import de.enough.polish.ui.Animatable;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Border;
import de.enough.polish.ui.Canvas;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandItem;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.Display;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemStateListener;
import de.enough.polish.ui.MenuBar;
import de.enough.polish.ui.ScreenInfo;
import de.enough.polish.ui.ScreenInitializerListener;
import de.enough.polish.ui.ScreenStateListener;
import de.enough.polish.ui.ScrollBar;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.ui.UiElement;
import de.enough.polish.ui.backgrounds.TranslucentSimpleBackground;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import de.enough.polish.util.DeviceControl;
import javax.microedition.lcdui.Graphics;

public abstract class Screen
extends Canvas
implements UiElement,
Animatable {
    private static final int POSITION_TOP = 0;
    private static final int POSITION_LEFT = 1;
    protected Item title;
    private boolean excludeTitleForBackground;
    private Style titleStyle;
    private Item subTitle;
    protected int subTitleHeight;
    protected int titleHeight;
    protected Background background;
    protected int backgroundX;
    protected int backgroundY;
    protected int backgroundWidth;
    protected int backgroundHeight;
    protected Border border;
    protected Style style;
    protected int screenHeight;
    protected int originalScreenHeight;
    protected int screenWidth;
    protected String cssSelector;
    private ForwardCommandListener forwardCommandListener;
    protected Container container;
    private boolean isLayoutCenter;
    private boolean isLayoutRight;
    private boolean isLayoutVCenter;
    private boolean isLayoutBottom;
    private boolean isLayoutHorizontalShrink;
    private boolean isLayoutVerticalShrink;
    boolean isInitialized;
    private Command backCommand;
    protected int fullScreenHeight;
    protected int menuBarHeight;
    private boolean excludeMenuBarForBackground;
    private Command okCommand;
    private final MenuBar menuBar;
    Item focusedItem;
    protected final ScrollBar scrollBar = new ScrollBar(StyleSheet.scrollbarStyle);
    private boolean showTitleOrMenu = true;
    private Item infoItem;
    protected int infoHeight;
    protected int contentX;
    protected int contentY;
    protected int contentWidth;
    protected int contentHeight;
    private int marginLeft;
    private int marginRight;
    private int marginTop;
    private int marginBottom;
    protected boolean repaintPreviousScreen;
    private Canvas previousScreen;
    protected Background previousScreenOverlayBackground;
    protected ScreenStateListener screenStateListener;
    private boolean isScreenChangeDirtyFlag;
    protected ItemStateListener itemStateListener;
    private final Object paintLock;
    private ArrayList itemCommands;
    private Object data;
    protected long lastInteractionTime;
    protected boolean ignoreRepaintRequests;
    protected boolean isRepaintRequested;
    protected boolean isInitRequested;
    private CommandListener realCommandListener;
    private boolean isResourcesReleased;
    protected long lastAnimateTime = -1L;
    protected boolean isAnimated = false;
    private int keyStates;
    private int releasedKeys;
    private UiEventListener uiEventListener;
    protected Style landscapeStyle;
    protected Style portraitStyle;
    protected final ClippingRegion userEventRepaintRegion = new ClippingRegion();
    private ScreenInitializerListener screenInitializerListener;

    public Screen(String title, boolean createDefaultContainer) {
        this(title, null, createDefaultContainer);
    }

    public Screen(String title, boolean createDefaultContainer, Style style) {
        this(title, style, createDefaultContainer);
    }

    public Screen(String title, Style style, boolean createDefaultContainer) {
        this.scrollBar.screen = this;
        if (createDefaultContainer) {
            this.container = new Container(true);
            this.container.screen = this;
            this.container.isFocused = true;
        }
        this.style = style;
        this.forwardCommandListener = new ForwardCommandListener();
        this.menuBar = new MenuBar(this, StyleSheet.menubarStyle);
        this.setTitle(title);
        this.paintLock = new Object();
    }

    protected void init(int width, int height) {
        if (height == 0 || width == 0) {
            return;
        }
        this.fullScreenHeight = height;
        this.screenHeight = height;
        this.originalScreenHeight = height;
        this.screenWidth = width;
        if (this.style != null) {
            this.setStyle(this.style);
        }
        if (this.style == null) {
            this.cssSelector = this.createCssSelector();
            this.setStyle(StyleSheet.getStyle(this));
        } else {
            this.cssSelector = this.style.name;
        }
        if (this.title != null) {
            this.title.onScreenSizeChanged(width, height);
        }
        this.menuBar.onScreenSizeChanged(width, height);
        if (this.subTitle != null) {
            this.subTitle.onScreenSizeChanged(width, height);
        }
        if (this.container != null) {
            this.container.onScreenSizeChanged(width, height);
        }
        if (this.style != null) {
            this.marginLeft = this.style.getMarginLeft(this.screenWidth);
            this.marginRight = this.style.getMarginRight(this.screenWidth);
            this.marginTop = this.style.getMarginTop(this.screenHeight);
            this.marginBottom = this.style.getMarginBottom(this.screenHeight);
        }
        int availableScreenWidth = this.screenWidth;
        this.menuBarHeight = this.menuBar.getSpaceBottom(availableScreenWidth, this.fullScreenHeight);
        int diff = this.originalScreenHeight - this.screenHeight;
        this.originalScreenHeight = this.fullScreenHeight - this.menuBarHeight;
        this.screenHeight = this.originalScreenHeight - diff;
        if (this.container != null) {
            this.container.screen = this;
        }
        int availableWidth = this.screenWidth - this.marginLeft + this.marginRight;
        if (this.border != null) {
            availableWidth -= this.border.borderWidthLeft + this.border.borderWidthRight;
        }
        if (this.title != null) {
            this.titleHeight = this.title.getItemHeight(availableWidth, availableWidth, this.screenHeight);
        }
        this.menuBar.relativeY = this.screenHeight;
        this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        int menuHeight = this.menuBar.getSpaceBottom(availableScreenWidth, this.fullScreenHeight);
        if (menuHeight != this.menuBarHeight) {
            this.menuBarHeight = menuHeight;
            this.screenHeight = this.fullScreenHeight - menuHeight;
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        }
        this.isInitialized = true;
    }

    protected void requestInit() {
        this.isInitRequested = true;
    }

    public void requestRepaint() {
        if (this.ignoreRepaintRequests) {
            this.isRepaintRequested = true;
            return;
        }
        Display instance = Display.getInstance();
        if (instance != null) {
            instance.requestRepaint();
        }
    }

    public void requestRepaint(int x, int y, int width, int height) {
        if (this.ignoreRepaintRequests) {
            return;
        }
        Display instance = Display.getInstance();
        if (instance != null) {
            instance.requestRepaint(x, y, width, height);
        }
    }

    protected boolean checkForRequestInit(Item source) {
        return source == this.container || source == this.title || source == this.menuBar;
    }

    protected void calculateContentArea(int x, int y, int width, int height) {
        Item info;
        if (width < 1 || height < 1) {
            return;
        }
        int borderWidthL = 0;
        int borderWidthR = 0;
        int borderWidthT = 0;
        int borderWidthB = 0;
        if (this.border != null) {
            borderWidthL = this.border.borderWidthLeft;
            x += borderWidthL;
            borderWidthR = this.border.borderWidthRight;
            width -= borderWidthL + borderWidthR;
            borderWidthT = this.border.borderWidthTop;
            y += borderWidthT;
            borderWidthB = this.border.borderWidthBottom;
            height -= borderWidthT + borderWidthB;
        }
        x += this.marginLeft;
        y += this.marginTop;
        height -= this.marginTop + this.marginBottom;
        Container cont = this.container;
        int originalWidth = width -= this.marginLeft + this.marginRight;
        if (cont != null && this.isLayoutHorizontalShrink) {
            width = cont.getItemWidth(width, width, height) + cont.paddingLeft + cont.paddingRight;
        }
        boolean isTitleAtTop = true;
        if (this.title != null) {
            this.titleHeight = this.title.getItemHeight(width, width, height);
            this.title.relativeX = x;
            this.title.relativeY = y;
            int tw = this.title.itemWidth;
            if (tw < originalWidth) {
                if (this.title.isLayoutRight && !this.isLayoutHorizontalShrink || this.isLayoutHorizontalShrink && this.isLayoutRight) {
                    this.title.relativeX = x + (originalWidth - tw);
                } else if (this.title.isLayoutCenter && !this.isLayoutHorizontalShrink || this.isLayoutHorizontalShrink && this.isLayoutCenter) {
                    this.title.relativeX = x + (originalWidth - tw) / 2;
                }
            }
        }
        if (isTitleAtTop && this.excludeTitleForBackground) {
            this.backgroundY += this.titleHeight;
            this.backgroundHeight -= this.titleHeight;
        }
        boolean isSubTitleAtTop = true;
        if (this.subTitle != null) {
            this.subTitle.relativeX = x;
            this.subTitle.relativeY = y + this.titleHeight;
            this.subTitleHeight = this.subTitle.getItemHeight(width, width, height);
            int sw = this.subTitle.itemWidth;
            if (sw < originalWidth) {
                if (this.subTitle.isLayoutRight) {
                    this.subTitle.relativeX += originalWidth - sw;
                } else if (this.subTitle.isLayoutCenter) {
                    this.subTitle.relativeX += (originalWidth - sw) / 2;
                }
            }
        }
        int topHeight = 0;
        if (isTitleAtTop) {
            topHeight += this.titleHeight;
        } else {
            height -= this.titleHeight;
        }
        if (isSubTitleAtTop) {
            topHeight += this.subTitleHeight;
        } else {
            height -= this.subTitleHeight;
        }
        this.contentX = x;
        this.contentY = y += topHeight;
        this.contentWidth = originalWidth;
        this.contentHeight = height -= topHeight;
        this.adjustContentArea(x, y, originalWidth, height, cont);
        height = this.contentHeight;
        originalWidth = this.contentWidth;
        int previousMenuBarHeight = this.menuBarHeight;
        if (cont != null) {
            this.scrollBar.scrollBarHeight = height;
            int scrollBarWidth = this.scrollBar.getItemWidth(width, width, height);
            if (this.scrollBar.overlap) {
                scrollBarWidth = 0;
            }
            if (cont.itemHeight > height) {
                int w = originalWidth - scrollBarWidth;
                int containerHeight = cont.getItemHeight(w, w, height);
                if (containerHeight <= height && scrollBarWidth != 0) {
                    cont.getItemHeight(originalWidth, originalWidth, height);
                }
            } else {
                int containerHeight = cont.getItemHeight(originalWidth, originalWidth, height);
                if (containerHeight > height && scrollBarWidth != 0) {
                    int w = originalWidth - scrollBarWidth;
                    cont.getItemHeight(w, w, height);
                }
            }
            if (cont.itemHeight <= height) {
                this.scrollBar.isVisible = false;
            }
        }
        this.scrollBar.relativeX = x + width;
        int space = this.menuBar.getSpaceBottom(this.screenWidth, this.fullScreenHeight);
        if (space != previousMenuBarHeight) {
            this.contentHeight = height += previousMenuBarHeight - space;
            if (cont != null) {
                cont.getItemHeight(originalWidth, originalWidth, height);
            }
        }
        if ((info = this.infoItem) != null) {
            this.infoHeight = info.getItemHeight(width, width, height);
            info.relativeX = x;
            int iw = info.itemWidth;
            if (iw < originalWidth) {
                if (info.isLayoutRight) {
                    info.relativeX += originalWidth - iw;
                } else if (info.isLayoutCenter) {
                    info.relativeX += (originalWidth - iw) / 2;
                }
            }
            info.relativeY = topHeight;
        }
        if (cont != null && cont.itemHeight < height && this.isLayoutVerticalShrink && this.title != null) {
            if (this.isLayoutBottom && isTitleAtTop) {
                this.title.relativeY += height - cont.itemHeight;
            } else if (this.isLayoutVCenter) {
                this.title.relativeY += (height - cont.itemHeight) / 2;
            }
        }
        this.initContent(cont);
        if (this.screenInitializerListener != null) {
            this.screenInitializerListener.notifyScreenInitialized(this);
        }
    }

    protected void adjustContentArea(int x, int y, int width, int height, Container cont) {
        if (this.screenInitializerListener != null) {
            this.screenInitializerListener.adjustContentArea(this);
        }
    }

    protected void initContent(Container cont) {
        int borderWidthL = 0;
        int borderWidthR = 0;
        int borderWidthT = 0;
        int borderWidthB = 0;
        if (this.border != null) {
            borderWidthL = this.border.borderWidthLeft;
            borderWidthR = this.border.borderWidthRight;
            borderWidthT = this.border.borderWidthTop;
            borderWidthB = this.border.borderWidthBottom;
        }
        this.backgroundX = this.marginLeft + borderWidthL;
        this.backgroundY = this.marginTop + borderWidthT;
        this.backgroundWidth = this.screenWidth - this.backgroundX - borderWidthR - this.marginRight;
        this.backgroundHeight = this.fullScreenHeight - this.backgroundY - borderWidthB - this.marginBottom;
        if (this.isLayoutVerticalShrink) {
            this.backgroundHeight -= this.menuBarHeight - 1;
        }
        int x = this.contentX;
        int y = this.contentY;
        int width = this.contentWidth;
        int height = this.contentHeight;
        if (cont != null) {
            cont.relativeX = x;
            cont.relativeY = y;
            cont.setScrollHeight(height);
            int containerHeight = cont.itemHeight;
            int containerWidth = cont.itemWidth;
            if (containerHeight < height) {
                if (this.isLayoutVCenter) {
                    cont.relativeY = y + (height - containerHeight) / 2;
                    if (this.isLayoutVerticalShrink) {
                        this.backgroundY += (height - containerHeight) / 2;
                    }
                } else if (this.isLayoutBottom) {
                    cont.relativeY = y + (height - containerHeight);
                    if (this.isLayoutVerticalShrink) {
                        this.backgroundY += height - containerHeight;
                    }
                }
                if (this.isLayoutVerticalShrink) {
                    this.backgroundHeight -= height - containerHeight;
                }
            }
            if (containerHeight > height) {
                width -= this.getScrollBarWidth();
            }
            if (containerWidth < width) {
                Style myStyle;
                int paddingH = 0;
                if (this.isLayoutHorizontalShrink && (myStyle = this.style) != null) {
                    paddingH = myStyle.getPaddingLeft(width) + myStyle.getPaddingRight(width);
                }
                if (this.isLayoutCenter) {
                    cont.relativeX = x + (width - containerWidth) / 2;
                    if (this.isLayoutHorizontalShrink) {
                        this.backgroundX += (width - containerWidth - paddingH) / 2;
                    }
                } else if (this.isLayoutRight) {
                    cont.relativeX = x + (width - containerWidth);
                    if (this.isLayoutHorizontalShrink) {
                        this.backgroundX += width - containerWidth - paddingH;
                    }
                }
                if (this.isLayoutHorizontalShrink) {
                    this.backgroundWidth -= width - containerWidth - paddingH;
                }
            } else {
                cont.relativeX = x;
            }
        }
    }

    public void showNotify() {
        try {
            if (!this.isInitialized) {
                int w = this.getScreenFullWidth();
                int h = this.getScreenFullHeight();
                this.init(w, h);
            }
            if (this.repaintPreviousScreen) {
                Displayable currentDisplayable;
                if (this.previousScreenOverlayBackground == null) {
                    this.previousScreenOverlayBackground = new TranslucentSimpleBackground(-1442840576);
                }
                if ((currentDisplayable = StyleSheet.currentScreen) == null || currentDisplayable == this) {
                    currentDisplayable = Display.getInstance().getCurrent();
                }
                if (currentDisplayable != this && currentDisplayable instanceof Canvas) {
                    Displayable screen;
                    Displayable displayable = screen = currentDisplayable instanceof Screen ? currentDisplayable : null;
                    if (screen != null) {
                        Displayable previous = screen;
                        while (previous != null && previous.previousScreen instanceof Screen) {
                            previous = (Screen)previous.previousScreen;
                            if (previous != this) continue;
                            currentDisplayable = previous.previousScreen;
                            Displayable displayable2 = screen = currentDisplayable instanceof Screen ? currentDisplayable : null;
                            break;
                        }
                    }
                    if (this.previousScreen != null && screen != null) {
                        if (screen.previousScreen != this) {
                            this.previousScreen = screen;
                        } else {
                            screen.previousScreen = null;
                        }
                    } else {
                        this.previousScreen = (Canvas)currentDisplayable;
                    }
                }
            }
            Item[] items = this.getRootItems();
            for (int i = 0; i < items.length; ++i) {
                Item item = items[i];
                item.screen = this;
                item.showNotify();
            }
            if (this.container != null) {
                this.container.showNotify();
            }
            if (this.title != null) {
                this.title.showNotify();
            }
            this.menuBar.showNotify();
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.Screen", 1494, (Object)"error while calling showNotify", e);
        }
        StyleSheet.currentScreen = this;
        ScreenInfo.setScreen(this);
        if (this.background != null) {
            this.background.showNotify();
        }
        if (this.border != null) {
            this.border.showNotify();
        }
        this.lastInteractionTime = System.currentTimeMillis();
        this.isResourcesReleased = false;
    }

    public void hideNotify() {
        this.previousScreenOverlayBackground = null;
        Item[] items = this.getRootItems();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            item.hideNotify();
        }
        if (this.container != null) {
            this.container.hideNotify();
        }
        if (this.title != null) {
            this.title.hideNotify();
        }
        if (ScreenInfo.item.screen == this) {
            ScreenInfo.setScreen(null);
        }
        if (this.background != null) {
            this.background.hideNotify();
        }
        if (this.border != null) {
            this.border.hideNotify();
        }
        this.menuBar.hideNotify();
    }

    public void resetStyle(boolean recursive) {
        if (this.style != null) {
            this.setStyle(this.style);
        }
        if (recursive) {
            if (this.title != null) {
                this.title.resetStyle(recursive);
            }
            this.menuBar.resetStyle(recursive);
            if (this.subTitle != null) {
                this.subTitle.resetStyle(recursive);
            }
            if (this.container != null) {
                this.container.resetStyle(recursive);
            }
        }
    }

    public void setStyle(Style style) {
        Style lsStyle;
        Boolean repaintPreviousScreenBool;
        int width;
        if (style != this.style && this.style != null) {
            this.style.releaseResources();
        }
        this.style = style;
        this.background = style.background;
        this.border = style.border;
        if (this.container != null) {
            this.container.setStyleWithBackground(style, true);
        }
        this.isLayoutVCenter = (style.layout & 0x30) == 48;
        this.isLayoutBottom = !this.isLayoutVCenter && (style.layout & 0x20) == 32;
        this.isLayoutCenter = (style.layout & 3) == 3;
        this.isLayoutRight = !this.isLayoutCenter && (style.layout & 2) == 2;
        this.isLayoutHorizontalShrink = (style.layout & 0x400) == 1024;
        this.isLayoutVerticalShrink = (style.layout & 0x1000) == 4096;
        this.titleStyle = (Style)style.getObjectProperty(2);
        if (this.titleStyle != null && this.title != null) {
            this.title.setStyle(this.titleStyle);
            if (this.isInitialized) {
                width = this.screenWidth - (this.marginLeft + this.marginRight);
                this.titleHeight = this.title.getItemHeight(width, width, this.screenHeight);
            }
        } else if (this.title != null && this.title.isInitialized) {
            this.title.isInitialized = false;
            if (this.isInitialized) {
                width = this.screenWidth - (this.marginLeft + this.marginRight);
                this.titleHeight = this.title.getItemHeight(width, width, this.screenHeight);
            }
        }
        if ((repaintPreviousScreenBool = style.getBooleanProperty(116)) != null) {
            this.repaintPreviousScreen = repaintPreviousScreenBool;
        }
        if ((lsStyle = (Style)style.getObjectProperty(397)) != null) {
            this.landscapeStyle = lsStyle;
            this.portraitStyle = style;
        }
        this.setStyle(style, true);
    }

    public void setStyle(Style style, boolean resetStyle) {
        if (!resetStyle && this.isInitialized) {
            Dimension value = (Dimension)style.getObjectProperty(32713);
            if (value != null) {
                int margin;
                this.marginLeft = margin = value.getValue(this.screenWidth);
                this.marginRight = margin;
                this.marginTop = margin;
                this.marginBottom = margin;
            }
            if ((value = (Dimension)style.getObjectProperty(-4)) != null) {
                this.marginTop = value.getValue(this.screenHeight);
            }
            if ((value = (Dimension)style.getObjectProperty(-5)) != null) {
                this.marginBottom = value.getValue(this.screenHeight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animate(long currentTime, ClippingRegion repaintRegion) {
        if (!this.isInitialized) {
            return;
        }
        this.lastAnimateTime = currentTime;
        Object object = this.paintLock;
        synchronized (object) {
            try {
                int scrollYOffset = 0;
                if (this.container != null) {
                    scrollYOffset = this.container.yOffset;
                }
                if (this.animate()) {
                    repaintRegion.addRegion(0, 0, this.screenWidth, this.fullScreenHeight);
                }
                if (this.background != null) {
                    this.background.animate(this, null, currentTime, repaintRegion);
                }
                if (this.border != null) {
                    this.border.animate(this, null, currentTime, repaintRegion);
                }
                boolean isMenuOpen = this.isMenuOpened();
                this.menuBar.animate(currentTime, repaintRegion);
                if (this.container != null && !isMenuOpen) {
                    this.container.animate(currentTime, repaintRegion);
                }
                if (this.title != null) {
                    this.title.animate(currentTime, repaintRegion);
                }
                if (ScreenInfo.item != null && ScreenInfo.isVisible()) {
                    ScreenInfo.item.animate(currentTime, repaintRegion);
                }
                this.scrollBar.animate(currentTime, repaintRegion);
                if (this.container != null && this.container.yOffset != scrollYOffset) {
                    repaintRegion.addRegion(this.scrollBar.relativeX, this.scrollBar.relativeY, this.scrollBar.itemWidth, this.scrollBar.itemHeight);
                }
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.Screen", 2168, (Object)"animate(currentTime, repaintRegion) threw an exception", e);
            }
        }
    }

    public boolean animate() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.isResourcesReleased) {
            return;
        }
        if (!this.isInitialized) {
            this.init(this.getScreenFullWidth(), this.getScreenFullHeight());
        } else if (this.isInitRequested) {
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
            this.isInitRequested = false;
        }
        Object object = this.paintLock;
        synchronized (object) {
            try {
                if (this.repaintPreviousScreen && this.previousScreen != null) {
                    this.previousScreen.paint(g);
                    if (this.previousScreenOverlayBackground != null) {
                        int height = this.fullScreenHeight;
                        this.previousScreenOverlayBackground.paint(0, 0, this.screenWidth, height, g);
                    }
                }
                this.paintBackgroundAndBorder(g);
                this.paintTitleAndSubtitle(g);
                this.paintScreen(g);
                this.paintScrollBar(g);
                if (this.infoItem != null) {
                    this.infoItem.paint(this.infoItem.relativeX, this.infoItem.relativeY, this.marginLeft, this.screenWidth - this.marginRight, g);
                }
                ScreenInfo.paint(g, this.titleHeight, this.screenWidth);
                this.paintMenuBar(g);
            }
            catch (RuntimeException e) {
                Debug.debug("error", "de.enough.polish.ui.Screen", 2420, (Object)("unable to paint screen (" + this.getClass().getName() + "):"), e);
            }
        }
    }

    protected void paintScrollBar(Graphics g) {
        if (this.container != null && this.container.itemHeight > this.contentHeight) {
            int scrollX;
            int rightBorder = this.screenWidth - this.marginRight;
            this.scrollBar.relativeX = scrollX = rightBorder - this.scrollBar.initScrollBar(this.screenWidth, this.contentHeight, this.container.itemHeight, this.container.yOffset, this.container.internalY, this.container.internalHeight, this.container.focusedIndex, this.container.size());
            this.scrollBar.relativeY = this.container.relativeY;
            this.scrollBar.paint(scrollX, this.scrollBar.relativeY, scrollX, rightBorder, g);
        }
    }

    protected void paintMenuBar(Graphics g) {
        int leftBorder = this.marginLeft;
        Border bord = this.border;
        if (bord != null) {
            leftBorder += bord.borderWidthLeft;
        }
        boolean menuLeftX = false;
        int menuRightX = this.screenWidth;
        int menuY = this.screenHeight;
        MenuBar mb = this.menuBar;
        menuRightX = mb.relativeX + mb.itemWidth;
        mb.paint(mb.relativeX, mb.relativeY, mb.relativeX, menuRightX, g);
    }

    protected void paintTitleAndSubtitle(Graphics g) {
        Item st;
        int clipY;
        Item t = this.title;
        if (t != null && this.showTitleOrMenu && (clipY = g.getClipY()) < t.relativeY + t.itemHeight) {
            t.paint(t.relativeX, t.relativeY, t.relativeX, t.relativeX + t.itemWidth, g);
        }
        if ((st = this.subTitle) != null) {
            st.paint(st.relativeX, st.relativeY, st.relativeX, st.relativeX + st.itemWidth, g);
        }
    }

    protected void paintBackgroundAndBorder(Graphics g) {
        if (this.background != null) {
            this.background.paint(this.backgroundX, this.backgroundY, this.backgroundWidth, this.backgroundHeight, g);
        } else if (!this.repaintPreviousScreen) {
            g.setColor(0xFFFFFF);
            g.fillRect(this.backgroundX, this.backgroundY, this.backgroundWidth, this.backgroundHeight);
        }
        Border bord = this.border;
        if (bord != null) {
            int x = this.backgroundX - bord.borderWidthLeft;
            int y = this.backgroundY - bord.borderWidthTop;
            int width = this.backgroundWidth + bord.borderWidthLeft + bord.borderWidthRight;
            if (this.marginRight != 0 || this.isLayoutHorizontalShrink) {
                ++width;
            }
            int height = this.backgroundHeight + bord.borderWidthTop + bord.borderWidthBottom;
            bord.paint(x, y, width, height, g);
        }
    }

    protected boolean canScrollDown() {
        Container cont = this.container;
        return cont != null && cont.itemHeight + cont.yOffset > this.backgroundHeight;
    }

    protected boolean canScrollUp() {
        Container cont = this.container;
        return cont != null && cont.yOffset != 0;
    }

    protected int getScrollDownBackgroundOffset() {
        Container cont = this.container;
        if (cont != null && cont.itemHeight + cont.yOffset > this.backgroundHeight) {
            return cont.itemHeight + cont.yOffset - this.backgroundHeight;
        }
        return 0;
    }

    protected int getScrollUpBackgroundOffset() {
        Container cont = this.container;
        if (cont != null) {
            return -cont.yOffset;
        }
        return 0;
    }

    protected void paintScreen(Graphics g) {
        Container cont = this.container;
        if (cont == null || cont.size() == 0) {
            return;
        }
        if (!cont.isInitialized()) {
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int y = this.contentY;
        int x = this.contentX;
        int height = this.contentHeight;
        int width = this.contentWidth;
        int containerHeight = cont.itemHeight;
        g.clipRect(x, y, width, height);
        if (g.getClipHeight() > 0) {
            if (containerHeight > cont.availableHeight) {
                // empty if block
            }
            cont.paint(cont.relativeX, cont.relativeY, cont.relativeX, cont.relativeX + cont.itemWidth, g);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public String getTitle() {
        if (this.title == null) {
            return null;
        }
        if (!(this.title instanceof StringItem)) {
            return null;
        }
        return ((StringItem)this.title).getText();
    }

    public void setTitle(String s) {
        this.setTitle(s, null);
    }

    public void setTitle(String text, Style tStyle) {
        if (text != null) {
            if (this.title == null || !(this.title instanceof StringItem)) {
                this.title = new StringItem(null, text, StyleSheet.titleStyle);
                this.title.screen = this;
                if (this.titleStyle != null) {
                    this.title.setStyle(this.titleStyle);
                }
            } else {
                ((StringItem)this.title).setText(text);
            }
            if (tStyle != null) {
                this.title.setStyle(tStyle);
            }
        } else {
            this.title = null;
            this.titleHeight = 0;
        }
        if (this.isInitialized && super.isShown()) {
            if (this.title != null) {
                int width = this.screenWidth - this.marginLeft - this.marginRight;
                if (this.border != null) {
                    width -= this.border.borderWidthLeft + this.border.borderWidthRight;
                }
                this.titleHeight = this.title.getItemHeight(width, width, this.screenHeight);
            }
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
            this.requestRepaint();
        }
    }

    public void setTitle(Item item) {
        this.setTitle(item, null);
    }

    public void setTitle(Item item, Style tStyle) {
        this.title = item;
        if (item != null) {
            int width = 240 - (this.marginLeft + this.marginRight);
            if (width > 1) {
                this.titleHeight = this.title.getItemHeight(width, width, this.screenHeight);
            }
            item.screen = this;
        } else {
            this.titleHeight = 0;
        }
        if (this.isInitialized || super.isShown()) {
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
            this.requestRepaint();
        }
    }

    public Item getTitleItem() {
        Item item = null;
        item = this.title;
        return item;
    }

    public void setInfo(String infoText) {
        if (infoText == null) {
            this.infoItem = null;
        } else if (this.infoItem == null || !(this.infoItem instanceof StringItem)) {
            this.infoItem = new StringItem(null, infoText, StyleSheet.defaultStyle);
            this.infoItem.screen = this;
        } else if (this.isInitialized) {
            StringItem info = (StringItem)this.infoItem;
            info.setText(infoText);
            int leftX = this.marginLeft + (this.border != null ? this.border.borderWidthLeft : 0);
            int width = this.screenWidth - leftX - this.marginRight - (this.border != null ? this.border.borderWidthRight : 0);
            int ih = info.getItemHeight(width, width, this.contentHeight);
            if (ih == this.infoHeight) {
                info.relativeX = leftX;
                int iw = info.itemWidth;
                if (iw < width) {
                    if (info.isLayoutRight) {
                        info.relativeX = leftX + width - iw;
                    } else if (info.isLayoutCenter) {
                        info.relativeX = leftX + (width - iw) / 2;
                    }
                }
                return;
            }
        }
        this.setInfo(this.infoItem);
    }

    public void setInfo(Item info) {
        this.infoItem = info;
        if (info == null) {
            this.infoHeight = 0;
        }
        this.isInitRequested = this.isInitialized;
    }

    public int getKeyStates() {
        int states = this.keyStates;
        this.keyStates &= ~this.releasedKeys;
        this.releasedKeys = 0;
        return states;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean _keyPressed(int keyCode) {
        this.keyPressed(keyCode);
        boolean processed = false;
        this.lastInteractionTime = System.currentTimeMillis();
        Object object = this.paintLock;
        synchronized (object) {
            int gameAction;
            block10: {
                boolean bl;
                try {
                    boolean letTheMenuBarProcessKey;
                    this.ignoreRepaintRequests = true;
                    gameAction = this.getGameAction(keyCode);
                    if (gameAction != 0) {
                        int bit = 1 << gameAction;
                        this.keyStates |= bit;
                        this.releasedKeys &= ~bit;
                    }
                    if (!(letTheMenuBarProcessKey = this.menuBar.isOpened)) {
                        processed = this.handleKeyPressed(keyCode, gameAction);
                    }
                    if (processed) break block10;
                    if (this.menuBar.handleKeyPressed(keyCode, gameAction)) {
                        this.repaint();
                        boolean bl2 = true;
                        Object var8_8 = null;
                        this.ignoreRepaintRequests = false;
                        this.isScreenChangeDirtyFlag = false;
                        return bl2;
                    }
                    if (!this.menuBar.isSoftKeyPressed) break block10;
                    bl = false;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    this.ignoreRepaintRequests = false;
                    this.isScreenChangeDirtyFlag = false;
                    throw throwable;
                }
                Object var8_9 = null;
                this.ignoreRepaintRequests = false;
                this.isScreenChangeDirtyFlag = false;
                return bl;
            }
            if (processed || this.isRepaintRequested) {
                this.isRepaintRequested = false;
                if (gameAction == 1 || gameAction == 6) {
                    this.scrollBar.resetAnimation();
                }
                this.notifyScreenStateChanged();
                this.repaint();
                processed = true;
            }
            Object var8_10 = null;
            this.ignoreRepaintRequests = false;
            this.isScreenChangeDirtyFlag = false;
            return processed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _keyRepeated(int keyCode) {
        block7: {
            int gameAction;
            block6: {
                block5: {
                    this.keyRepeated(keyCode);
                    try {
                        this.ignoreRepaintRequests = true;
                        this.lastInteractionTime = System.currentTimeMillis();
                        gameAction = this.getGameAction(keyCode);
                        if (!this.menuBar.handleKeyRepeated(keyCode, gameAction)) break block5;
                        this.repaint();
                        boolean bl = true;
                        Object var6_6 = null;
                        this.ignoreRepaintRequests = false;
                        return bl;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        this.ignoreRepaintRequests = false;
                        throw throwable;
                    }
                }
                if (!this.menuBar.isOpened) break block6;
                boolean bl = true;
                Object var6_7 = null;
                this.ignoreRepaintRequests = false;
                return bl;
            }
            boolean handled = this.handleKeyRepeated(keyCode, gameAction);
            if (!handled && !this.isRepaintRequested) break block7;
            this.isRepaintRequested = false;
            this.repaint();
            boolean bl = true;
            Object var6_8 = null;
            this.ignoreRepaintRequests = false;
            return bl;
        }
        Object var6_9 = null;
        this.ignoreRepaintRequests = false;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean _keyReleased(int keyCode) {
        this.keyReleased(keyCode);
        boolean processed = false;
        try {
            Object object = this.paintLock;
            synchronized (object) {
                this.ignoreRepaintRequests = true;
                this.lastInteractionTime = System.currentTimeMillis();
                int gameAction = this.getGameAction(keyCode);
                if (gameAction != 0) {
                    this.releasedKeys |= 1 << gameAction;
                }
                if (this.isMenuOpened()) {
                    processed = this.menuBar.handleKeyReleased(keyCode, gameAction);
                    if (processed) {
                        this.repaint();
                    }
                    boolean bl = true;
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 9] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                    Object var8_6 = null;
                    this.ignoreRepaintRequests = false;
                    return bl;
                }
                processed = this.handleKeyReleased(keyCode, gameAction);
                if (!processed && !this.isMenuOpened()) {
                    processed = this.menuBar.handleKeyReleased(keyCode, gameAction);
                }
                if (!processed && gameAction == 8 && keyCode != 53 && this.okCommand != null && !this.isMenuOpened() && this.container.isFocused) {
                    this.callCommandListener(this.okCommand);
                    processed = true;
                }
                if (processed || this.isRepaintRequested) {
                    this.isRepaintRequested = false;
                    this.repaint();
                    processed = true;
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.ignoreRepaintRequests = false;
            throw throwable;
        }
        Object var8_7 = null;
        this.ignoreRepaintRequests = false;
        return processed;
    }

    protected abstract String createCssSelector();

    protected Item[] getRootItems() {
        return new Item[0];
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (this.container == null) {
            return false;
        }
        return this.container.handleKeyPressed(keyCode, gameAction);
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        if (this.container == null) {
            return false;
        }
        return this.container.handleKeyRepeated(keyCode, gameAction);
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        if (this.container == null) {
            return false;
        }
        return this.container.handleKeyReleased(keyCode, gameAction);
    }

    public void setScreenStateListener(ScreenStateListener listener) {
        this.screenStateListener = listener;
    }

    public void notifyScreenStateChanged() {
        if (this.screenStateListener != null && !this.isScreenChangeDirtyFlag) {
            this.isScreenChangeDirtyFlag = true;
            this.screenStateListener.screenStateChanged(this);
        }
    }

    public void setCommandListener(CommandListener listener) {
        this.realCommandListener = listener;
    }

    public CommandListener getCommandListener() {
        return this.realCommandListener;
    }

    public void addCommand(Command cmd) {
        Style menuItemStyle = this.menuBar.getMenuItemStyle();
        if (menuItemStyle != null) {
            this.addCommand(cmd, menuItemStyle);
        } else {
            this.addCommand(cmd, StyleSheet.menuitemStyle);
        }
    }

    public void addCommand(Command cmd, Style commandStyle) {
        int cmdType = cmd.getCommandType();
        if (cmdType == 4 && (this.okCommand == null || this.okCommand.getPriority() > cmd.getPriority())) {
            this.okCommand = cmd;
        } else if (!(cmdType != 2 && cmdType != 3 && cmdType != 7 || this.backCommand != null && this.backCommand.getPriority() <= cmd.getPriority())) {
            this.backCommand = cmd;
        }
        this.menuBar.addCommand(cmd, commandStyle);
        if (this.isInitialized || this.screenWidth > 0) {
            this.initMenuBar();
        }
        if (super.isShown()) {
            this.requestRepaint();
        }
    }

    public CommandItem getCommandItem(Command command) {
        CommandItem commandItem = null;
        commandItem = this.menuBar.getCommandItem(command);
        return commandItem;
    }

    public void removeAllCommands() {
        this.menuBar.removeAllCommands();
        if (this.isInitialized) {
            this.initMenuBar();
        }
        if (super.isShown()) {
            this.requestRepaint();
        }
        this.backCommand = null;
    }

    public Object[] getCommands() {
        Object[] commands = this.menuBar.getCommands();
        return commands;
    }

    public void addSubCommand(Command child, Command parent) {
        if (child.getStyle() != null) {
            this.addSubCommand(child, parent, child.getStyle());
        } else {
            this.addSubCommand(child, parent, StyleSheet.menuitemStyle);
        }
    }

    public void addSubCommand(Command child, Command parent, Style commandStyle) {
        if (commandStyle != null) {
            child.setStyle(commandStyle);
        }
        if (!parent.addSubCommand(child)) {
            return;
        }
        this.menuBar.addSubCommand(child, parent, commandStyle);
        if (super.isShown() || this.isMenuOpened()) {
            this.requestRepaint();
        }
    }

    public void removeCommand(Command cmd) {
        if (cmd == this.backCommand) {
            Command command;
            this.backCommand = null;
            Object[] commands = this.getCommands();
            for (int i = 0; i < commands.length && (command = (Command)commands[i]) != null; ++i) {
                int cmdType = command.getCommandType();
                if (command == cmd || cmdType != 2 && cmdType != 3 && cmdType != 7 || this.backCommand != null && command.getPriority() >= this.backCommand.getPriority()) continue;
                this.backCommand = command;
            }
        }
        if (this.okCommand == cmd) {
            this.okCommand = null;
        }
        this.menuBar.removeCommand(cmd);
        if (this.isInitialized) {
            this.initMenuBar();
        }
        if (super.isShown()) {
            this.requestRepaint();
        }
    }

    public void removeSubCommand(Command childCommand, Command parentCommand) {
        this.menuBar.removeSubCommand(childCommand, parentCommand);
        if (super.isShown() || this.isMenuOpened()) {
            this.requestRepaint();
        }
    }

    private void initMenuBar() {
        int availableWidth = this.screenWidth;
        int previousHeight = this.menuBar.itemHeight;
        int height = this.menuBar.getSpaceBottom(availableWidth, this.fullScreenHeight);
        if (height != previousHeight) {
            this.menuBarHeight = height;
            this.menuBar.relativeY = this.screenHeight = this.fullScreenHeight - height;
            this.isInitialized = false;
        }
    }

    public void addCommandsLayer(Command[] commands) {
        this.menuBar.addCommandsLayer(commands);
    }

    public void removeCommandsLayer() {
        this.menuBar.removeCommandsLayer();
    }

    protected void setItemCommands(ArrayList commandsList, Item item) {
        Command cmd;
        this.focusedItem = item;
        if (commandsList != null) {
            Command command;
            Object[] commands = commandsList.getInternalArray();
            if (this.itemCommands == null) {
                this.itemCommands = new ArrayList(commands.length);
            } else if (this.itemCommands.size() > 0) {
                this.clearItemCommands();
            }
            for (int i = 0; i < commands.length && (command = (Command)commands[i]) != null; ++i) {
                boolean addCommand;
                boolean bl = addCommand = !this.menuBar.contains(command);
                if (!addCommand) continue;
                this.addCommand(command);
                this.itemCommands.add(command);
            }
        } else if (this.itemCommands != null) {
            this.itemCommands.clear();
        }
        if ((cmd = this.getDefaultCommand(item)) != null) {
            this.menuBar.informDefaultCommand(cmd);
        }
        if (this.isShown()) {
            this.requestRepaint();
        }
    }

    public void notifyDefaultCommand(Command cmd) {
        if (cmd != null) {
            this.menuBar.informDefaultCommand(cmd);
        }
    }

    protected Command getDefaultCommand(Item item) {
        return item.defaultCommand;
    }

    protected void clearItemCommands() {
        if (this.itemCommands != null) {
            Command command;
            Object[] commands = this.itemCommands.getInternalArray();
            for (int i = 0; i < commands.length && (command = (Command)commands[i]) != null; ++i) {
                this.removeCommand(command);
            }
        }
        if (this.menuBar.size() == 0) {
            this.menuBarHeight = 0;
        }
        if (super.isShown()) {
            this.requestRepaint();
        }
        if (this.itemCommands != null) {
            this.itemCommands.clear();
        }
    }

    protected void removeItemCommands(Item item) {
        if (this.itemCommands != null && this.itemCommands.size() > 0) {
            Command command;
            Object[] commands = this.itemCommands.getInternalArray();
            for (int i = 0; i < commands.length && (command = (Command)commands[i]) != null; ++i) {
                this.removeCommand(command);
            }
            this.itemCommands.clear();
            if (this.menuBar.size() == 0) {
                this.menuBarHeight = 0;
            }
            if (this.focusedItem == item) {
                this.focusedItem = null;
            }
            if (super.isShown()) {
                this.requestRepaint();
            }
        }
    }

    protected void callCommandListener(Command cmd) {
        this.menuBar.setOpen(false);
        if (this.forwardCommandListener != null) {
            try {
                this.forwardCommandListener.commandAction(cmd, this);
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.Screen", 4768, (Object)("Screen: unable to process command [" + cmd.getLabel() + "]"), e);
            }
        }
    }

    public int getAvailableHeight() {
        return this.screenHeight - this.titleHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _pointerPressed(int x, int y) {
        this.pointerPressed(x, y);
        this.lastInteractionTime = System.currentTimeMillis();
        try {
            this.ignoreRepaintRequests = true;
            boolean processed = false;
            if (!processed) {
                processed = this.menuBar.handlePointerPressed(x - this.menuBar.relativeX, y - this.menuBar.relativeY);
            }
            if (!processed) {
                processed = this.handlePointerPressed(x, y);
            }
            if (!processed && this.subTitle != null) {
                processed = this.subTitle.handlePointerPressed(x - this.subTitle.relativeX, y - this.subTitle.relativeY);
            }
            if (!processed) {
                this.scrollBar.handlePointerPressed(x - this.scrollBar.relativeX, y - this.scrollBar.relativeY);
            } else {
                this.scrollBar.isPointerPressedHandled = false;
            }
            if (!processed && this.title != null) {
                processed = this.title.handlePointerPressed(x - this.title.relativeX, y - this.title.relativeY);
            }
            if (processed || this.isRepaintRequested) {
                this.isRepaintRequested = false;
                this.notifyScreenStateChanged();
                this.repaint();
                processed = true;
            }
            boolean bl = processed;
            Object var6_7 = null;
            this.ignoreRepaintRequests = false;
            this.isScreenChangeDirtyFlag = false;
            return bl;
        }
        catch (Exception e) {
            try {
                Debug.debug("error", "de.enough.polish.ui.Screen", 4915, (Object)("PointerPressed at " + x + "," + y + " resulted in exception"), e);
                boolean bl = false;
                Object var6_8 = null;
                this.ignoreRepaintRequests = false;
                this.isScreenChangeDirtyFlag = false;
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.ignoreRepaintRequests = false;
                this.isScreenChangeDirtyFlag = false;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _pointerDragged(int x, int y) {
        block10: {
            ClippingRegion repaintRegion;
            block9: {
                block8: {
                    block7: {
                        this.pointerDragged(x, y);
                        try {
                            this.ignoreRepaintRequests = true;
                            repaintRegion = this.userEventRepaintRegion;
                            repaintRegion.reset();
                            if (!this.scrollBar.handlePointerDragged(x - this.scrollBar.relativeX, y - this.scrollBar.relativeY, repaintRegion)) break block7;
                            this.repaint(repaintRegion);
                            boolean bl = true;
                            Object var6_8 = null;
                            this.ignoreRepaintRequests = false;
                            return bl;
                        }
                        catch (Throwable throwable) {
                            Object var6_13 = null;
                            this.ignoreRepaintRequests = false;
                            throw throwable;
                        }
                    }
                    if (!this.menuBar.handlePointerDragged(x - this.menuBar.relativeX, y - this.menuBar.relativeY, repaintRegion)) break block8;
                    this.repaint(repaintRegion);
                    boolean bl = true;
                    Object var6_9 = null;
                    this.ignoreRepaintRequests = false;
                    return bl;
                }
                if (this.title == null || !this.title.handlePointerDragged(x - this.title.relativeX, y - this.title.relativeY, repaintRegion)) break block9;
                this.repaint(repaintRegion);
                boolean bl = true;
                Object var6_10 = null;
                this.ignoreRepaintRequests = false;
                return bl;
            }
            if (this.handlePointerDragged(x, y)) {
                this.repaint();
            }
            repaintRegion.reset();
            this.handlePointerDragged(x, y, repaintRegion);
            if (!repaintRegion.containsRegion()) break block10;
            this.repaint(repaintRegion);
            boolean bl = true;
            Object var6_11 = null;
            this.ignoreRepaintRequests = false;
            return bl;
        }
        Object var6_12 = null;
        this.ignoreRepaintRequests = false;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _pointerReleased(int x, int y) {
        this.pointerReleased(x, y);
        boolean processed = false;
        try {
            this.ignoreRepaintRequests = true;
            this.lastInteractionTime = System.currentTimeMillis();
            if (!processed) {
                processed = this.menuBar.handlePointerReleased(x - this.menuBar.relativeX, y - this.menuBar.relativeY);
            }
            if (!processed) {
                processed = this.handlePointerReleased(x, y);
            }
            if (!processed && this.subTitle != null) {
                processed = this.subTitle.handlePointerReleased(x - this.subTitle.relativeX, y - this.subTitle.relativeY);
            }
            if (!processed) {
                processed = this.scrollBar.handlePointerReleased(x - this.scrollBar.relativeX, y - this.scrollBar.relativeY);
            }
            if (!processed && this.title != null) {
                processed = this.title.handlePointerReleased(x - this.title.relativeX, y - this.title.relativeY);
            }
            if (processed || this.isRepaintRequested) {
                this.isRepaintRequested = false;
                this.repaint();
                processed = true;
            }
            Object var5_4 = null;
            this.ignoreRepaintRequests = false;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.ignoreRepaintRequests = false;
            throw throwable;
        }
        return processed;
    }

    protected boolean handlePointerPressed(int x, int y) {
        boolean handled = false;
        if (this.container != null) {
            handled = this.container.handlePointerPressed(x - this.container.relativeX, y - this.container.relativeY);
        }
        return handled;
    }

    protected boolean handlePointerReleased(int x, int y) {
        boolean handled = false;
        Container cont = this.container;
        if (cont != null) {
            handled = cont.handlePointerReleased(x - cont.relativeX, y - cont.relativeY);
        }
        if (!handled && this.repaintPreviousScreen) {
            if (cont != null) {
                int left = cont.relativeX;
                int top = cont.relativeY - this.titleHeight;
                int right = left + cont.itemWidth;
                int bottom = top + Math.min(this.contentY + this.contentHeight, this.titleHeight + cont.itemHeight);
                if (x <= left || y <= top || x >= right || y >= bottom) {
                    this.handlePointerReleasedOutsideScreenArea(x, y);
                }
            } else if (x <= this.marginLeft || y <= this.marginTop || x >= this.screenWidth - this.marginRight || y >= this.screenHeight - this.marginBottom) {
                this.handlePointerReleasedOutsideScreenArea(x, y);
            }
        }
        return handled;
    }

    protected boolean handlePointerReleasedOutsideScreenArea(int x, int y) {
        boolean handled = false;
        if (this.backCommand != null) {
            this.handleCommand(this.backCommand);
        } else {
            Object[] commands = this.getCommands();
            if (commands != null) {
                Object cmd;
                int commandCount = 0;
                for (int i = 0; i < commands.length && (cmd = commands[i]) != null; ++i) {
                    ++commandCount;
                }
                if (commandCount == 1) {
                    this.handleCommand((Command)commands[0]);
                }
            }
        }
        return handled;
    }

    protected boolean handlePointerDragged(int x, int y, ClippingRegion repaintRegion) {
        boolean handled = false;
        if (this.container != null) {
            handled = this.container.handlePointerDragged(x - this.container.relativeX, y - this.container.relativeY, repaintRegion);
        }
        return handled;
    }

    protected boolean handlePointerDragged(int x, int y) {
        return false;
    }

    public boolean handlePointerTouchDown(int x, int y) {
        boolean handled = false;
        return handled;
    }

    public boolean handlePointerTouchUp(int x, int y) {
        boolean handled = false;
        return handled;
    }

    protected boolean handleCommand(Command cmd) {
        Item item = this.container;
        if (item == null) {
            item = this.getCurrentItem();
        }
        if (item != null && item.handleCommand(cmd)) {
            return true;
        }
        if (cmd.commandAction(item, this)) {
            return true;
        }
        CommandListener listener = this.realCommandListener;
        if (listener != null) {
            listener.commandAction(cmd, this);
            return true;
        }
        return false;
    }

    public void setFullScreenMode(boolean enable) {
        this.showTitleOrMenu = !enable;
        this.screenHeight = enable ? this.fullScreenHeight : this.originalScreenHeight;
        this.requestRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sizeChanged(int width, int height) {
        boolean doInit;
        if (this.paintLock == null) {
            return;
        }
        if (!DeviceControl.isSoftKeyboardShown()) {
            Style newStyle = null;
            if (width > height) {
                if (this.landscapeStyle != null && this.style != this.landscapeStyle) {
                    newStyle = this.landscapeStyle;
                }
            } else if (this.portraitStyle != null && this.style != this.portraitStyle) {
                newStyle = this.portraitStyle;
            }
            if (newStyle != null) {
                this.setStyle(newStyle);
            }
        }
        boolean bl = doInit = width != this.screenWidth || height != this.fullScreenHeight;
        if (doInit) {
            int diff;
            if (this.fullScreenHeight != 0 && (diff = height - this.fullScreenHeight) > 0 && this.container != null) {
                int offset = this.container.getScrollYOffset() + diff;
                if (offset > 0) {
                    offset = 0;
                }
                this.container.setScrollYOffset(offset, false);
            }
            this.fullScreenHeight = height;
            this.originalScreenHeight = this.screenHeight = height - this.menuBarHeight;
            this.screenWidth = width;
        }
        if (doInit) {
            int beforeYOffset = this.getScrollYOffset();
            Object offset = this.paintLock;
            synchronized (offset) {
                this.init(width, height);
            }
            int afterYOffset = this.getScrollYOffset();
            if (beforeYOffset != afterYOffset && this.getRootContainer() != null && this.getRootContainer().itemHeight < this.contentHeight) {
                this.setScrollYOffset(0, false);
            }
        }
        if (this.repaintPreviousScreen && this.previousScreen != null) {
            this.previousScreen.sizeChanged(width, height);
        }
    }

    public int getScreenHeight() {
        int result = this.fullScreenHeight;
        return result;
    }

    public void focus(Item item) {
        this.focus(item, false);
    }

    public void focus(Item item, boolean force) {
        int index;
        if (item == null) {
            index = -1;
        } else {
            if (item.isFocused) {
                return;
            }
            if (force || item.isInteractive()) {
                index = this.container.itemsList.indexOf(item);
                if (index == -1) {
                    ArrayList children = new ArrayList();
                    children.add(item);
                    Item parent = item.parent;
                    while (parent != null) {
                        if (parent.parent == this.container && (index = this.container.itemsList.indexOf(parent)) != -1) {
                            this.focus(index, parent, force);
                            for (int i = children.size() - 1; i >= 0; --i) {
                                Item child = (Item)children.get(i);
                                if (child.appearanceMode == 0 && !force) {
                                    return;
                                }
                                Container parentContainer = (Container)child.parent;
                                parentContainer.focusChild(parentContainer.indexOf(child), child, 0, force);
                            }
                            return;
                        }
                        children.add(parent);
                        parent = parent.parent;
                    }
                    if (index == -1) {
                        this.menuBar.focusChild(item);
                        return;
                    }
                }
            } else {
                return;
            }
        }
        this.focus(index, item, force);
    }

    public void focus(int index) {
        this.focus(index, true);
    }

    public void focus(int index, boolean force) {
        Item item = null;
        if (index != -1) {
            item = this.container.get(index);
        }
        this.focus(index, item, force);
    }

    public void focus(int index, Item item, boolean force) {
        if (item != null && item.isFocused) {
            return;
        }
        if (index != -1 && item != null && (item.appearanceMode != 0 || force)) {
            this.container.focusChild(index, item, 0, force);
            if (index == 0) {
                this.container.setScrollYOffset(0, false);
            }
        } else if (index == -1) {
            this.container.focusChild(-1);
        }
        this.repaint();
    }

    protected void setSubTitle(Item subTitle) {
        this.subTitle = subTitle;
        if (subTitle == null) {
            this.subTitleHeight = 0;
        } else {
            subTitle.screen = this;
        }
        if (this.isInitialized) {
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        }
    }

    public Item getCurrentItem() {
        if (this.container != null) {
            if (this.container.autoFocusEnabled) {
                Item[] items = this.container.getItems();
                for (int i = 0; i < items.length; ++i) {
                    if (i < this.container.autoFocusIndex || items[i].appearanceMode == 0) continue;
                    return items[i];
                }
            }
            return this.container.focusedItem;
        }
        return this.focusedItem;
    }

    public int getCurrentIndex() {
        if (this.container != null) {
            return this.container.focusedIndex;
        }
        return -1;
    }

    public boolean isMenuOpened() {
        boolean result = false;
        result = this.menuBar.isOpened;
        return result;
    }

    public void closeMenu() {
        this.menuBar.setOpen(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResources() {
        Object object = this.paintLock;
        synchronized (object) {
            if (this.background != null) {
                this.background.releaseResources();
            }
            if (this.container != null) {
                this.container.releaseResources();
            }
            this.menuBar.releaseResources();
            if (this.title != null) {
                this.title.releaseResources();
            }
            this.isResourcesReleased = true;
        }
    }

    public void destroy() {
        this.releaseResources();
        this.container.destroy();
        if (this.screenStateListener != null) {
            this.screenStateListener = null;
        }
        if (this.itemStateListener != null) {
            this.itemStateListener = null;
        }
        if (this.forwardCommandListener != null) {
            this.forwardCommandListener = null;
        }
        if (this.realCommandListener != null) {
            this.realCommandListener = null;
        }
    }

    public void scrollRelative(int amount) {
        if (this.container != null) {
            this.container.setScrollYOffset(this.container.getScrollYOffset() + amount);
            this.requestRepaint();
        }
    }

    public void setScreenData(Object data) {
        this.data = data;
    }

    public Object getScreenData() {
        return this.data;
    }

    public Item getItemAt(int x, int y) {
        Item item = null;
        item = this.menuBar.getItemAt(x - this.menuBar.relativeX, y - this.menuBar.relativeY);
        if (item != null) {
            return item;
        }
        if (this.container != null && (item = this.container.getItemAt(x - this.container.relativeX, y - this.container.relativeY)) != null) {
            return item;
        }
        if (this.title != null && (item = this.title.getItemAt(x - this.title.relativeX, y - this.title.relativeY)) != null) {
            return item;
        }
        if (ScreenInfo.item != null && ScreenInfo.isVisible() && (item = ScreenInfo.item.getItemAt(x - ScreenInfo.item.relativeX, y - ScreenInfo.item.relativeY)) != null) {
            return item;
        }
        return null;
    }

    public Style getScreenStyle() {
        return this.style;
    }

    public void setItemStateListener(ItemStateListener iListener) {
        this.itemStateListener = iListener;
    }

    protected void notifyStateListener(Item item) {
        if (this.itemStateListener != null) {
            try {
                this.itemStateListener.itemStateChanged(item);
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.Screen", 5884, (Object)("Unable to forward itemStateChanged event for listener " + this.itemStateListener), e);
            }
        }
    }

    protected boolean isKeyboardAccessible() {
        return false;
    }

    protected int getScrollBarWidth() {
        int width = 0;
        if (!this.scrollBar.overlap) {
            width = this.scrollBar.itemWidth;
        }
        return width;
    }

    public int getScreenContentHeight() {
        if (this.contentHeight == 0) {
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        }
        return this.contentHeight;
    }

    public int getScreenContentWidth() {
        if (this.contentHeight == 0) {
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        }
        return this.contentWidth;
    }

    public int getScreenContentX() {
        if (this.contentHeight == 0) {
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        }
        return this.contentX;
    }

    public int getScreenContentY() {
        if (this.contentHeight == 0) {
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        }
        return this.contentY;
    }

    public int getScreenFullHeight() {
        int height = this.fullScreenHeight;
        if (height == 0) {
            height = Display.getScreenHeight();
        }
        return height;
    }

    public int getScreenFullWidth() {
        return Display.getScreenWidth();
    }

    public void setMenuItemStyle(Style menuItemStyle) {
        this.menuBar.setMenuItemStyle(menuItemStyle);
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBarStyle(Style menuBarStyle) {
        this.menuBar.setStyle(menuBarStyle);
        this.requestInit();
    }

    public int getScrollYOffset() {
        if (this.container != null) {
            return this.container.getScrollYOffset();
        }
        return 0;
    }

    public int getScrollHeight() {
        if (this.container != null) {
            return this.container.getItemAreaHeight();
        }
        return 0;
    }

    public void setScrollYOffset(int offset, boolean smooth) {
        if (this.container != null) {
            this.container.setScrollYOffset(offset, smooth);
        }
    }

    public boolean isActive() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this.lastInteractionTime < 100L || currentTime - this.lastAnimateTime < 100L;
    }

    public boolean isInteracted(long timespan) {
        return System.currentTimeMillis() - this.lastInteractionTime < timespan;
    }

    public void setScreenOrientation(int degrees) {
        Display.setScreenOrientation(degrees);
    }

    public boolean isGameActionFire(int keyCode, int gameAction) {
        return gameAction == 8 && keyCode != 53;
    }

    public final boolean isSoftKeyLeft(int keyCode, int gameAction) {
        if (gameAction == 2 || gameAction == 5 || gameAction == 1 || gameAction == 6) {
            return false;
        }
        return Display.getInstance().isSoftKeyLeft(keyCode, gameAction);
    }

    public final boolean isSoftKeyRight(int keyCode, int gameAction) {
        if (gameAction == 2 || gameAction == 5 || gameAction == 1 || gameAction == 6) {
            return false;
        }
        return Display.getInstance().isSoftKeyRight(keyCode, gameAction);
    }

    public final boolean isSoftKeyMiddle(int keyCode, int gameAction) {
        if (gameAction == 2 || gameAction == 5 || gameAction == 1 || gameAction == 6) {
            return false;
        }
        return Display.getInstance().isSoftKeyMiddle(keyCode, gameAction);
    }

    public boolean isSoftKey(int keyCode) {
        return Display.getInstance().isSoftKey(keyCode);
    }

    public boolean isSoftKey(int keyCode, int gameAction) {
        return Display.getInstance().isSoftKey(keyCode, gameAction);
    }

    protected void notifyFocusSet(Item item) {
    }

    protected boolean isNativeUiShownFor(Item item) {
        return Display.getInstance().isNativeUiShownFor(item);
    }

    public void addPermanentNativeItem(Item item) {
    }

    public void removePermanentNativeItem(Item item) {
    }

    public void addRepaintArea(ClippingRegion repaintArea) {
        repaintArea.addRegion(0, 0, this.screenWidth, this.getScreenFullHeight());
    }

    public void addRelativeToContentRegion(ClippingRegion repaintRegion, int x, int y, int width, int height) {
        repaintRegion.addRegion(this.contentX + x, this.contentY + y, width, height);
    }

    public Style getStyle() {
        return this.style;
    }

    public void fireEvent(String eventName, Object eventData) {
        EventManager.fireEvent(eventName, this, eventData);
        this.scrollBar.fireEvent(eventName, eventData);
        this.menuBar.fireEvent(eventName, eventData);
        if (this.container != null) {
            this.container.fireEvent(eventName, eventData);
        }
        if (this.title != null) {
            this.title.fireEvent(eventName, eventData);
        }
        if (ScreenInfo.item != null && ScreenInfo.isVisible()) {
            ScreenInfo.item.fireEvent(eventName, eventData);
        }
    }

    public void fireEventForTitleAndMenubar(String eventName, Object eventData) {
        UiAccess.fireEvent(eventName, this.menuBar, eventData);
        if (this.title != null) {
            UiAccess.fireEvent(eventName, this.title, eventData);
        }
    }

    public Object getPaintLock() {
        return this.paintLock;
    }

    public Container getRootContainer() {
        return this.container;
    }

    public void setRootContainer(Container cont) {
        if (cont != null) {
            cont.screen = this;
            cont.isFocused = true;
        }
        this.container = cont;
        if (this.isInitialized) {
            this.requestInit();
        }
    }

    public int getTitleHeight() {
        return this.titleHeight;
    }

    public void setLastInteractionTime(long currentTimeMillis) {
        this.lastInteractionTime = currentTimeMillis;
    }

    public void setUiEventListener(UiEventListener listener) {
        this.uiEventListener = listener;
    }

    public UiEventListener getUiEventListener() {
        return this.uiEventListener;
    }

    public Item getSubTitleItem() {
        return this.subTitle;
    }

    public void setScreenInitializerListener(ScreenInitializerListener listener) {
        this.screenInitializerListener = listener;
    }

    public ScreenInitializerListener getScreenInitializerListener() {
        return this.screenInitializerListener;
    }

    public void addCommandSeparator(int priority) {
        this.addCommandSeparator(priority, null);
    }

    public void addCommandSeparator(int priority, Style separatorStyle) {
        this.addCommand(new Command(null, 100, priority, separatorStyle));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.style != null) {
            buffer.append(this.style.name).append(": ");
        } else {
            buffer.append("<no style>: ");
        }
        buffer.append(super.toString());
        return buffer.toString();
    }

    class ForwardCommandListener
    implements CommandListener {
        public CommandListener realCommandListener;

        ForwardCommandListener() {
        }

        public void commandAction(Command cmd, Displayable thisScreen) {
            Screen.this.handleCommand(cmd);
        }
    }
}

