/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Animatable;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.util.RgbImage;
import javax.microedition.lcdui.Graphics;

public abstract class ItemTransition
implements Animatable {
    protected Item oldItem;
    protected Item newItem;
    protected int oldX;
    protected int oldY;
    protected int oldWidth;
    protected int oldHeight;
    protected int newX;
    protected int newY;
    protected int newWidth;
    protected int newHeight;
    protected int largeX;
    protected int largeY;
    protected int largeWidth;
    protected int largeHeight;
    protected boolean usesOldRgbData;
    protected RgbImage oldRgbImage;
    protected boolean usesNewRgbData;
    protected RgbImage newRgbImage;

    public void init(Item oldItm, Item newItm) {
        this.oldItem = oldItm;
        this.oldX = oldItm.getAbsoluteX();
        this.oldY = oldItm.getAbsoluteY();
        this.oldWidth = oldItm.itemWidth;
        this.oldHeight = oldItm.itemHeight;
        this.newItem = newItm;
        this.newX = newItm.getAbsoluteX();
        this.newY = newItm.getAbsoluteY();
        this.newWidth = newItm.itemWidth;
        this.newHeight = newItm.itemHeight;
        this.largeX = Math.min(this.oldX, this.newX);
        this.largeY = Math.min(this.oldY, this.newY);
        this.largeWidth = Math.max(this.oldX + this.oldWidth, this.newX + this.newWidth) - this.largeX;
        this.largeHeight = Math.max(this.oldY + this.oldHeight, this.newY + this.newHeight) - this.largeY;
    }

    public void addRelativeToLargerItemRegion(ClippingRegion repaintRegion, int x, int y, int width, int height) {
        repaintRegion.addRegion(this.largeX + x, this.largeY + y, width, height);
    }

    public void setStyle(Style style) {
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
    }

    public abstract void paint(int var1, int var2, int var3, int var4, Graphics var5);

    public abstract boolean isFinished();
}

