/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageItem
extends Item {
    protected Image image;
    protected String altText;
    protected int textColor;
    protected Font font;
    protected int xOffset;
    protected int xOverlap;
    protected int imageWidth;
    protected int imageHeight;

    public ImageItem(String label, Image image, int layout, String altText) {
        this(label, image, layout, altText, 0, null);
    }

    public ImageItem(String label, Image image, int layout, String altText, Style style) {
        this(label, image, layout, altText, 0, style);
    }

    public ImageItem(String label, Image image, int layout, String altText, int appearanceMode) {
        this(label, image, layout, altText, appearanceMode, null);
    }

    public ImageItem(String label, Image image, int layout, String altText, int appearanceMode, Style style) {
        super(label, layout, appearanceMode, style);
        this.image = image;
        this.altText = altText;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.xOffset = 0;
        if (image != null && (this.imageWidth != image.getWidth() || this.imageHeight != image.getHeight())) {
            this.requestInit();
        } else if (this.isShown) {
            this.repaint();
        }
        this.notifyValueChanged(image);
    }

    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String text) {
        this.altText = text;
        if (this.image == null) {
            this.setInitialized(false);
            this.repaint();
        }
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (this.image != null) {
            int clipX = 0;
            int clipY = 0;
            int clipWidth = 0;
            int clipHeight = 0;
            if (this.xOverlap != 0) {
                clipX = g.getClipX();
                clipY = g.getClipY();
                clipWidth = g.getClipWidth();
                clipHeight = g.getClipHeight();
                g.clipRect(x, clipY, this.contentWidth, clipHeight);
            }
            x += this.xOffset;
            if (this.isLayoutExpand) {
                if (this.isLayoutCenter) {
                    this.drawImage(this.image, x, y, 20, g);
                } else if (this.isLayoutRight) {
                    this.drawImage(this.image, rightBorder, y, 24, g);
                } else {
                    this.drawImage(this.image, x, y, 20, g);
                }
            } else {
                this.drawImage(this.image, x, y, 20, g);
            }
            if (this.xOverlap != 0) {
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
        } else if (this.altText != null) {
            g.setColor(this.textColor);
            g.setFont(this.font);
            g.drawString(this.altText, x, y, 20);
        }
    }

    public void drawImage(Image image, int x, int y, int anchor, Graphics g) {
        g.drawImage(this.image, x, y, 20);
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        this.xOverlap = 0;
        Image img = this.image;
        if (img != null) {
            int imgWidth = img.getWidth();
            int imgHeight = img.getHeight();
            this.imageWidth = imgWidth;
            this.imageHeight = imgHeight;
            this.contentHeight = img.getHeight();
            this.contentWidth = img.getWidth();
            if (this.contentWidth > availWidth) {
                this.xOverlap = this.contentWidth - availWidth;
                this.contentWidth = availWidth;
                this.appearanceMode = 3;
            }
        } else if (this.altText != null) {
            if (this.font == null) {
                this.font = Font.getDefaultFont();
            }
            this.contentHeight = this.font.getHeight();
            this.contentWidth = this.font.stringWidth(this.altText);
        } else {
            this.contentHeight = 0;
            this.contentWidth = 0;
        }
    }

    protected String createCssSelector() {
        return "img";
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
        if (resetStyle) {
            this.textColor = style.getFontColor();
            this.font = style.getFont();
        }
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (this.xOverlap != 0) {
            if (gameAction == 5 && keyCode != 54 && this.xOffset + this.xOverlap > 0) {
                int offset = this.xOffset - 10;
                if (offset + this.xOverlap < 0) {
                    offset = -this.xOverlap;
                }
                this.xOffset = offset;
                return true;
            }
            if (gameAction == 2 && keyCode != 52 && this.xOffset < 0) {
                int offset = this.xOffset + 10;
                if (offset > 0) {
                    offset = 0;
                }
                this.xOffset = offset;
                return true;
            }
        }
        return super.handleKeyPressed(keyCode, gameAction);
    }

    protected boolean handlePointerPressed(int relX, int relY) {
        if (this.xOverlap != 0 && this.isInItemArea(relX, relY)) {
            int offset = this.xOffset + ((this.contentWidth >> 1) - relX);
            if (offset + this.xOverlap < 0) {
                offset = -this.xOverlap;
            } else if (offset > 0) {
                offset = 0;
            }
            if (offset != this.xOffset) {
                this.xOffset = offset;
                return true;
            }
        }
        return super.handlePointerPressed(relX, relY);
    }

    public int[] getRgbData(boolean supportTranslucency, int rgbOpacity) {
        if (!(this.background != null || this.border != null || this.itemWidth != this.imageWidth && this.itemWidth != this.imageWidth + 2 || this.itemHeight != this.imageHeight && this.itemHeight != this.imageHeight + 2)) {
            int[] rgbImageData = new int[this.itemWidth * this.itemHeight];
            int offset = 0;
            if (this.itemWidth > this.imageWidth) {
                offset = 1;
            }
            if (this.itemHeight > this.imageHeight) {
                offset += this.itemWidth;
            }
            this.image.getRGB(rgbImageData, offset, this.itemWidth, 0, 0, this.imageWidth, this.imageHeight);
            return rgbImageData;
        }
        return super.getRgbData(supportTranslucency, rgbOpacity);
    }
}

