/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.RgbFilter;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class IconItem
extends StringItem {
    protected Image image;
    protected int imageAlign = 4;
    protected int imageHeight;
    protected int imageWidth;
    protected int yAdjustText;
    protected boolean isTextVisible = true;
    protected int relativeIconX;
    protected int relativeIconY;
    private RgbFilter[] iconFilters;
    private Image imageHover;
    private Image imageNormal;

    public IconItem(String text, Image image) {
        this(null, text, image, null);
    }

    public IconItem(String text, Image image, Style style) {
        this(null, text, image, style);
    }

    public IconItem(String label, String text, Image image) {
        this(label, text, image, null);
    }

    public IconItem(String label, String text, Image image, Style style) {
        super(label, text, 3, style);
        if (image != null) {
            this.setImage(image);
        }
    }

    protected String createCssSelector() {
        return "icon";
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        boolean hasText;
        if (this.image == null) {
            if (this.isTextVisible) {
                super.initContent(firstLineWidth, availWidth, availHeight);
                this.yAdjustText = 0;
            } else {
                this.contentWidth = 0;
                this.contentHeight = 0;
            }
            return;
        }
        int imgWidth = this.image.getWidth();
        int imgHeight = this.image.getHeight();
        this.imageWidth = imgWidth;
        this.imageHeight = imgHeight;
        int yAdjustImage = 0;
        boolean bl = hasText = this.getText() != null;
        if (this.imageAlign == 4 || this.imageAlign == 8) {
            int verticalAlign;
            if (this.isTextVisible && hasText) {
                this.imageWidth = imgWidth += this.paddingHorizontal;
                firstLineWidth -= imgWidth;
                if ((availWidth -= imgWidth) <= 0) {
                    availWidth += imgWidth;
                }
                super.initContent(firstLineWidth, availWidth, availHeight);
            } else {
                this.contentWidth = 0;
                this.contentHeight = imgHeight;
            }
            if (imgHeight > this.contentHeight) {
                verticalAlign = this.layout & 0x30;
                this.yAdjustText = verticalAlign == 48 || verticalAlign == 0 ? (imgHeight - this.contentHeight) / 2 : (verticalAlign == 32 ? imgHeight - this.contentHeight : 0);
                this.contentHeight = imgHeight;
            } else if (this.contentHeight > imgHeight) {
                this.yAdjustText = 0;
                verticalAlign = this.layout & 0x30;
                if (verticalAlign == 48 || verticalAlign == 0) {
                    yAdjustImage = (this.contentHeight - imgHeight) / 2;
                } else if (verticalAlign == 32) {
                    yAdjustImage = this.contentHeight - imgHeight;
                }
            } else {
                this.yAdjustText = 0;
            }
            if (this.isLayoutExpand && hasText) {
                this.contentWidth = firstLineWidth;
            }
            this.contentWidth += imgWidth;
        } else {
            if (this.isTextVisible && hasText) {
                this.imageHeight = imgHeight += this.paddingVertical;
                super.initContent(firstLineWidth, availWidth, availHeight);
            } else {
                this.contentHeight = 0;
                this.contentWidth = 0;
            }
            this.contentHeight += imgHeight;
            if (imgWidth > this.contentWidth) {
                this.contentWidth = imgWidth;
            }
        }
        int iconLeftX = 0;
        int iconTopY = yAdjustImage;
        if (hasText && this.imageAlign == 8) {
            iconLeftX = this.contentWidth - imgWidth + this.paddingHorizontal;
        } else if (hasText && this.imageAlign == 4) {
            iconLeftX = 0;
        } else {
            iconLeftX = this.contentWidth - imgWidth >> 1;
            if (this.imageAlign == 32) {
                iconTopY += this.contentHeight - imgHeight;
            }
        }
        this.relativeIconX = iconLeftX;
        this.relativeIconY = iconTopY;
    }

    protected void setContentWidth(int width) {
        if (this.imageAlign == 16 || this.imageAlign == 32 || this.text == null) {
            int diff = width - this.contentWidth;
            this.relativeIconX += diff / 2;
        } else if (this.imageAlign == 8) {
            this.relativeIconX = width - this.imageWidth;
        }
        super.setContentWidth(width);
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (this.image != null) {
            g.drawImage(this.image, x + this.relativeIconX, y + this.relativeIconY, 20);
            if (this.imageAlign == 4) {
                x += this.imageWidth;
                leftBorder += this.imageWidth;
                y += this.yAdjustText;
            } else if (this.imageAlign == 8) {
                rightBorder -= this.imageWidth;
                y += this.yAdjustText;
            } else if (this.imageAlign == 16) {
                y += this.imageHeight;
            }
        }
        if (this.isTextVisible) {
            super.paintContent(x, y, leftBorder, rightBorder, g);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setStyle(Style style) {
        Integer align = style.getIntProperty(7);
        if (align != null) {
            switch (align) {
                case 0: {
                    this.imageAlign = 4;
                    break;
                }
                case 1: {
                    this.imageAlign = 8;
                    break;
                }
                case 2: {
                    this.imageAlign = 16;
                    break;
                }
                case 3: {
                    this.imageAlign = 32;
                    break;
                }
                case 4: {
                    this.imageAlign = 3;
                }
            }
        }
        String imageName = style.getProperty(6);
        if (imageName != null) {
            Item item = this;
            Item container = this.parent;
            while (container != null && !(container instanceof Container) && container.parent != null) {
                item = container;
                container = container.parent;
            }
            if (container instanceof Container) {
                imageName = ((Container)container).parseIndexUrl(imageName, item);
            } else if (imageName.indexOf("%INDEX%") != -1) {
                throw new IllegalStateException("IconItem cannot resolve %INDEX% in url since parent is not a container: " + container + ", parent=" + this.parent);
            }
            try {
                Image img = StyleSheet.getImage(imageName, this, true);
                if (img != null) {
                    this.image = img;
                }
            }
            catch (IOException e) {
                Debug.debug("error", "de.enough.polish.ui.IconItem", 441, (Object)("unable to load image [" + imageName + "]"), e);
            }
        }
        super.setStyle(style);
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
    }

    public void setImage(String url) {
        try {
            Image img = StyleSheet.getImage(url, this, false);
            if (img != null) {
                this.setImage(img);
            }
        }
        catch (IOException e) {
            Debug.debug("error", "de.enough.polish.ui.IconItem", 563, (Object)("unable to load image [" + url + "]"), e);
        }
    }

    public void setImage(Image image) {
        this.setImage(image, null);
    }

    public void setImage(Image img, Style style) {
        if (img == this.image && (style == null || style == this.style)) {
            return;
        }
        if (style != null) {
            this.setStyle(style);
        }
        this.image = img;
        if (this.isInitialized() && img != null && (style != null || this.imageWidth != img.getWidth() || this.imageHeight != img.getHeight())) {
            this.requestInit();
        } else if (this.isShown) {
            this.repaint();
        }
    }

    public void setHoverImage(Image img) {
        this.imageHover = img;
        if (this.isFocused && img != null) {
            this.imageNormal = this.image;
            this.setImage(img, null);
        }
    }

    public void setImageAlign(int imageAlign) {
        this.imageAlign = imageAlign;
        this.setInitialized(false);
    }

    protected void defocus(Style originalStyle) {
        if (this.imageNormal != null) {
            this.setImage(this.imageNormal);
        }
        super.defocus(originalStyle);
    }

    protected Style focus(Style newStyle, int direction) {
        if (this.imageHover != null && this.image != this.imageHover) {
            this.imageNormal = this.image;
            this.setImage(this.imageHover);
        }
        return super.focus(newStyle, direction);
    }

    public void releaseResources() {
        super.releaseResources();
    }

    public boolean isTextVisible() {
        return this.isTextVisible;
    }

    public void setTextVisible(boolean isTextVisible) {
        this.isTextVisible = isTextVisible;
        if (!isTextVisible) {
            this.textLines.clear();
        }
        this.isTextInitializationRequired = true;
        this.setInitialized(false);
    }

    public int[] getRgbData(boolean supportTranslucency, int rgbOpacity) {
        if (!(this.background != null || this.border != null || this.itemWidth != this.imageWidth && this.itemWidth != this.imageWidth + 2 || this.itemHeight != this.imageHeight && this.itemHeight != this.imageHeight + 2 || this.image == null)) {
            int[] rgbImageData = new int[this.itemWidth * this.itemHeight];
            int offset = 0;
            if (this.itemWidth > this.imageWidth) {
                offset = 1;
            }
            if (this.itemHeight > this.imageHeight) {
                offset += this.itemWidth;
            }
            this.image.getRGB(rgbImageData, offset, this.itemWidth, 0, 0, this.imageWidth, this.imageHeight);
            return rgbImageData;
        }
        return super.getRgbData(supportTranslucency, rgbOpacity);
    }
}

