/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Font;
import de.enough.polish.ui.Image;
import de.enough.polish.util.DeviceInfo;
import de.enough.polish.util.ImageUtil;
import de.enough.polish.util.RgbImage;

public class Graphics {
    protected javax.microedition.lcdui.Graphics graphics = null;
    protected RgbImage bufferedImage = null;
    private Font currentFont;
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    public static final int SOLID = 0;
    public static final int DOTTED = 1;
    static int COLOR_BIT_MASK = 255;
    public static byte[][] FILTER_GAUSSIAN_2 = new byte[][]{{1, 2, 1}, {2, 4, 2}, {1, 2, 1}};
    public static byte[][] FILTER_GAUSSIAN_3 = new byte[][]{{0, 1, 2, 1, 0}, {1, 3, 5, 3, 1}, {2, 5, 9, 5, 2}, {1, 3, 5, 3, 1}, {0, 1, 2, 1, 0}};

    public Graphics(javax.microedition.lcdui.Graphics g) {
        this.graphics = g;
    }

    public void clipRect(int x, int y, int width, int height) {
        this.graphics.clipRect(x, y, width, height);
    }

    public void copyArea(int x_src, int y_src, int width, int height, int x_dest, int y_dest, int anchor) {
        this.graphics.copyArea(x_src, y_src, width, height, x_dest, y_dest, anchor);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.graphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawChar(char character, int x, int y, int anchor) {
        this.graphics.drawChar(character, x, y, anchor);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y, int anchor) {
        this.graphics.drawChars(data, offset, length, x, y, anchor);
    }

    public void drawImage(Image img, int x, int y, int anchor) {
        this.graphics.drawImage(img.image, x, y, anchor);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine(x1, y1, x2, y2);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.graphics.drawRect(x, y, width, height);
    }

    public void drawRegion(Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        this.graphics.drawRegion(src.image, x_src, y_src, width, height, transform, x_dest, y_dest, anchor);
    }

    public void drawRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height, boolean processAlpha) {
        this.graphics.drawRGB(rgbData, offset, scanlength, x, y, width, height, processAlpha);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void drawString(String str, int x, int y, int anchor) {
        this.graphics.drawString(str, x, y, anchor);
    }

    public void drawSubstring(String str, int offset, int len, int x, int y, int anchor) {
        this.graphics.drawSubstring(str, offset, len, x, y, anchor);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.graphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.graphics.fillRect(x, y, width, height);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.graphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public int getBlueComponent() {
        return this.graphics.getBlueComponent();
    }

    public int getClipHeight() {
        return this.graphics.getClipHeight();
    }

    public int getClipWidth() {
        return this.graphics.getClipWidth();
    }

    public int getClipX() {
        return this.graphics.getClipX();
    }

    public int getClipY() {
        return this.graphics.getClipY();
    }

    public int getColor() {
        return this.graphics.getColor();
    }

    public int getDisplayColor(int color2) {
        return this.graphics.getDisplayColor(color2);
    }

    public Font getFont() {
        return this.currentFont;
    }

    public int getGrayScale() {
        return this.graphics.getGrayScale();
    }

    public int getGreenComponent() {
        return this.graphics.getGreenComponent();
    }

    public int getRedComponent() {
        return this.graphics.getRedComponent();
    }

    public int getStrokeStyle() {
        return this.graphics.getStrokeStyle();
    }

    public int getTranslateX() {
        return this.graphics.getTranslateX();
    }

    public int getTranslateY() {
        return this.graphics.getTranslateY();
    }

    public void setClip(int x, int y, int width, int height) {
        this.graphics.setClip(x, y, width, height);
    }

    public void setColor(int RGB) {
        this.graphics.setColor(RGB);
    }

    public void setColor(int red, int green, int blue) {
        this.graphics.setColor(red, green, blue);
    }

    public void setFont(Font font) {
        this.currentFont = font;
        this.graphics.setFont(font.font);
    }

    public void setGrayscale(int gray) {
        this.graphics.setGrayScale(gray);
    }

    public void setStrokeStyle(int style) {
        this.graphics.setStrokeStyle(style);
    }

    public void translate(int x, int y) {
        this.graphics.translate(x, y);
    }

    public void drawTranslucentLine(int color2, int x1, int y1, int x2, int y2) {
        if (y2 < y1) {
            int top = y2;
            y2 = y1;
            y1 = top;
        }
        if (x2 < x1) {
            int left = x2;
            x2 = x1 = x2;
            x1 = left;
        }
        if (x1 == x2 || y1 == y2) {
            int height;
            int width = x2 - x1;
            if (width == 0) {
                width = 1;
            }
            if ((height = y2 - y1) == 0) {
                height = 1;
            }
            int[] rgb = new int[Math.max(width, height)];
            for (int i = 0; i < rgb.length; ++i) {
                rgb[i] = color2;
            }
            this.graphics.drawRGB(rgb, 0, width, x1, y1, width, height, true);
        } else {
            this.graphics.setColor(color2);
            this.graphics.drawLine(x1, y1, x2, y2);
        }
    }

    public void drawRgb(int[] rgb, int x, int y, int width, int height, boolean processAlpha) {
        this.drawRgb(rgb, x, y, width, height, processAlpha, this.graphics.getClipX(), this.graphics.getClipY(), this.graphics.getClipWidth(), this.graphics.getClipHeight());
    }

    public void drawRgb(int[] rgb, int x, int y, int width, int height, boolean processAlpha, int clipX, int clipY, int clipWidth, int clipHeight) {
        if (x + width < clipX || x > clipX + clipWidth || y + height < clipY || y > clipY + clipHeight) {
            return;
        }
        int offset = 0;
        if (x < clipX) {
            offset = clipX - x;
            x = clipX;
        }
        int scanlength = width;
        if (x + (width -= offset) > clipX + clipWidth) {
            width = clipX + clipWidth - x;
        }
        if (width <= 0) {
            return;
        }
        if (y < clipY) {
            offset += (clipY - y) * scanlength;
            height -= clipY - y;
            y = clipY;
        }
        if (y + height > clipY + clipHeight) {
            height = clipY + clipHeight - y;
        }
        if (height <= 0) {
            return;
        }
        this.graphics.drawRGB(rgb, offset, scanlength, x, y, width, height, processAlpha);
    }

    public void drawRgb(RgbImage image, int x, int y) {
        this.drawRgb(image.getRgbData(), x, y, image.getWidth(), image.getHeight(), image.isProcessTransparency(), this.graphics.getClipX(), this.graphics.getClipY(), this.graphics.getClipWidth(), this.graphics.getClipHeight());
    }

    public void fillRect(int x, int y, int width, int height, int color2) {
        int i;
        if ((color2 & 0xFF000000) == 0) {
            this.graphics.setColor(color2);
            this.graphics.fillRect(x, y, width, height);
            return;
        }
        int[] buffer = null;
        if (DeviceInfo.requiresFullRgbArrayForDrawRgb()) {
            buffer = new int[width * height];
            for (i = buffer.length - 1; i >= 0; --i) {
                buffer[i] = color2;
            }
        }
        if (buffer == null) {
            buffer = new int[width];
            for (i = buffer.length - 1; i >= 0; --i) {
                buffer[i] = color2;
            }
        }
        if (DeviceInfo.requiresFullRgbArrayForDrawRgb()) {
            this.drawRgb(buffer, x, y, width, height, true);
            return;
        }
        if (x < 0) {
            width += x;
            x = 0;
        }
        if (width <= 0) {
            return;
        }
        if (y < 0) {
            height += y;
            y = 0;
        }
        if (height <= 0) {
            return;
        }
        this.graphics.drawRGB(buffer, 0, 0, x, y, width, height, true);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int color2) {
        int length = xPoints.length - 1;
        this.graphics.setColor(color2);
        for (int i = 0; i < length; ++i) {
            this.graphics.drawLine(xPoints[i], yPoints[i], xPoints[i + 1], yPoints[i + 1]);
        }
        this.graphics.drawLine(xPoints[length], yPoints[length], xPoints[0], yPoints[0]);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int color2) {
        while (xPoints.length > 2) {
            int a = Graphics.indexOfLeast(xPoints);
            int b = (a + 1) % xPoints.length;
            int c = a > 0 ? a - 1 : xPoints.length - 1;
            int leastInternalIndex = -1;
            boolean leastInternalSet = false;
            if (xPoints.length > 3) {
                for (int i = 0; i < xPoints.length; ++i) {
                    if (i == a || i == b || i == c || !Graphics.withinBounds(xPoints[i], yPoints[i], xPoints[a], yPoints[a], xPoints[b], yPoints[b], xPoints[c], yPoints[c]) || leastInternalSet && xPoints[i] >= xPoints[leastInternalIndex]) continue;
                    leastInternalIndex = i;
                    leastInternalSet = true;
                }
            }
            if (!leastInternalSet) {
                this.graphics.setColor(color2);
                this.graphics.fillTriangle(xPoints[a], yPoints[a], xPoints[b], yPoints[b], xPoints[c], yPoints[c]);
                int[][] trimmed = Graphics.trimEar(xPoints, yPoints, a);
                xPoints = trimmed[0];
                yPoints = trimmed[1];
                continue;
            }
            int[][][] split = Graphics.split(xPoints, yPoints, a, leastInternalIndex);
            int[][] poly1 = split[0];
            int[][] poly2 = split[1];
            this.fillPolygon(poly1[0], poly1[1], color2);
            this.fillPolygon(poly2[0], poly2[1], color2);
            break;
        }
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.graphics.fillTriangle(x1, y1, x2, y2, x3, y3);
    }

    public static int getCenter(int n1, int n2, int n3) {
        int max = Math.max(n1, Math.max(n2, n3));
        int min = Math.min(n1, Math.min(n2, n3));
        return min + (max - min) / 2;
    }

    public void drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.graphics.drawLine(x1, y1, x2, y2);
        this.graphics.drawLine(x2, y2, x3, y3);
        this.graphics.drawLine(x3, y3, x1, y1);
    }

    static int indexOfLeast(int[] elements) {
        int index = 0;
        int least = elements[0];
        for (int i = 1; i < elements.length; ++i) {
            if (elements[i] >= least) continue;
            index = i;
            least = elements[i];
        }
        return index;
    }

    private static boolean withinBounds(int px, int py, int ax, int ay, int bx, int by, int cx, int cy) {
        if (px < Math.min(ax, Math.min(bx, cx)) || px > Math.max(ax, Math.max(bx, cx)) || py < Math.min(ay, Math.min(by, cy)) || py > Math.max(ay, Math.max(by, cy))) {
            return false;
        }
        boolean sameabc = Graphics.sameSide(px, py, ax, ay, bx, by, cx, cy);
        boolean samebac = Graphics.sameSide(px, py, bx, by, ax, ay, cx, cy);
        boolean samecab = Graphics.sameSide(px, py, cx, cy, ax, ay, bx, by);
        return sameabc && samebac && samecab;
    }

    private static boolean sameSide(int p1x, int p1y, int p2x, int p2y, int l1x, int l1y, int l2x, int l2y) {
        long lhs = (p1x - l1x) * (l2y - l1y) - (l2x - l1x) * (p1y - l1y);
        long rhs = (p2x - l1x) * (l2y - l1y) - (l2x - l1x) * (p2y - l1y);
        long product = lhs * rhs;
        boolean result = product >= 0L;
        return result;
    }

    private static int[][] trimEar(int[] xPoints, int[] yPoints, int earIndex) {
        int[] newXPoints = new int[xPoints.length - 1];
        int[] newYPoints = new int[yPoints.length - 1];
        int[][] newPoly = new int[][]{newXPoints, newYPoints};
        int p = 0;
        for (int i = 0; i < xPoints.length; ++i) {
            if (i == earIndex) continue;
            newXPoints[p] = xPoints[i];
            newYPoints[p] = yPoints[i];
            ++p;
        }
        return newPoly;
    }

    private static int[][][] split(int[] xPoints, int[] yPoints, int aIndex, int bIndex) {
        int index;
        int i;
        int firstLen = bIndex < aIndex ? xPoints.length - aIndex + bIndex + 1 : bIndex - aIndex + 1;
        int secondLen = xPoints.length - firstLen + 2;
        int[][] first = new int[2][firstLen];
        int[][] second = new int[2][secondLen];
        for (i = 0; i < firstLen; ++i) {
            index = (aIndex + i) % xPoints.length;
            first[0][i] = xPoints[index];
            first[1][i] = yPoints[index];
        }
        for (i = 0; i < secondLen; ++i) {
            index = (bIndex + i) % xPoints.length;
            second[0][i] = xPoints[index];
            second[1][i] = yPoints[index];
        }
        int[][][] result = new int[][][]{first, second};
        return result;
    }

    public static final int[] getGradient(int startColor, int endColor, int steps) {
        if (steps <= 0) {
            return new int[0];
        }
        int[] gradient = new int[steps];
        Graphics.getGradient(startColor, endColor, gradient);
        return gradient;
    }

    public static final void getGradient(int startColor, int endColor, int[] gradient) {
        int steps = gradient.length;
        if (steps == 0) {
            return;
        }
        if (steps == 1) {
            gradient[0] = startColor;
            return;
        }
        int startAlpha = startColor >>> 24;
        int startRed = startColor >>> 16 & 0xFF;
        int startGreen = startColor >>> 8 & 0xFF;
        int startBlue = startColor & 0xFF;
        int endAlpha = endColor >>> 24;
        int endRed = endColor >>> 16 & 0xFF;
        int endGreen = endColor >>> 8 & 0xFF;
        int endBlue = endColor & 0xFF;
        int stepAlpha = (endAlpha - startAlpha << 8) / (steps - 1);
        int stepRed = (endRed - startRed << 8) / (steps - 1);
        int stepGreen = (endGreen - startGreen << 8) / (steps - 1);
        int stepBlue = (endBlue - startBlue << 8) / (steps - 1);
        startAlpha <<= 8;
        startRed <<= 8;
        startGreen <<= 8;
        startBlue <<= 8;
        gradient[0] = startColor;
        for (int i = 1; i < steps; ++i) {
            gradient[i] = (startAlpha += stepAlpha) << 16 & 0xFF000000 | (startRed += stepRed) << 8 & 0xFF0000 | (startGreen += stepGreen) & 0xFF00 | (startBlue += stepBlue) >>> 8;
        }
    }

    public static final int getGradientColor(int startColor, int endColor, int permille) {
        int alpha = startColor >>> 24;
        int red = startColor >>> 16 & 0xFF;
        int green = startColor >>> 8 & 0xFF;
        int blue = startColor & 0xFF;
        int diffAlpha = (endColor >>> 24) - alpha;
        int diffRed = (endColor >>> 16 & 0xFF) - red;
        int diffGreen = (endColor >>> 8 & 0xFF) - green;
        int diffBlue = (endColor & 0xFF) - blue;
        return (alpha += diffAlpha * permille / 1000) << 24 | (red += diffRed * permille / 1000) << 16 | (green += diffGreen * permille / 1000) << 8 | (blue += diffBlue * permille / 1000);
    }

    public static final int getGradientColor(int startColor, int endColor, int step, int numberOfSteps) {
        int permille = step * 1000 / numberOfSteps;
        return Graphics.getGradientColor(startColor, endColor, permille);
    }

    public static int getComplementaryColor(int color2) {
        return 0xFF000000 & color2 | 255 - ((0xFF0000 & color2) >> 16) << 16 | 255 - ((0xFF00 & color2) >> 8) << 8 | 255 - (0xFF & color2);
    }

    public static final void dropShadow(int[] argbData, int width, int height, int xOffset, int yOffset, int size, int innerColor, int outerColor) {
        int iLeft = size - xOffset < 0 ? 0 : size - xOffset;
        int iRight = size + xOffset < 0 ? 0 : size + xOffset;
        int iTop = size - yOffset < 0 ? 0 : size - yOffset;
        int iBottom = size + yOffset < 0 ? 0 : size + yOffset;
        int[] gradient = Graphics.getGradient(innerColor, outerColor, size);
        for (int ix = -size + 1; ix < size; ++ix) {
            for (int iy = -size + 1; iy < size; ++iy) {
                int r = (int)Math.sqrt(ix * ix + iy * iy);
                if (r >= size) continue;
                int gColor = gradient[r];
                for (int col = iLeft; col < width - iRight; ++col) {
                    for (int row = iTop; row < height - iBottom - 1; ++row) {
                        if (argbData[row * width + col] >>> 24 != 255 || argbData[(row + yOffset + iy) * width + col + xOffset + ix] >>> 24 >= gColor >>> 24) continue;
                        argbData[(row + yOffset + iy) * width + col + xOffset + ix] = gColor;
                    }
                }
            }
        }
    }

    public static final void applyFilter(byte[][] filterMatrix, int brightness, int[] argbData, int width, int height) {
        if (filterMatrix.length % 2 != 1 || filterMatrix[0].length % 2 != 1) {
            throw new IllegalArgumentException();
        }
        int fhRadius = filterMatrix.length / 2 + 1;
        int fwRadius = filterMatrix[0].length / 2 + 1;
        int currentPixel = 0;
        int divisor = 0;
        for (int fRow = 0; fRow < filterMatrix.length; ++fRow) {
            for (int fCol = 0; fCol < filterMatrix[0].length; ++fCol) {
                divisor += filterMatrix[fRow][fCol];
            }
        }
        if (divisor == 0) {
            return;
        }
        int[] tmpRect = new int[width * filterMatrix.length];
        System.arraycopy(argbData, 0, tmpRect, 0, width * filterMatrix.length);
        int row = fhRadius - 1;
        while (row + fhRadius < height + 1) {
            int col = fwRadius - 1;
            while (col + fwRadius < width + 1) {
                int newTran = 0;
                int newRed = 0;
                int newGreen = 0;
                int newBlue = 0;
                for (int fRow = 0; fRow < filterMatrix.length; ++fRow) {
                    for (int fCol = 0; fCol < filterMatrix[0].length; ++fCol) {
                        currentPixel = tmpRect[fRow * width + col + fCol - fwRadius + 1];
                        if ((currentPixel >>> 24 & COLOR_BIT_MASK) == 0) continue;
                        newTran += filterMatrix[fRow][fCol] * (currentPixel >>> 24 & COLOR_BIT_MASK);
                        newRed += filterMatrix[fRow][fCol] * (currentPixel >>> 16 & COLOR_BIT_MASK);
                        newGreen += filterMatrix[fRow][fCol] * (currentPixel >>> 8 & COLOR_BIT_MASK);
                        newBlue += filterMatrix[fRow][fCol] * (currentPixel & COLOR_BIT_MASK);
                    }
                }
                newTran = newTran * brightness / 100 / divisor;
                newRed = newRed * brightness / 100 / divisor;
                newGreen = newGreen * brightness / 100 / divisor;
                newBlue = newBlue * brightness / 100 / divisor;
                newTran = Math.max(0, Math.min(255, newTran));
                newRed = Math.max(0, Math.min(255, newRed));
                newGreen = Math.max(0, Math.min(255, newGreen));
                newBlue = Math.max(0, Math.min(255, newBlue));
                argbData[row * width + col] = newTran << 24 | newRed << 16 | newGreen << 8 | newBlue;
                ++col;
            }
            if (row + fhRadius != height) {
                System.arraycopy(tmpRect, width, tmpRect, 0, width * (filterMatrix.length - 1));
                System.arraycopy(argbData, width * (row + fhRadius), tmpRect, width * (filterMatrix.length - 1), width);
            }
            ++row;
        }
    }

    public void drawAngledLine(int width, int length, int startX, int startY, int degrees) {
        this.drawAngledLine(width, length, 0, startX, startY, degrees);
    }

    public void drawAngledLine(int width, int length, int overlapLength, int targetX, int targetY, int degrees) {
        double lineCos = Math.cos(Math.PI * (double)degrees / 180.0);
        double lineSin = Math.sin(Math.PI * (double)degrees / 180.0);
        int mainLength = length - overlapLength;
        int x1 = (int)((double)targetX + (double)mainLength * lineCos);
        int y1 = (int)((double)targetY - (double)mainLength * lineSin);
        int x2 = (int)((double)targetX - (double)overlapLength * lineCos);
        int y2 = (int)((double)targetY + (double)overlapLength * lineSin);
        this.drawLine(width, x1, y1, x2, y2);
    }

    public void drawLine(int width, int x1, int y1, int x2, int y2) {
        if (width == 1) {
            this.graphics.drawLine(x1, y1, x2, y2);
            return;
        }
        double pointDistance = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        int startWidth = width / 2;
        int remainingWidth = width - startWidth;
        System.out.println(startWidth + " " + remainingWidth);
        double lineCos = (double)(x1 - x2) / pointDistance;
        double lineSin = (double)(y1 - y2) / pointDistance;
        double cosPerpendicularLine = -lineSin;
        double sinPerpendicularLine = lineCos;
        int tx1 = (int)((double)x1 + cosPerpendicularLine * (double)startWidth);
        int tx2 = (int)((double)x1 - cosPerpendicularLine * (double)remainingWidth);
        int tx3 = (int)((double)x2 - cosPerpendicularLine * (double)remainingWidth);
        int tx4 = (int)((double)x2 + cosPerpendicularLine * (double)startWidth);
        int ty1 = (int)((double)y1 + sinPerpendicularLine * (double)startWidth);
        int ty2 = (int)((double)y1 - sinPerpendicularLine * (double)remainingWidth);
        int ty3 = (int)((double)y2 - sinPerpendicularLine * (double)remainingWidth);
        int ty4 = (int)((double)y2 + sinPerpendicularLine * (double)startWidth);
        this.fillTriangle(tx1, ty1, tx2, ty2, tx3, ty3);
        this.fillTriangle(tx1, ty1, tx4, ty4, tx3, ty3);
    }

    public void drawArc(int thickness, int x, int y, int width, int height, int startAngle, int arcAngle) {
        int perimeter = (int)(Math.PI * ((double)(3 * (width + height)) - Math.sqrt((3 * width + height) * (width + 3 * height))));
        int noOfPoints = perimeter * Math.abs(arcAngle) / 360;
        System.out.println("PTS: " + noOfPoints);
        this.drawArc(thickness, x, y, width, height, startAngle, arcAngle, noOfPoints);
    }

    public void drawArc(int thickness, int x, int y, int width, int height, int startAngle, int arcAngle, int noOfVertices) {
        int endAngle = startAngle + arcAngle;
        if (endAngle < startAngle) {
            int temp = endAngle;
            endAngle = startAngle;
            startAngle = temp;
        }
        double startAngleRadians = Math.PI * (double)startAngle / 180.0;
        double endAngleRadians = Math.PI * (double)endAngle / 180.0;
        double angleStep = Math.PI * ((double)Math.abs(arcAngle) / (1.0 * (double)noOfVertices)) / 180.0;
        double bigWidth = (double)width / 2.0;
        double bigHeight = (double)height / 2.0;
        double smallWidth = (double)(width - thickness) / 2.0;
        double smallHeight = (double)(height - thickness) / 2.0;
        int centerX = x + width / 2;
        int centerY = y + height / 2;
        double theta = startAngleRadians;
        int x1 = (int)(Math.cos(theta) * bigWidth + (double)centerX);
        int y1 = (int)((double)centerY - Math.sin(theta) * bigHeight);
        int x2 = (int)(Math.cos(theta) * smallWidth + (double)centerX);
        int y2 = (int)((double)centerY - Math.sin(theta) * smallHeight);
        do {
            int x3 = (int)(Math.cos(theta += angleStep) * smallWidth + (double)centerX);
            int y3 = (int)((double)centerY - Math.sin(theta) * smallHeight);
            int x4 = (int)(Math.cos(theta) * bigWidth + (double)centerX);
            int y4 = (int)((double)centerY - Math.sin(theta) * bigHeight);
            this.fillTriangle(x1, y1, x2, y2, x3, y3);
            this.fillTriangle(x3, y3, x4, y4, x1, y1);
            x1 = x4;
            y1 = y4;
            x2 = x3;
            y2 = y3;
        } while (theta <= endAngleRadians);
    }

    public void drawRotatedImage(Image image, int imageCenterX, int imageCenterY, int targetCenterX, int targetCenterY, int degrees) {
        RgbImage img = new RgbImage(image.getRgbData(), image.getWidth());
        this.drawRotatedImage(img, imageCenterX, imageCenterY, targetCenterX, targetCenterY, degrees);
    }

    public void drawRotatedImage(RgbImage img, int imageCenterX, int imageCenterY, int targetCenterX, int targetCenterY, int degrees) {
        int originalWidth = img.getWidth();
        int originalHeight = img.getHeight();
        degrees = -(degrees - 90);
        ImageUtil.rotate(img, degrees);
        double degreeCos = Math.cos(Math.PI * (double)degrees / 180.0);
        double degreeSin = Math.sin(Math.PI * (double)degrees / 180.0);
        int centerXDelta = imageCenterX - originalWidth / 2;
        int centerYDelta = imageCenterY - originalHeight / 2;
        int newCenterX = (int)((double)centerXDelta * degreeCos - (double)centerYDelta * degreeSin);
        int newCenterY = (int)((double)centerXDelta * degreeSin + (double)centerYDelta * degreeCos);
        int posX = targetCenterX - img.getWidth() / 2;
        int posY = targetCenterY - img.getHeight() / 2;
        img.paint(posX - newCenterX, posY - newCenterY, this.graphics);
    }

    public static class FadeUtil {
        public static final int FADE_IN = 1;
        public static final int FADE_OUT = 2;
        public static final int FADE_LOOP = 3;
        public static final int FADE_BREAK = 0;
        public int[] gradient;
        public boolean changed;
        public int startColor = -16744193;
        public int endColor = -8323328;
        public int steps;
        public int delay = 0;
        public int stepsIn = 5;
        public int stepsOut = 5;
        public int sWaitTimeIn = 10;
        public int sWaitTimeOut = 0;
        public int mode = 3;
        public int cColor;
        public int cStep;

        private void initialize() {
            this.cStep = 0;
            switch (this.mode) {
                case 2: {
                    this.stepsIn = 0;
                    this.sWaitTimeIn = 0;
                    this.cColor = this.endColor;
                    break;
                }
                case 1: {
                    this.stepsOut = 0;
                    this.sWaitTimeOut = 0;
                    this.cColor = this.startColor;
                    break;
                }
                default: {
                    this.cColor = this.startColor;
                }
            }
            this.cStep -= this.delay;
            this.steps = this.stepsIn + this.stepsOut + this.sWaitTimeIn + this.sWaitTimeOut;
            this.gradient = Graphics.getGradient(this.startColor, this.endColor, Math.max(this.stepsIn, this.stepsOut));
        }

        public boolean step() {
            ++this.cStep;
            if (this.gradient == null | this.changed) {
                this.initialize();
            }
            this.changed = false;
            if (this.mode == 0) {
                return false;
            }
            if (this.cStep < 0) {
                return true;
            }
            if (this.cStep == this.steps) {
                this.cStep = 0;
                if (this.mode != 3) {
                    this.mode = 0;
                    return true;
                }
            }
            if (this.cStep < this.stepsIn) {
                this.cColor = this.gradient[this.cStep];
                return true;
            }
            if (this.cStep < this.stepsIn + this.sWaitTimeIn) {
                if (this.cColor != this.endColor) {
                    this.cColor = this.endColor;
                    return true;
                }
            } else {
                if (this.cStep < this.stepsIn + this.sWaitTimeIn + this.stepsOut) {
                    this.cColor = this.gradient[this.stepsIn + this.sWaitTimeIn + this.stepsOut - this.cStep - 1];
                    return true;
                }
                if (this.cColor != this.startColor) {
                    this.cColor = this.startColor;
                    return true;
                }
            }
            return false;
        }
    }
}

