/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.AnimationThread;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Color;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.backgrounds.SimpleBackground;
import de.enough.polish.ui.backgrounds.VerticalStripesBackground;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Gauge
extends Item {
    private static int ANIMATION_MODE_BACKANDFORTH = 1;
    public static final int INDEFINITE = -1;
    public static final int CONTINUOUS_IDLE = 0;
    public static final int INCREMENTAL_IDLE = 1;
    public static final int CONTINUOUS_RUNNING = 2;
    public static final int INCREMENTAL_UPDATING = 3;
    private static final int MODE_CONTINUOUS = 0;
    private static final int MODE_CHUNKED = 1;
    private static final int POSITION_LEFT = 0;
    private static final int POSITION_RIGHT = 1;
    private static final int POSITION_CENTER = 2;
    private int value;
    private String valueString;
    private int maxValue;
    private boolean isInteractive;
    private Color color = new Color(255);
    private int mode = 1;
    private Dimension chunkWidth = new Dimension(6);
    private Dimension gapWidth = new Dimension(3);
    private Color gapColor = new Color(0xFFFFFF);
    private Image image;
    private int imageYOffset;
    private boolean isIndefinite;
    private int indefinitePos;
    private boolean showValue = true;
    private int fontColor;
    private Font font;
    private int valueWidth;
    private int valuePosition = 0;
    private Background sliderBackground;
    private Background slider;
    private int indefinitePosMax;
    private boolean isDefaultChunkedSliderUsed;

    public Gauge(String label, boolean interactive, int maxValue, int initialValue) {
        this(label, interactive, maxValue, initialValue, null);
    }

    public Gauge(String label, boolean interactive, int maxValue, int initialValue, Style style) {
        super(label, 0, 0, style);
        this.isInteractive = interactive;
        if (interactive) {
            this.appearanceMode = 3;
        }
        this.maxValue = maxValue;
        this.isIndefinite = maxValue == -1;
        this.setValue(initialValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(int value) {
        if (this.isIndefinite) {
            if (this.value == 2 && value != 2) {
                AnimationThread.removeAnimationItem(this);
            }
            if (value == 0) {
                this.indefinitePos = 0;
            } else if (value == 2) {
                if (this.isShown && this.value != 2) {
                    AnimationThread.addAnimationItem(this);
                }
            } else if (value == 1) {
                this.indefinitePos = 0;
            } else {
                if (value != 3) throw new IllegalArgumentException();
                ++this.indefinitePos;
                if (this.indefinitePos > this.maxValue) {
                    this.indefinitePos = 0;
                }
            }
        } else if (value < 0) {
            value = 0;
        } else if (value > this.maxValue) {
            value = this.maxValue;
        }
        this.value = value;
        this.valueString = Integer.toString(value);
        if (!this.isShown) return;
        this.repaint();
    }

    public int getValue() {
        return this.value;
    }

    public void setMaxValue(int maxValue) {
        this.setInitialized(false);
        if (maxValue == -1) {
            if (this.maxValue != maxValue) {
                this.value = 0;
            }
            this.isIndefinite = true;
        } else if (this.value == 2) {
            this.isIndefinite = false;
            AnimationThread.removeAnimationItem(this);
        }
        this.maxValue = maxValue;
        this.setInitialized(false);
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int sliderWidth = this.contentWidth;
        int valueX = x;
        int valueAnchor = 36;
        if (this.showValue) {
            if (this.valuePosition == 0) {
                x += this.valueWidth;
                sliderWidth -= this.valueWidth;
            } else if (this.valuePosition == 1) {
                valueX = rightBorder;
                valueAnchor = 40;
                sliderWidth -= this.valueWidth;
            } else if (this.valuePosition == 2) {
                valueX = leftBorder + (rightBorder - leftBorder) / 2;
                valueAnchor = 33;
            }
        }
        if (this.isIndefinite) {
            if (this.image != null) {
                g.drawImage(this.image, x + this.indefinitePos, y + this.imageYOffset, 20);
            } else {
                int clipX = g.getClipX();
                int clipY = g.getClipX();
                int clipWidth = g.getClipWidth();
                int clipHeight = g.getClipHeight();
                g.clipRect(x, y, this.contentWidth, this.contentHeight);
                int gapPlusChunkWidth = this.indefinitePosMax;
                int sliderX = x + this.indefinitePos - gapPlusChunkWidth;
                this.slider.paint(sliderX, y, this.contentWidth + this.indefinitePosMax, this.contentHeight, g);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
        } else if (this.image != null) {
            if (this.value != 0) {
                int width = this.image.getWidth() * this.value / this.maxValue;
                int clipX = g.getClipX();
                int clipY = g.getClipY();
                int clipWidth = g.getClipWidth();
                int clipHeight = g.getClipHeight();
                g.clipRect(x, clipY, width, clipHeight);
                g.drawImage(this.image, x, y + this.imageYOffset, 20);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
        } else {
            if (this.sliderBackground != null) {
                this.sliderBackground.paint(x, y, sliderWidth, this.contentHeight, g);
            }
            int w = sliderWidth * this.value / this.maxValue;
            this.slider.paint(x, y, w, this.contentHeight, g);
        }
        if (this.showValue) {
            g.setFont(this.font);
            g.setColor(this.fontColor);
            g.drawString(this.valueString, valueX, y + this.font.getHeight(), valueAnchor);
        }
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        this.valueWidth = 0;
        int valueHeight = 0;
        if (this.isIndefinite) {
            this.showValue = false;
        }
        if (this.showValue) {
            if (this.font == null) {
                this.font = Font.getDefaultFont();
            }
            valueHeight = this.font.getHeight();
            this.valueWidth = this.font.stringWidth("" + this.maxValue) + this.paddingHorizontal;
        }
        if (this.preferredHeight > 0) {
            this.contentHeight = this.preferredHeight;
            if (this.image != null) {
                int imageHeight = this.image.getHeight();
                if ((this.layout & 0x20) == 32) {
                    this.imageYOffset = this.preferredHeight - imageHeight;
                } else if ((this.layout & 0x30) == 48) {
                    this.imageYOffset = (this.preferredHeight - imageHeight) / 2;
                }
            }
        } else {
            this.contentHeight = this.image != null ? this.image.getHeight() : 10;
        }
        if (this.contentHeight < valueHeight) {
            this.contentHeight = valueHeight;
        }
        this.contentWidth = this.image != null && !this.isIndefinite && this.preferredWidth == 0 ? this.image.getWidth() + this.valueWidth : (this.preferredWidth > 0 ? this.preferredWidth + this.valueWidth : (this.isLayoutExpand ? availWidth : ((this.layout & 0x400) == 1024 ? Math.max(availWidth / 3, 10) : firstLineWidth)));
        if (this.isIndefinite) {
            if (this.image != null) {
                this.maxValue = this.value == 0 || this.value == 2 ? this.contentWidth : this.contentWidth / this.image.getWidth();
            } else {
                this.maxValue = 20;
                this.indefinitePosMax = this.contentWidth;
                if (this.isDefaultChunkedSliderUsed) {
                    this.indefinitePosMax = this.gapWidth.getValue(this.contentWidth) + this.chunkWidth.getValue(this.contentWidth);
                }
            }
        }
        if (this.slider == null) {
            this.slider = new SimpleBackground(this.color);
        }
    }

    protected String createCssSelector() {
        return "gauge";
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        Integer modeInt = style.getIntProperty(21);
        if (modeInt != null) {
            this.mode = modeInt == 0 ? 1 : 0;
        }
        if (this.maxValue != -1) {
            Boolean showValueBool = style.getBooleanProperty(25);
            if (showValueBool != null) {
                this.showValue = showValueBool;
            }
            if (style.getFont() != null) {
                this.font = style.getFont();
            }
            this.fontColor = style.getFontColor();
        }
        if (this.mode == 1 && this.slider == null) {
            this.isDefaultChunkedSliderUsed = true;
            Color[] stripeColors = new Color[]{this.color, this.gapColor};
            Dimension[] stripeWidhs = new Dimension[]{this.chunkWidth, this.gapWidth};
            this.slider = new VerticalStripesBackground(stripeColors, stripeWidhs);
        }
    }

    public void setStyle(Style style, boolean resetStyle) {
        super.setStyle(style, resetStyle);
        Color gaugeColorObj = (Color)style.getObjectProperty(18);
        if (gaugeColorObj != null) {
            this.color = gaugeColorObj;
        }
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (!this.isInteractive) {
            return false;
        }
        if (gameAction == 5) {
            if (this.value < this.maxValue) {
                this.setValue(++this.value);
                this.notifyStateChanged();
                return true;
            }
            return true;
        }
        if (gameAction == 2) {
            if (this.value > 0) {
                this.setValue(--this.value);
                this.notifyStateChanged();
                return true;
            }
            return true;
        }
        return false;
    }

    protected boolean handlePointerPressed(int x, int y) {
        int val;
        if (this.isIndefinite || !this.isInteractive || !this.isInContentArea(x, y)) {
            return super.handlePointerPressed(x, y);
        }
        if (this.view != null && this.view.handlePointerPressed(x, y)) {
            return true;
        }
        int cw = this.contentWidth;
        if (this.showValue && this.valuePosition == 0) {
            x -= this.valueWidth;
            cw -= this.valueWidth;
        }
        if ((val = (x -= this.contentX - cw / (this.maxValue * 2)) * this.maxValue / cw) != this.value) {
            this.setValue(val);
            this.notifyStateChanged();
        }
        return true;
    }

    protected boolean handlePointerDragged(int x, int y, ClippingRegion repaintRegion) {
        int val;
        if (this.isIndefinite || !this.isInteractive || !this.isInContentArea(x, y)) {
            return super.handlePointerDragged(x, y, repaintRegion);
        }
        if (this.view != null && this.view.handlePointerDragged(x, y, repaintRegion)) {
            return true;
        }
        int cw = this.contentWidth;
        if (this.showValue && this.valuePosition == 0) {
            x -= this.valueWidth;
            cw -= this.valueWidth;
        }
        if ((val = (x -= this.contentX - cw / (this.maxValue * 2)) * this.maxValue / cw) != this.value) {
            this.setValue(val);
            this.notifyStateChanged();
            this.addRepaintArea(repaintRegion);
        }
        return true;
    }

    public boolean animate() {
        boolean animated = super.animate();
        if (this.view != null) {
            return animated;
        }
        if (this.isIndefinite && this.value == 2 && this.isInitialized()) {
            ++this.indefinitePos;
            if (this.image == null) {
                if (this.indefinitePos > this.indefinitePosMax) {
                    this.indefinitePos = 0;
                }
            } else if (this.indefinitePos > this.maxValue) {
                this.indefinitePos = -this.image.getWidth();
            }
            return true;
        }
        return animated;
    }

    protected void hideNotify() {
        super.hideNotify();
        if (this.isIndefinite && this.value == 2) {
            AnimationThread.removeAnimationItem(this);
        }
        this.isShown = false;
    }

    protected void showNotify() {
        super.showNotify();
        if (this.isIndefinite && this.value == 2) {
            AnimationThread.addAnimationItem(this);
        }
        this.isShown = true;
    }
}

