/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.io.Externalizable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Dimension
implements Externalizable {
    private static final int VERSION = 100;
    private static final int UNIT_UNDEFINED = Integer.MIN_VALUE;
    public static final int UNIT_PIXEL = 0;
    public static final int UNIT_PERCENT = 1;
    public static final int UNIT_EM = 1;
    public static final int UNIT_POINT = 2;
    private int unit;
    private int value;
    private boolean isPercent;
    private int factor;
    private String valueAsString;

    public Dimension(int value) {
        this(value, false);
    }

    public Dimension(int value, boolean isPercent) {
        this.value = value;
        this.isPercent = isPercent;
        this.factor = 1;
    }

    public Dimension(int value, int factor) {
        this.value = value;
        this.factor = factor;
        this.isPercent = true;
    }

    public Dimension(int value, int factor, int unit) {
        this.value = value;
        this.factor = factor;
        this.isPercent = unit == 0;
        this.unit = unit;
    }

    public Dimension(String value) {
        this.valueAsString = value;
    }

    public int getValue(int range) {
        if (this.valueAsString != null) {
            this.resolve();
        }
        if (this.isPercent) {
            return range * this.value / (this.factor * 100);
        }
        return this.value;
    }

    public int getUnit() {
        if (this.unit == Integer.MIN_VALUE) {
            this.resolve();
        }
        return this.unit;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void setValue(int value, boolean isPercent) {
        this.setValue(value, 1, isPercent ? 1 : 0);
    }

    public void setValue(int value, int factor) {
        this.setValue(value, factor, 1);
    }

    public void setValue(int value, int factor, int unit) {
        this.value = value;
        this.factor = factor;
        this.unit = unit;
        this.isPercent = unit == 1;
    }

    public void setValue(String value) {
        this.valueAsString = value;
        this.unit = Integer.MIN_VALUE;
    }

    public boolean isPercent() {
        if (this.valueAsString != null) {
            this.resolve();
        }
        return this.isPercent;
    }

    public void read(DataInputStream in) throws IOException {
        int version = in.readInt();
        this.value = in.readInt();
        this.factor = in.readInt();
        this.isPercent = in.readBoolean();
        if (version != 100) {
            // empty if block
        }
    }

    public void write(DataOutputStream out) throws IOException {
        if (this.valueAsString != null) {
            this.resolve();
        }
        out.writeInt(100);
        out.writeInt(this.value);
        out.writeInt(this.factor);
        out.writeBoolean(this.isPercent);
    }

    private void resolve() {
        String v = this.valueAsString;
        int l = v.length();
        if (v.charAt(l - 1) == '%') {
            int f = 1;
            boolean dotFound = false;
            StringBuffer buffer = new StringBuffer(l);
            for (int i = 0; i < l - 1; ++i) {
                char c = v.charAt(i);
                if (c == '.') {
                    if (dotFound) break;
                    dotFound = true;
                    continue;
                }
                if (!Character.isDigit(c)) {
                    if (c != ' ') break;
                    break;
                }
                buffer.append(c);
                if (!dotFound) continue;
                f *= 10;
            }
            this.isPercent = true;
            this.unit = 1;
            this.factor = f;
            this.value = Integer.parseInt(buffer.toString());
            this.valueAsString = null;
        } else if (v.endsWith("pt")) {
            if (this.parseNumberValue(v = v.substring(0, l - 2).trim())) {
                this.unit = 2;
            }
        } else {
            if (v.endsWith("px")) {
                v = v.substring(0, l - 2).trim();
            }
            if (this.parseNumberValue(v)) {
                this.unit = 0;
            }
        }
    }

    private boolean parseNumberValue(String v) {
        try {
            this.value = Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            char c;
            int length = v.length();
            StringBuffer buffer = new StringBuffer(length);
            for (int i = 0; i < length - 1 && Character.isDigit(c = v.charAt(i)); ++i) {
                buffer.append(c);
            }
            this.value = Integer.parseInt(buffer.toString());
            return false;
        }
        this.isPercent = false;
        this.factor = 1;
        this.valueAsString = null;
        return true;
    }
}

