/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Style;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.MathUtil;

public abstract class CssAnimation {
    public static final int FUNCTION_EASE = 0;
    public static final int FUNCTION_LINEAR = 1;
    public static final int FUNCTION_EASE_IN = 2;
    public static final int FUNCTION_EASE_OUT = 3;
    public static final int FUNCTION_EXPONENTIAL_IN = 4;
    public static final int FUNCTION_EXPONENTIAL_OUT = 5;
    public static final Object ANIMATION_FINISHED = new Object();
    protected final int cssAttributeId;
    protected String triggerEventId;
    protected final long duration;
    protected final long delay;
    protected final int function;
    protected final int repeat;
    protected final Object startValue;
    protected final Object endValue;
    protected final String fireEvent;

    protected CssAnimation(int cssAttributeId, String triggerEvent, long duration, long initialDelay, int function, int repeat, String fireEvent, Object startValue, Object endValue) {
        this.cssAttributeId = cssAttributeId;
        this.triggerEventId = triggerEvent;
        this.duration = duration;
        this.delay = initialDelay;
        this.function = function;
        this.repeat = repeat;
        this.fireEvent = fireEvent;
        this.startValue = startValue;
        this.endValue = endValue;
    }

    public void setStartValue(Style style) {
        style.addAttribute(this.cssAttributeId, this.startValue);
    }

    public void setEndValue(Style style) {
        style.addAttribute(this.cssAttributeId, this.endValue);
    }

    public Object getStartValue() {
        return this.startValue;
    }

    public Object getEndValue() {
        return this.endValue;
    }

    public abstract Object animate(Style var1, Object var2, long var3);

    public static int calculatePointInRange(int startValue, int endValue, long passedTime, long duration, int function) {
        if (passedTime >= duration) {
            return endValue;
        }
        int valueRange = endValue - startValue;
        switch (function) {
            case 0: {
                int time250Promille = (int)(passedTime * 250L / duration);
                int apxSin = MathUtil.apxSin(time250Promille);
                return startValue + apxSin * valueRange / 1000;
            }
            case 1: {
                int linearValue = (int)((long)startValue + (long)valueRange * passedTime / duration);
                return linearValue;
            }
            case 2: 
            case 3: {
                long max = duration ^ 2L;
                if (function == 3) {
                    long current = duration - passedTime ^ 2L;
                    return (int)((long)endValue - current * (long)valueRange / max);
                }
                long current = passedTime ^ 2L;
                return (int)((long)startValue + current * (long)valueRange / max);
            }
            case 4: {
                long promille = 1000L * passedTime * passedTime / (duration * duration);
                return startValue + (int)(promille * (long)valueRange / 1000L);
            }
            case 5: {
                long promille = 1000L - 1000L * (duration - passedTime) * (duration - passedTime) / (duration * duration);
                return startValue + (int)(promille * (long)valueRange / 1000L);
            }
        }
        throw new IllegalArgumentException();
    }

    public static int calculateColorInRange(int startColor, int endColor, long passedTime, long duration, int function) {
        if (passedTime >= duration) {
            return endColor;
        }
        int permille = CssAnimation.calculatePointInRange(0, 1000, passedTime, duration, function);
        return DrawUtil.getGradientColor(startColor, endColor, permille);
    }

    public long getDelay() {
        return this.delay;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public String getFireEvent() {
        return this.fireEvent;
    }
}

