/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ChoiceItem
extends IconItem {
    private static Image defaultRadioSelected;
    private static Image defaultRadioPlain;
    private static Image defaultCheckSelected;
    private static Image defaultCheckPlain;
    private boolean isMultiple;
    private Image selected;
    private Image plain;
    public boolean isSelected;
    private Image boxImage;
    private int boxWidth;
    private int yAdjust;
    public boolean drawBox;
    private int choiceType;
    protected Font preferredFont;
    private int boxColor;
    private boolean drawNoPlain;
    private boolean drawNoSelected;
    private int yBoxAdjust;
    private boolean isBoxAlignRight;

    public ChoiceItem(String text, Image image, int choiceType) {
        this(text, image, choiceType, null);
    }

    public ChoiceItem(String text, Image image, int choiceType, Style style) {
        super(text, image, style);
        this.choiceType = choiceType;
        this.drawBox = choiceType == 1 || choiceType == 2;
        this.isMultiple = choiceType == 2;
        this.appearanceMode = 3;
    }

    public void setChoiceType(int choiceType) {
        this.choiceType = choiceType;
        this.drawBox = choiceType == 1 || choiceType == 2;
        this.isMultiple = choiceType == 2;
    }

    protected String createCssSelector() {
        if (this.choiceType == 1) {
            return "radiobox";
        }
        if (this.choiceType == 2) {
            return "checkbox";
        }
        if (this.choiceType == 3) {
            return "listitem";
        }
        return "popup";
    }

    protected void initContent(int firstLineWidth, int availWidth, int availHeight) {
        int maxHeight;
        int maxWidth;
        if (!this.drawBox) {
            this.initContentImpl(firstLineWidth, availWidth, availHeight);
            return;
        }
        if (this.selected == null && !this.drawNoSelected) {
            this.selected = this.createSelected();
        }
        if (this.plain == null && !this.drawNoPlain) {
            this.plain = this.createPlain();
        }
        int n = maxWidth = this.selected == null ? 0 : this.selected.getWidth();
        if (!this.drawNoPlain && this.plain.getWidth() > maxWidth) {
            maxWidth = this.plain.getWidth();
        }
        if (!this.isBoxAlignRight) {
            maxWidth += this.paddingHorizontal;
        }
        this.boxWidth = maxWidth;
        int n2 = maxHeight = this.selected == null ? 0 : this.selected.getHeight();
        if (!this.drawNoPlain && this.plain.getHeight() > maxHeight) {
            maxHeight = this.plain.getHeight();
        }
        this.initContentImpl(firstLineWidth -= maxWidth, availWidth -= maxWidth, availHeight);
        this.contentWidth += maxWidth;
        if (this.contentHeight < maxHeight) {
            this.yBoxAdjust = 0;
            this.yAdjust = (this.layout & 0x30) == 48 ? (maxHeight - this.contentHeight) / 2 : ((this.layout & 0x20) == 32 ? maxHeight - this.contentHeight : 0);
            this.contentHeight = maxHeight;
        } else {
            this.yBoxAdjust = (this.layout & 0x30) == 48 ? (this.contentHeight - maxHeight) / 2 : ((this.layout & 0x20) == 32 ? this.contentHeight - maxHeight : 0);
            this.yAdjust = 0;
        }
        this.boxImage = this.isSelected ? this.selected : this.plain;
    }

    protected void initContentImpl(int firstLineWidth, int availWidth, int availHeight) {
        super.initContent(firstLineWidth, availWidth, availHeight);
    }

    private Image createSelected() {
        if (this.isMultiple) {
            if (defaultCheckSelected == null) {
                defaultCheckSelected = Image.createImage(12, 12);
                Graphics g = defaultCheckSelected.getGraphics();
                g.setColor(this.boxColor);
                g.drawRect(0, 0, 11, 11);
                g.drawRect(1, 1, 9, 9);
                g.drawLine(0, 0, 11, 11);
                g.drawLine(11, 0, 0, 11);
            }
            return defaultCheckSelected;
        }
        if (defaultRadioSelected == null) {
            defaultRadioSelected = Image.createImage(11, 11);
            Graphics g = defaultRadioSelected.getGraphics();
            g.setColor(this.boxColor);
            g.fillRect(0, 0, 12, 12);
            g.setColor(0xFFFFFF);
            g.fillArc(1, 1, 9, 9, 0, 360);
            g.setColor(this.boxColor);
            g.fillArc(3, 3, 5, 5, 0, 360);
        }
        return defaultRadioSelected;
    }

    private Image createPlain() {
        if (this.isMultiple) {
            if (defaultCheckPlain == null) {
                defaultCheckPlain = Image.createImage(12, 12);
                Graphics g = defaultCheckPlain.getGraphics();
                g.setColor(this.boxColor);
                g.drawRect(0, 0, 11, 11);
                g.drawRect(1, 1, 9, 9);
            }
            return defaultCheckPlain;
        }
        if (defaultRadioPlain == null) {
            defaultRadioPlain = Image.createImage(11, 11);
            Graphics g = defaultRadioPlain.getGraphics();
            g.setColor(this.boxColor);
            g.fillRect(0, 0, 12, 12);
            g.setColor(0xFFFFFF);
            g.fillArc(1, 1, 9, 9, 0, 360);
        }
        return defaultRadioPlain;
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (this.drawBox) {
            int boxX = x;
            int boxY = y + this.yBoxAdjust;
            if (this.isBoxAlignRight) {
                boxX = rightBorder -= this.boxWidth;
            } else {
                x += this.boxWidth;
                leftBorder += this.boxWidth;
            }
            if (this.boxImage != null) {
                g.drawImage(this.boxImage, boxX, boxY, 20);
            }
            y += this.yAdjust;
        }
        this.paintContentImpl(x, y, leftBorder, rightBorder, g);
    }

    protected void paintContentImpl(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        super.paintContent(x, y, leftBorder, rightBorder, g);
    }

    public void setStyle(Style style) {
        Integer boxAlignInt;
        super.setStyle(style);
        if (this.drawBox) {
            Style parentStyle = null;
            if (this.parent != null) {
                parentStyle = this.parent.style;
            }
            if (this.choiceType == 2) {
                String url = style.getProperty(9);
                if (url == null && parentStyle != null) {
                    url = parentStyle.getProperty(9);
                }
                if ("none".equals(url)) {
                    this.drawNoSelected = true;
                } else {
                    this.loadImage(url, false);
                }
            }
            if (this.choiceType == 2) {
                String plainName = style.getProperty(10);
                if (plainName == null && parentStyle != null) {
                    plainName = parentStyle.getProperty(10);
                }
                if ("none".equals(plainName)) {
                    this.drawNoPlain = true;
                } else {
                    this.loadImage(plainName, true);
                }
            }
            this.boxColor = style.getFontColor();
        }
        if ((boxAlignInt = style.getIntProperty(421)) != null) {
            this.isBoxAlignRight = boxAlignInt == 1;
        }
    }

    private void loadImage(String name, boolean isPlain) {
        if (name == null) {
            return;
        }
        try {
            if (isPlain) {
                this.plain = StyleSheet.getImage(name, this, true);
            } else {
                this.selected = StyleSheet.getImage(name, this, true);
            }
        }
        catch (IOException e) {
            Debug.debug("error", "de.enough.polish.ui.ChoiceItem", 531, (Object)("Unable to load image [" + name + "]"), e);
        }
    }

    public void select(boolean select) {
        if (select == this.isSelected) {
            return;
        }
        this.isSelected = select;
        this.boxImage = select ? this.selected : this.plain;
    }

    public void toggleSelect() {
        this.select(!this.isSelected);
    }

    public void setPreferredFont(Font font) {
        this.preferredFont = font;
    }

    public void adjustProperties(Item lastItem) {
        this.relativeY = lastItem.relativeY;
    }

    public void setPlainImage(Image image) {
        this.plain = image;
    }

    public Image getPlainImage() {
        return this.plain;
    }

    public void setSelectedImage(Image image) {
        this.selected = image;
    }

    public Image getSelectedImage() {
        return this.selected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }
}

