/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.pim;

import de.enough.polish.calendar.CalendarEntry;
import de.enough.polish.io.RmsStorage;
import de.enough.polish.pim.PimChangeItem;
import de.enough.polish.pim.PimContact;
import de.enough.polish.pim.PimToDo;
import de.enough.polish.pim.PimUtility;
import de.enough.polish.util.ArrayList;
import java.io.IOException;
import java.util.Vector;

public class PimChangeRegistry {
    private RmsStorage storage = new RmsStorage();
    private Vector items;
    private PimUtility pimUtility = new PimUtility();

    public PimChangeRegistry() {
        try {
            this.items = (Vector)this.storage.read("PimItems");
        }
        catch (IOException e) {
            this.createSnapShot();
        }
    }

    public PimContact[] getAllAddedContacts() {
        ArrayList addedContacts = new ArrayList();
        try {
            this.items = (Vector)this.storage.read("PimItems");
            PimContact[] allContacts = this.pimUtility.getAllContacts();
            int localPimItemsSize = this.items.size();
            int outerPimItemsSize = allContacts.length;
            for (int i = 0; i < outerPimItemsSize; ++i) {
                PimContact pimContact = allContacts[i];
                boolean flag = false;
                for (int j = 0; j < localPimItemsSize; ++j) {
                    PimChangeItem changedItem = (PimChangeItem)this.items.elementAt(j);
                    if (!changedItem.getTypeOfItem().equals("CONTACT") || !changedItem.getUid().equals(pimContact.getUid())) continue;
                    flag = true;
                }
                if (flag) continue;
                addedContacts.add(this.pimUtility.findContactByUid(pimContact.getUid()));
            }
        }
        catch (Exception e) {
            this.items = new Vector();
        }
        return (PimContact[])addedContacts.toArray(new PimContact[addedContacts.size()]);
    }

    public PimContact[] getAllModifiedContacts() {
        ArrayList modifiedContacts = new ArrayList();
        try {
            this.items = (Vector)this.storage.read("PimItems");
            PimContact[] allContacts = this.pimUtility.getAllContacts();
            int localPimItemsSize = this.items.size();
            int outerPimItemsSize = allContacts.length;
            for (int i = 0; i < outerPimItemsSize; ++i) {
                PimContact pimContact = allContacts[i];
                for (int j = 0; j < localPimItemsSize; ++j) {
                    PimChangeItem changedItem = (PimChangeItem)this.items.elementAt(j);
                    if (!changedItem.getTypeOfItem().equals("CONTACT") || !changedItem.getUid().equals(pimContact.getUid()) || changedItem.getRevisionDate().getTime() == pimContact.getLastRevision().getTime()) continue;
                    modifiedContacts.add(this.pimUtility.findContactByUid(pimContact.getUid()));
                }
            }
        }
        catch (Exception e) {
            this.items = new Vector();
        }
        return (PimContact[])modifiedContacts.toArray(new PimContact[modifiedContacts.size()]);
    }

    public void getAllRemovedContacts() {
        try {
            this.items = (Vector)this.storage.read("PimItems");
            PimContact[] allContacts = this.pimUtility.getAllContacts();
            int localPimItemsSize = this.items.size();
            int outerPimItemsSize = allContacts.length;
            Vector<String> removedContacts = new Vector<String>();
            for (int i = 0; i < localPimItemsSize; ++i) {
                PimChangeItem changedItem = (PimChangeItem)this.items.elementAt(i);
                boolean flag = false;
                for (int j = 0; j < outerPimItemsSize; ++j) {
                    PimContact pimContact = allContacts[j];
                    if (!changedItem.getTypeOfItem().equals("CONTACT") || !changedItem.getUid().equals(pimContact.getUid())) continue;
                    flag = true;
                }
                if (!flag) continue;
                removedContacts.addElement(changedItem.getUid());
            }
        }
        catch (Exception e) {
            this.items = new Vector();
        }
    }

    public CalendarEntry[] getAllAddedEvents() {
        ArrayList addedEvents = new ArrayList();
        try {
            this.items = (Vector)this.storage.read("PimItems");
            CalendarEntry[] allEvents = this.pimUtility.getAllEvents();
            int localPimItemsSize = this.items.size();
            int outerPimItemsSize = allEvents.length;
            for (int i = 0; i < outerPimItemsSize; ++i) {
                CalendarEntry calendarEntry = allEvents[i];
                boolean flag = false;
                for (int j = 0; j < localPimItemsSize; ++j) {
                    PimChangeItem changedItem = (PimChangeItem)this.items.elementAt(j);
                    if (!changedItem.getTypeOfItem().equals("EVENT") || !changedItem.getUid().equals(calendarEntry.getId())) continue;
                    flag = true;
                }
                if (flag) continue;
                addedEvents.add(this.pimUtility.findEventByUid(calendarEntry.getId()));
            }
        }
        catch (Exception e) {
            this.items = new Vector();
        }
        return (CalendarEntry[])addedEvents.toArray(new CalendarEntry[addedEvents.size()]);
    }

    public CalendarEntry[] getAllModifiedEvents() {
        ArrayList modifiedEvents = new ArrayList();
        try {
            this.items = (Vector)this.storage.read("PimItems");
            CalendarEntry[] allEvents = this.pimUtility.getAllEvents();
            int localPimItemsSize = this.items.size();
            int outerPimItemsSize = allEvents.length;
            for (int i = 0; i < outerPimItemsSize; ++i) {
                CalendarEntry calendarEntry = allEvents[i];
                for (int j = 0; j < localPimItemsSize; ++j) {
                    PimChangeItem changedItem = (PimChangeItem)this.items.elementAt(j);
                    if (!changedItem.getTypeOfItem().equals("EVENT") || !changedItem.getUid().equals(calendarEntry.getId())) continue;
                    modifiedEvents.add(this.pimUtility.findEventByUid(calendarEntry.getId()));
                }
            }
        }
        catch (Exception e) {
            this.items = new Vector();
        }
        return (CalendarEntry[])modifiedEvents.toArray(new CalendarEntry[modifiedEvents.size()]);
    }

    public void getAllRemovedEvents() {
        try {
            this.items = (Vector)this.storage.read("PimItems");
            CalendarEntry[] allEvents = this.pimUtility.getAllEvents();
            int localPimItemsSize = this.items.size();
            int outerPimItemsSize = allEvents.length;
            Vector<String> removedEvents = new Vector<String>();
            for (int i = 0; i < localPimItemsSize; ++i) {
                PimChangeItem changedItem = (PimChangeItem)this.items.elementAt(i);
                boolean flag = false;
                for (int j = 0; j < outerPimItemsSize; ++j) {
                    CalendarEntry calendarEntry = allEvents[j];
                    if (!changedItem.getTypeOfItem().equals("EVENT") || !changedItem.getUid().equals(calendarEntry.getId())) continue;
                    flag = true;
                }
                if (!flag) continue;
                removedEvents.addElement(changedItem.getUid());
            }
        }
        catch (Exception e) {
            this.items = new Vector();
        }
    }

    public PimToDo[] getAllAddedToDos() {
        ArrayList addedToDos = new ArrayList();
        try {
            this.items = (Vector)this.storage.read("PimItems");
            PimToDo[] allToDos = this.pimUtility.getAllToDos();
            int localPimItemsSize = this.items.size();
            int outerPimItemsSize = allToDos.length;
            for (int i = 0; i < outerPimItemsSize; ++i) {
                PimToDo pimToDo = allToDos[i];
                boolean flag = false;
                for (int j = 0; j < localPimItemsSize; ++j) {
                    PimChangeItem changedItem = (PimChangeItem)this.items.elementAt(j);
                    if (!changedItem.getTypeOfItem().equals("TODO") || !changedItem.getUid().equals(pimToDo.getUid())) continue;
                    flag = true;
                }
                if (flag) continue;
                addedToDos.add(this.pimUtility.findToDoByUid(pimToDo.getUid()));
            }
        }
        catch (Exception e) {
            this.items = new Vector();
        }
        return (PimToDo[])addedToDos.toArray(new PimToDo[addedToDos.size()]);
    }

    public PimToDo[] getAllModifiedToDos() {
        ArrayList modifiedToDos = new ArrayList();
        try {
            this.items = (Vector)this.storage.read("PimItems");
            PimToDo[] allToDos = this.pimUtility.getAllToDos();
            int localPimItemsSize = this.items.size();
            int outerPimItemsSize = allToDos.length;
            for (int i = 0; i < outerPimItemsSize; ++i) {
                PimToDo pimToDo = allToDos[i];
                for (int j = 0; j < localPimItemsSize; ++j) {
                    PimChangeItem changedItem = (PimChangeItem)this.items.elementAt(j);
                    if (!changedItem.getTypeOfItem().equals("TODO") || !changedItem.getUid().equals(pimToDo.getUid()) || changedItem.getRevisionDate().getTime() == pimToDo.getLastRevisedDate().getTime()) continue;
                    modifiedToDos.add(this.pimUtility.findToDoByUid(pimToDo.getUid()));
                }
            }
        }
        catch (Exception e) {
            this.items = new Vector();
        }
        return (PimToDo[])modifiedToDos.toArray(new PimToDo[modifiedToDos.size()]);
    }

    public void getAllRemovedToDos() {
        try {
            this.items = (Vector)this.storage.read("PimItems");
            PimToDo[] allToDos = this.pimUtility.getAllToDos();
            int localPimItemsSize = this.items.size();
            int outerPimItemsSize = allToDos.length;
            Vector<String> removedToDos = new Vector<String>();
            for (int i = 0; i < localPimItemsSize; ++i) {
                PimChangeItem changedItem = (PimChangeItem)this.items.elementAt(i);
                boolean flag = false;
                for (int j = 0; j < outerPimItemsSize; ++j) {
                    PimToDo pimToDo = allToDos[j];
                    if (!changedItem.getTypeOfItem().equals("TODO") || !changedItem.getUid().equals(pimToDo.getUid())) continue;
                    flag = true;
                }
                if (!flag) continue;
                removedToDos.addElement(changedItem.getUid());
            }
        }
        catch (Exception e) {
            this.items = new Vector();
        }
    }

    public void updateSnapShot() {
        try {
            this.storage.delete("PimItems");
            this.createSnapShot();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createSnapShot() {
        this.items = new Vector();
        try {
            PimContact[] allContacts = this.pimUtility.getAllContacts();
            int size = allContacts.length;
            PimChangeItem pimChangeItem = null;
            for (int i = 0; i < size; ++i) {
                PimContact pimContact = allContacts[i];
                pimChangeItem = new PimChangeItem();
                pimChangeItem.setUid(pimContact.getUid());
                pimChangeItem.setRevisionDate(pimContact.getLastRevision());
                pimChangeItem.setTypeOfItem("CONTACT");
                this.items.addElement(pimChangeItem);
            }
            CalendarEntry[] allEvents = this.pimUtility.getAllEvents();
            size = allEvents.length;
            for (int i = 0; i < size; ++i) {
                CalendarEntry calendarEntry = allEvents[i];
                pimChangeItem = new PimChangeItem();
                pimChangeItem.setUid(calendarEntry.getId());
                pimChangeItem.setTypeOfItem("EVENT");
                this.items.addElement(pimChangeItem);
            }
            PimToDo[] allToDos = this.pimUtility.getAllToDos();
            size = allToDos.length;
            for (int i = 0; i < size; ++i) {
                PimToDo pimToDo = allToDos[i];
                pimChangeItem = new PimChangeItem();
                pimChangeItem.setUid(pimToDo.getUid());
                pimChangeItem.setRevisionDate(pimToDo.getLastRevisedDate());
                pimChangeItem.setTypeOfItem("TODO");
                this.items.addElement(pimChangeItem);
            }
            this.storage.save(this.items, "PimItems");
        }
        catch (Exception pe) {
            pe.printStackTrace();
        }
    }
}

