/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.multimedia;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class AudioPlayer
implements PlayerListener {
    private static final Hashtable AUDIO_TYPES = new Hashtable();
    private final boolean doCachePlayer;
    private Player player;
    private PlayerListener listener;
    private final String defaultContentType;
    private int userJ2MeLevel = -1;
    private int previousVolumeLevel = -1;
    private int androidMaxVolume = -1;

    public AudioPlayer() {
        this(false, null, null);
    }

    public AudioPlayer(boolean doCachePlayer) {
        this(doCachePlayer, null, null);
    }

    public AudioPlayer(String contentType) {
        this(false, contentType, null);
    }

    public AudioPlayer(boolean doCachePlayer, String contentType) {
        this(doCachePlayer, contentType, null);
    }

    public AudioPlayer(boolean doCachePlayer, String contentType, PlayerListener listener) {
        this.listener = listener;
        this.doCachePlayer = doCachePlayer;
        if (contentType != null) {
            String correctContentType;
            if (!contentType.startsWith("audio/")) {
                contentType = "audio/" + contentType;
            }
            if ((correctContentType = AudioPlayer.getAudioType(contentType, null)) != null) {
                contentType = correctContentType;
            }
        }
        this.defaultContentType = contentType;
    }

    public void stop() {
    }

    public void setPlayerListener(PlayerListener listener) {
        this.listener = listener;
    }

    public PlayerListener getPlayerListener() {
        return this.listener;
    }

    public void streamMp3s(String[] filenames) throws IOException {
    }

    public void play(String url, String type) throws MediaException, IOException {
        InputStream in = this.getClass().getResourceAsStream(url);
        if (in == null) {
            throw new IOException("not found: " + url);
        }
        this.play(in, type);
        if (this.userJ2MeLevel != -1) {
            this.setVolumeLevel(this.userJ2MeLevel);
        }
    }

    public void play(InputStream in, String type) throws MediaException, IOException {
        String correctType = AudioPlayer.getAudioType(type, "file");
        if (correctType == null && (correctType = AudioPlayer.getAudioType(type, null)) == null) {
            correctType = type;
        }
        this.player = Manager.createPlayer(in, correctType);
        this.player.addPlayerListener(this);
        this.player.start();
        if (this.userJ2MeLevel != -1) {
            this.setVolumeLevel(this.userJ2MeLevel);
        }
    }

    public void play(String url) throws MediaException, IOException {
        InputStream in = this.getClass().getResourceAsStream(url);
        if (in == null) {
            throw new IOException("not found: " + url);
        }
        this.play(in);
        if (this.userJ2MeLevel != -1) {
            this.setVolumeLevel(this.userJ2MeLevel);
        }
    }

    public void play(InputStream in) throws MediaException, IOException {
        String correctType = this.defaultContentType;
        this.player = Manager.createPlayer(in, correctType);
        this.player.addPlayerListener(this);
        this.player.start();
        if (this.userJ2MeLevel != -1) {
            this.setVolumeLevel(this.userJ2MeLevel);
        }
    }

    public void play() throws MediaException {
        if (this.player != null) {
            this.player.start();
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public static String getAudioType(String type, String protocol) {
        String[] supportedContentTypes;
        if (AUDIO_TYPES.size() == 0) {
            AudioPlayer.addTypes(new String[]{"audio/3gpp", "audio/3gp"});
            AudioPlayer.addTypes(new String[]{"audio/x-mp3", "audio/mp3", "audio/x-mp3", "audio/mpeg3", "audio/x-mpeg3", "audio/mpeg-3"});
            AudioPlayer.addTypes(new String[]{"audio/midi", "audio/x-midi", "audio/mid", "audio/x-mid", "audio/sp-midi"});
            AudioPlayer.addTypes(new String[]{"audio/wav", "audio/x-wav"});
            AudioPlayer.addTypes(new String[]{"audio/amr", "audio/x-amr"});
            AudioPlayer.addTypes(new String[]{"audio/mpeg4", "audio/mpeg-4", "audio/mp4", "audio/mp4a-latm"});
            AudioPlayer.addTypes(new String[]{"audio/imelody", "audio/x-imelody", "audio/imy", "audio/x-imy"});
        }
        if ((supportedContentTypes = Manager.getSupportedContentTypes(protocol)) == null || supportedContentTypes.length == 0) {
            return null;
        }
        Hashtable mappings = (Hashtable)AUDIO_TYPES.get(type);
        if (mappings == null) {
            for (int i = 0; i < supportedContentTypes.length; ++i) {
                String contentType = supportedContentTypes[i];
                if (!contentType.equals(type)) continue;
                return type;
            }
        } else {
            for (int i = 0; i < supportedContentTypes.length; ++i) {
                String contentType = supportedContentTypes[i];
                if (!mappings.containsKey(contentType)) continue;
                return contentType;
            }
        }
        return null;
    }

    public static boolean isSupportedAudioType(String type, String protocol) {
        return AudioPlayer.getAudioType(type, protocol) != null;
    }

    public boolean isPlaying() {
        if (this.player != null) {
            return this.player.getState() == 400;
        }
        return false;
    }

    private static void addTypes(String[] types) {
        Hashtable<String, String> nestedMap = new Hashtable<String, String>();
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            nestedMap.put(type, type);
            AUDIO_TYPES.put(type, nestedMap);
        }
    }

    public void playerUpdate(Player p, String event, Object data) {
        if (this.listener != null) {
            this.listener.playerUpdate(p, event, data);
        }
        if (!this.doCachePlayer && "endOfMedia".equals(event)) {
            p.removePlayerListener(this);
        }
    }

    public void cleanUpPlayer() {
        this.userJ2MeLevel = -1;
        if (this.player != null) {
            this.player.deallocate();
            this.player.close();
            this.player = null;
        }
    }

    public int getVolumeLevel() {
        VolumeControl volumeControl;
        Player pl = this.player;
        if (pl != null && (volumeControl = (VolumeControl)pl.getControl("VolumeControl")) != null) {
            return volumeControl.getLevel();
        }
        int volume = this.userJ2MeLevel;
        return volume;
    }

    public void setVolumeLevel(int j2MeLevel) {
        VolumeControl volumeControl;
        int boundJ2MeLevel;
        this.userJ2MeLevel = boundJ2MeLevel = this.boundJ2MeLevel(j2MeLevel);
        Player pl = this.player;
        if (pl != null && (volumeControl = (VolumeControl)pl.getControl("VolumeControl")) != null) {
            volumeControl.setLevel(100);
            return;
        }
    }

    public boolean isMuted() {
        int level = this.getVolumeLevel();
        return level == 0;
    }

    public void setMute(boolean mute) {
        if (mute) {
            this.previousVolumeLevel = this.getVolumeLevel();
            this.setVolumeLevel(0);
        } else if (this.previousVolumeLevel != -1) {
            this.setVolumeLevel(this.previousVolumeLevel);
        }
    }

    private int boundJ2MeLevel(int aJ2MeLevel) {
        if (aJ2MeLevel < 0) {
            aJ2MeLevel = 0;
        } else if (aJ2MeLevel > 100) {
            aJ2MeLevel = 100;
        }
        return aJ2MeLevel;
    }

    public void prepare(String url) throws IOException {
    }
}

