/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.log.display;

import de.enough.polish.log.LogEntry;
import de.enough.polish.ui.Canvas;
import de.enough.polish.ui.Display;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.TextUtil;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class LogCanvas
extends Canvas {
    private static final long TIMEOUT = 30000L;
    private static final int MAX_ENTRIES = 100;
    private static final int COLOR_BACKGROUND = -1426063361;
    private static final int COLOR_FONT = 0;
    private static final int COLOR_SHADOW = 0xFFFFFF;
    protected ArrayList logLines = new ArrayList(100);
    protected boolean isRegistered;
    protected long lastAddTime;

    public void addLogEntry(LogEntry logEntry) {
        this.lastAddTime = logEntry.time;
        String message = logEntry.getMessage();
        Font font = Font.getDefaultFont();
        int screenWidth = Display.getScreenWidth() - 10;
        String[] lines = TextUtil.wrap(message, font, screenWidth, screenWidth);
        int i = lines.length;
        while (--i >= 0) {
            if (i == 0) {
                this.logLines.add(lines[i]);
                continue;
            }
            this.logLines.add(" " + lines[i]);
        }
        while (this.logLines.size() > 100) {
            this.logLines.remove(0);
        }
        Display display = Display.getInstance();
        if (!this.isRegistered) {
            if (display != null) {
                this.isRegistered = true;
            }
        } else if (display != null) {
            display.repaint();
        }
    }

    protected void paint(Graphics g) {
        int lineHeight;
        if (System.currentTimeMillis() - this.lastAddTime > 30000L) {
            return;
        }
        Font font = Font.getDefaultFont();
        g.setFont(font);
        Object[] lines = this.logLines.getInternalArray();
        int screenHeight = Display.getScreenHeight();
        int y = lineHeight = font.getHeight() + 4;
        DrawUtil.fillRect(0, 0, this.getWidth(), Math.max(screenHeight, this.logLines.size() * lineHeight), -1426063361, g);
        int i = this.logLines.size();
        while (--i >= 0) {
            String line = (String)lines[i];
            g.setColor(0xFFFFFF);
            g.drawString(line, 3, y + 1, 36);
            g.setColor(0);
            g.drawString(line, 2, y, 36);
            if ((y += lineHeight) <= screenHeight) continue;
            break;
        }
    }
}

