/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.log.bluetooth;

import de.enough.polish.bluetooth.DiscoveryHelper;
import de.enough.polish.bluetooth.L2CapOutputStream;
import de.enough.polish.log.LogEntry;
import de.enough.polish.log.LogHandler;
import de.enough.polish.util.ArrayList;
import java.io.IOException;
import javax.bluetooth.L2CAPConnection;

public class BluetoothLogHandler
extends LogHandler
implements Runnable {
    private static final String UUID = "21dc585c319b4dc39cf8457e90a07444";
    private ArrayList buffer;
    private Exception exception;
    private L2CAPConnection connection;

    public BluetoothLogHandler() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void handleLogEntry(LogEntry logEntry) throws Exception {
        if (this.connection != null) {
            this.sendLogEntry(logEntry);
        } else {
            ArrayList list = this.buffer;
            if (list != null) {
                list.add(logEntry);
            } else if (this.exception != null) {
                Exception e = this.exception;
                this.exception = null;
                throw e;
            }
        }
    }

    public void run() {
        try {
            this.connection = (L2CAPConnection)DiscoveryHelper.findAndConnectService(UUID, 10390323, 256);
            ArrayList list = this.buffer;
            if (list == null) {
                return;
            }
            this.buffer = null;
            for (int i = 0; i < list.size(); ++i) {
                LogEntry entry = (LogEntry)list.get(i);
                this.sendLogEntry(entry);
            }
        }
        catch (Exception e) {
            this.exception = e;
            e.printStackTrace();
            this.buffer = null;
        }
    }

    private void sendLogEntry(LogEntry entry) throws IOException {
        L2CapOutputStream out = new L2CapOutputStream(this.connection);
        out.write(entry.toString().getBytes());
        out.close();
    }

    public void exit() {
        super.exit();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

