/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.io.file;

import de.enough.polish.io.file.FileSystemNode;
import de.enough.polish.io.file.FileSystemTreeModel;
import de.enough.polish.io.file.ItemCreator;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ArrayList;

public class UiFileSystemTreeModel
extends FileSystemTreeModel {
    protected ItemCreator itemCreator;

    public boolean isLeaf(Object node) {
        if (node instanceof Item) {
            FileSystemNode fsNode = (FileSystemNode)((Item)node).getAttribute(this);
            return super.isLeaf(fsNode);
        }
        return true;
    }

    public void addChildren(Object parent, ArrayList list) {
        if (parent instanceof Item) {
            parent = ((Item)parent).getAttribute(this);
        }
        super.addChildren(parent, list);
        for (int i = 0; i < list.size(); ++i) {
            Item item;
            FileSystemNode node = (FileSystemNode)list.get(i);
            if (this.itemCreator != null) {
                item = this.itemCreator.createItem(node);
            } else {
                Style nodeStyle = this.getStyle(node);
                item = new IconItem(node.getPath(), null, nodeStyle);
            }
            item.setAttribute(this, node);
            this.addCommands(node, item);
            list.set(i, item);
        }
    }

    protected void addCommands(FileSystemNode node, Item item) {
    }

    protected Style getStyle(FileSystemNode node) {
        Style nodeStyle = null;
        if (node.isDirectory()) {
            // empty if block
        }
        return nodeStyle;
    }

    public void setItemCreator(ItemCreator itemCreator) {
        this.itemCreator = itemCreator;
    }
}

