/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.graphics3d.utils;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Utilities3d {
    public static Image[][] imageToTextureMatrix(Image sourceImg, int maxTexDim, Image[][] texMatrix) {
        if (null != sourceImg) {
            if (maxTexDim < 0) {
                maxTexDim = 256;
            }
            int imgW = sourceImg.getWidth();
            int imgH = sourceImg.getHeight();
            int maxImgDim = Math.max(imgW, imgH);
            int i = 0;
            while (maxImgDim > 1 << ++i) {
            }
            int minTexDimRespect = 1 << i;
            if (minTexDimRespect <= maxTexDim) {
                if (null == texMatrix) {
                    texMatrix = new Image[1][1];
                }
                Image image = Image.createImage(maxTexDim, maxTexDim);
                texMatrix[0][0] = image;
                Image base = image;
                Graphics g = base.getGraphics();
                g.setColor(0);
                g.fillRect(0, 0, base.getWidth(), base.getHeight());
                g.drawImage(sourceImg, base.getWidth() - imgW >> 1, base.getHeight() - imgH >> 1, 0);
            } else {
                int numSubTexPerRow = 0;
                int numSubTexPerColumn = 0;
                while (maxTexDim * numSubTexPerRow < imgW) {
                    ++numSubTexPerRow;
                }
                while (maxTexDim * numSubTexPerColumn < imgH) {
                    ++numSubTexPerColumn;
                }
                int totalNumSubTex = numSubTexPerRow * numSubTexPerColumn;
                int totalRowTexSetDim = numSubTexPerRow * maxTexDim;
                int totalColumnTexSetDim = numSubTexPerColumn * maxTexDim;
                if (null == texMatrix) {
                    texMatrix = new Image[numSubTexPerColumn][numSubTexPerRow];
                }
                int xOffsetBase = totalRowTexSetDim - imgW >> 1;
                int yOffsetBase = totalColumnTexSetDim - imgH >> 1;
                for (i = 0; i < totalNumSubTex; ++i) {
                    Image img;
                    int column = i % numSubTexPerRow;
                    int row = i / numSubTexPerRow;
                    if (null == texMatrix[row] || null == texMatrix[row][column]) {
                        texMatrix[row][column] = img = Image.createImage(maxTexDim, maxTexDim);
                    } else {
                        img = texMatrix[row][column];
                    }
                    Graphics g = img.getGraphics();
                    g.setColor(-16777216);
                    g.fillRect(0, 0, img.getWidth(), img.getHeight());
                    int xOffset = xOffsetBase;
                    int yOffset = yOffsetBase;
                    g.drawImage(sourceImg, xOffset -= column * maxTexDim, yOffset -= row * maxTexDim, 0);
                }
            }
            return texMatrix;
        }
        return null;
    }

    public static int getNumTextureMatrixPerRow(Image sourceImg, int maxTexDim) {
        if (null != sourceImg) {
            int numSubTexPerRow = 0;
            int imgW = sourceImg.getWidth();
            while (maxTexDim * numSubTexPerRow < imgW) {
                ++numSubTexPerRow;
            }
            return numSubTexPerRow;
        }
        return -1;
    }

    public static int getNumTextureMatrixPerColumn(Image sourceImg, int maxTexDim) {
        if (null != sourceImg) {
            int numSubTexPerColumn = 0;
            int imgH = sourceImg.getHeight();
            while (maxTexDim * numSubTexPerColumn < imgH) {
                ++numSubTexPerColumn;
            }
            return numSubTexPerColumn;
        }
        return -1;
    }

    public static boolean validateTexture(Image img, int maxTexture) {
        if (null == img) {
            return false;
        }
        int imgWidth = img.getWidth();
        while (maxTexture > 0) {
            if (maxTexture == imgWidth) {
                return true;
            }
            maxTexture >>= 1;
        }
        return false;
    }

    public static int calculateOptimalTextureResolution(Image sourceImg, int maxTexDim, int thresholdPercent) {
        if (null != sourceImg) {
            int imgWidth = sourceImg.getWidth();
            int imgHeight = sourceImg.getHeight();
            int max = Math.max(imgWidth, imgHeight);
            while (max < maxTexDim >> 1) {
                maxTexDim >>= 1;
            }
            long pixelRealestate = Utilities3d.getNumTextureMatrixPerRow(sourceImg, maxTexDim) * Utilities3d.getNumTextureMatrixPerColumn(sourceImg, maxTexDim) * (maxTexDim * maxTexDim);
            int maxTexDimCandidate = maxTexDim >> 1;
            long pixelRealestateCandidate = Utilities3d.getNumTextureMatrixPerRow(sourceImg, maxTexDimCandidate) * Utilities3d.getNumTextureMatrixPerColumn(sourceImg, maxTexDimCandidate) * (maxTexDimCandidate * maxTexDimCandidate);
            while ((int)(pixelRealestateCandidate * 1000000L / pixelRealestate / 10000L) <= thresholdPercent) {
                pixelRealestate = pixelRealestateCandidate;
                maxTexDim = maxTexDimCandidate;
                maxTexDimCandidate = maxTexDim >> 1;
                pixelRealestateCandidate = Utilities3d.getNumTextureMatrixPerRow(sourceImg, maxTexDimCandidate) * Utilities3d.getNumTextureMatrixPerColumn(sourceImg, maxTexDimCandidate) * (maxTexDimCandidate * maxTexDimCandidate);
            }
            return maxTexDim;
        }
        return -1;
    }
}

