/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.format.atom;

import de.enough.polish.io.Externalizable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AtomImage
implements Externalizable {
    private static final int VERSION = 100;
    private static boolean serializeImageData = true;
    private String url;
    private byte[] data;
    private Object nativeRepresentation;

    public AtomImage() {
    }

    public AtomImage(String url) {
        this.url = url;
    }

    public AtomImage(String url, byte[] data) {
        this.url = url;
        this.data = data;
    }

    public static boolean isSerializeImageData() {
        return serializeImageData;
    }

    public static void setSerializeImageData(boolean serializeData) {
        serializeImageData = serializeData;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String getUrl() {
        return this.url;
    }

    public Object getNativeRepresentation() {
        return this.nativeRepresentation;
    }

    public void setNativeRepresentation(Object object) {
        this.nativeRepresentation = object;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(100);
        boolean notNull = this.url != null;
        out.writeBoolean(notNull);
        if (notNull) {
            out.writeUTF(this.url);
        }
        notNull = this.data != null && serializeImageData;
        out.writeBoolean(notNull);
        if (notNull) {
            out.writeInt(this.data.length);
            out.write(this.data, 0, this.data.length);
        }
    }

    public void read(DataInputStream in) throws IOException {
        int version = in.readInt();
        if (version != 100) {
            throw new IOException("unknown verion " + version);
        }
        boolean notNull = in.readBoolean();
        if (notNull) {
            this.url = in.readUTF();
        }
        if (notNull = in.readBoolean()) {
            int size = in.readInt();
            byte[] buffer = new byte[size];
            in.read(buffer, 0, size);
            this.data = buffer;
        }
    }
}

