/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.event;

import de.enough.polish.ui.Command;
import de.enough.polish.ui.CommandListener;
import de.enough.polish.ui.Displayable;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.util.Debug;

public class AsynchronousMultipleCommandListener
implements Runnable {
    private static AsynchronousMultipleCommandListener instance;
    private CommandListener commandListener;
    private Command command;
    private Displayable displayable;
    private ItemCommandListener itemCommandListener;
    private Item parentItem;
    private boolean isStopRequested;
    private boolean isWorking;

    private AsynchronousMultipleCommandListener() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public static AsynchronousMultipleCommandListener getInstance() {
        if (instance == null) {
            instance = new AsynchronousMultipleCommandListener();
        }
        return instance;
    }

    public void requestStop() {
        this.isStopRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(CommandListener listener, Command cmd, Displayable disp) {
        AsynchronousMultipleCommandListener asynchronousMultipleCommandListener = this;
        synchronized (asynchronousMultipleCommandListener) {
            if (this.isWorking) {
                WorkerThread thread = new WorkerThread(listener, cmd, disp);
                thread.start();
            } else {
                this.commandListener = listener;
                this.command = cmd;
                this.displayable = disp;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(ItemCommandListener listener, Command cmd, Item item) {
        AsynchronousMultipleCommandListener asynchronousMultipleCommandListener = this;
        synchronized (asynchronousMultipleCommandListener) {
            if (this.isWorking) {
                WorkerThread thread = new WorkerThread(listener, cmd, item);
                thread.start();
            } else {
                this.itemCommandListener = listener;
                this.command = cmd;
                this.parentItem = item;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CommandListener listener = null;
        ItemCommandListener itemListener = null;
        Command cmd = null;
        Displayable disp = null;
        Item itm = null;
        while (!this.isStopRequested) {
            AsynchronousMultipleCommandListener asynchronousMultipleCommandListener = this;
            synchronized (asynchronousMultipleCommandListener) {
                if (this.command == null) {
                    this.isWorking = false;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.isWorking = true;
                listener = this.commandListener;
                itemListener = this.itemCommandListener;
                cmd = this.command;
                disp = this.displayable;
                itm = this.parentItem;
                this.command = null;
                this.displayable = null;
                this.commandListener = null;
                this.itemCommandListener = null;
                this.parentItem = null;
            }
            try {
                if (listener != null) {
                    listener.commandAction(cmd, disp);
                    continue;
                }
                itemListener.commandAction(cmd, itm);
            }
            catch (Throwable e) {
                Debug.debug("error", "de.enough.polish.event.AsynchronousMultipleCommandListener", 209, (Object)("Unable to process cmd " + cmd.getLabel() + " for screen " + disp), e);
            }
        }
    }

    private static class WorkerThread
    extends Thread {
        private Command command;
        private Displayable displayable;
        private CommandListener commandListener;
        private ItemCommandListener itemCommandListener;
        private Item item;

        public WorkerThread(CommandListener commandListener, Command command, Displayable displayable) {
            this.commandListener = commandListener;
            this.command = command;
            this.displayable = displayable;
        }

        public WorkerThread(ItemCommandListener commandListener, Command command, Item item) {
            this.itemCommandListener = commandListener;
            this.command = command;
            this.item = item;
        }

        public void run() {
            try {
                if (this.commandListener != null) {
                    this.commandListener.commandAction(this.command, this.displayable);
                } else {
                    this.itemCommandListener.commandAction(this.command, this.item);
                }
            }
            catch (Throwable e) {
                Debug.debug("error", "de.enough.polish.event.AsynchronousMultipleCommandListener", 245, (Object)("Unable to process cmd " + this.command.getLabel() + " for screen " + this.displayable), e);
            }
        }
    }
}

