/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.emulator;

import java.lang.reflect.Method;
import java.util.Properties;

public class MicroEmulatorStarter {
    private MicroEmulatorStarter() {
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.load(new MicroEmulatorStarter().getClass().getResourceAsStream("/META-INF/J2MEPOLISHMANIFEST.MF"));
            String midletClassName = props.getProperty("MIDlet-1");
            if (midletClassName == null) {
                System.err.println("Unable to read midlet class name from manifest, check the MIDlet-1 attribute within META-INF/J2MEPOLISHMANIFEST.MF.");
                System.out.println("got properties: ");
                Object[] keys = props.keySet().toArray();
                int i = 0;
                while (i < keys.length) {
                    String key = (String)keys[i];
                    System.out.println(String.valueOf(key) + "=" + props.getProperty(key));
                    ++i;
                }
                if (args == null || args.length == 0) {
                    System.exit(2);
                } else {
                    System.out.println("Assuming necessary attributes are specified as command line arguments.");
                }
            }
            int startIndex = midletClassName.lastIndexOf(44);
            midletClassName = midletClassName.substring(startIndex + 1).trim();
            Class<?> meClass = Class.forName("org.microemu.app.Main");
            String[] newArgs = new String[]{"--resizableDevice", "320", "240", "--device", "org/microemu/device/resizable/device.xml", midletClassName};
            if (args == null || args.length == 0) {
                args = newArgs;
            } else {
                String[] cArgs = new String[args.length + newArgs.length];
                System.arraycopy(args, 0, cArgs, 0, args.length);
                System.arraycopy(newArgs, 0, cArgs, args.length, newArgs.length);
                args = cArgs;
            }
            Method mainMethod = meClass.getMethod("main", args.getClass());
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            System.out.println("Unable to start the MicroEmulator: " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }
}

