/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.content.storage;

import de.enough.polish.content.ContentDescriptor;
import de.enough.polish.io.Serializer;
import de.enough.polish.util.ToStringHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class StorageReference
extends ContentDescriptor {
    Object reference;
    long creationTime;
    int size;
    int activityCount;
    long activityTime;

    public StorageReference() {
    }

    public StorageReference(ContentDescriptor descriptor, int size, Object reference) {
        super(descriptor);
        this.creationTime = System.currentTimeMillis();
        this.reference = reference;
        this.size = size;
        this.activityCount = 0;
        this.activityTime = this.creationTime;
        this.priority = descriptor.getPriority();
    }

    public Object getReference() {
        return this.reference;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int size() {
        return this.size;
    }

    public int getActivity() {
        return this.activityCount;
    }

    public long getLastActivityTime() {
        return this.activityTime;
    }

    public void updateActivity() {
        ++this.activityCount;
        this.activityTime = System.currentTimeMillis();
    }

    public void read(DataInputStream in) throws IOException {
        super.read(in);
        this.reference = Serializer.deserialize(in);
        this.creationTime = in.readLong();
        this.size = in.readInt();
        this.activityCount = in.readInt();
        this.activityTime = in.readLong();
    }

    public void write(DataOutputStream out) throws IOException {
        super.write(out);
        Serializer.serialize(this.reference, out);
        out.writeLong(this.creationTime);
        out.writeInt(this.size);
        out.writeInt(this.activityCount);
        out.writeLong(this.activityTime);
    }

    public String toString() {
        return ToStringHelper.createInstance("StorageReference").set("url", this.url).set("hash", this.hash).set("creationTime", this.creationTime).set("activityCount", this.activityCount).set("activityTime", this.activityTime).set("reference", this.reference).set("size", this.size).toString();
    }
}

