/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.content.source.impl;

import de.enough.polish.content.ContentDescriptor;
import de.enough.polish.content.source.ContentSource;
import de.enough.polish.content.storage.StorageIndex;
import de.enough.polish.content.storage.StorageReference;
import de.enough.polish.io.Serializer;
import de.enough.polish.util.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RmsContentStorage
extends ContentSource {
    static final String STORAGE = "RMSContentStorage";
    protected RecordStore store;

    public RmsContentStorage(String id, StorageIndex index) {
        super(id, index);
        try {
            this.store = RecordStore.openRecordStore(STORAGE, true);
        }
        catch (RecordStoreException e) {
            Debug.debug("error", "de.enough.polish.content.source.impl.RmsContentStorage", 36, (Object)"unable to open record store ", e);
        }
    }

    public synchronized void shutdown() {
        try {
            this.store.closeRecordStore();
        }
        catch (RecordStoreException e) {
            Debug.debug("error", "de.enough.polish.content.source.impl.RmsContentStorage", 47, (Object)"unable to close record store ", e);
        }
        super.shutdown();
    }

    protected synchronized void destroy(StorageReference reference) throws IOException {
        try {
            int recordId = (Integer)reference.getReference();
            this.store.deleteRecord(recordId);
        }
        catch (RecordStoreException e) {
            throw new IOException("unable to delete data " + e);
        }
    }

    protected Object[] storeContentAndGetDataSize(ContentDescriptor descriptor, Object data) throws IOException {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            Serializer.serialize(data, new DataOutputStream(byteStream));
            byte[] bytes = byteStream.toByteArray();
            int recordId = this.store.addRecord(bytes, 0, bytes.length);
            return new Object[]{new Integer(bytes.length), new Integer(recordId)};
        }
        catch (RecordStoreException e) {
            throw new IOException("unable to store data " + e);
        }
    }

    protected synchronized Object store(ContentDescriptor descriptor, Object data) throws IOException {
        return null;
    }

    protected synchronized Object load(ContentDescriptor descriptor) throws IOException {
        return null;
    }

    protected synchronized Object load(StorageReference reference) throws IOException {
        try {
            int recordId = (Integer)reference.getReference();
            byte[] bytes = this.store.getRecord(recordId);
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            Object data = Serializer.deserialize(new DataInputStream(byteStream));
            return data;
        }
        catch (RecordStoreException e) {
            Debug.debug("error", "de.enough.polish.content.source.impl.RmsContentStorage", 114, (Object)"unable to load data ", e);
            return null;
        }
    }
}

