/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.calendar;

import de.enough.polish.calendar.CalendarEntry;
import de.enough.polish.io.Externalizable;
import de.enough.polish.util.TimePeriod;
import de.enough.polish.util.TimePoint;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EventRepeatRule
implements Externalizable {
    private static final int VERSION = 101;
    public static final TimePoint INTERVAL_YEARLY = new TimePoint(1, 0, 0);
    public static final TimePoint INTERVAL_MONTHLY = new TimePoint(0, 1, 0);
    public static final TimePoint INTERVAL_WEEKLY = new TimePoint(0, 0, 7);
    public static final EventRepeatRule RULE_YEARLY = new EventRepeatRule(INTERVAL_YEARLY);
    public static final EventRepeatRule RULE_MONTHLY = new EventRepeatRule(INTERVAL_MONTHLY);
    private TimePoint interval = INTERVAL_YEARLY;
    private int weekday = -1;
    private int weekdayMatchInMonth;
    private TimePoint untilDate;

    public EventRepeatRule() {
    }

    public EventRepeatRule(TimePoint interval) {
        this.interval = interval;
    }

    public EventRepeatRule(int weekday, int match) {
        this(INTERVAL_YEARLY, weekday, match);
    }

    public EventRepeatRule(TimePoint interval, int weekday, int match) {
        if (weekday < 1 || weekday > 7 || match == 0 || interval == null) {
            throw new IllegalArgumentException();
        }
        this.interval = interval;
        this.weekday = weekday;
        this.weekdayMatchInMonth = match;
    }

    public TimePoint getInterval() {
        return this.interval;
    }

    public void setInterval(TimePoint interval) {
        this.interval = interval;
    }

    public int getWeekday() {
        return this.weekday;
    }

    public void setWeekday(int weekday) {
        this.weekday = weekday;
    }

    public int getWeekdayMatch() {
        return this.weekdayMatchInMonth;
    }

    public void setWeekdayMatch(int match) {
        this.weekdayMatchInMonth = match;
    }

    public TimePoint getUntilDate() {
        return this.untilDate;
    }

    public void setUntilDate(TimePoint untilDate) {
        this.untilDate = untilDate;
    }

    public void read(DataInputStream in) throws IOException {
        int version = in.readInt();
        if (version != 101) {
            throw new IOException("unknown version " + version);
        }
        this.interval = new TimePoint(in);
        this.weekday = in.readInt();
        this.weekdayMatchInMonth = in.readInt();
        boolean isNotNull = in.readBoolean();
        if (isNotNull) {
            this.untilDate = new TimePoint(in);
        }
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(101);
        this.interval.write(out);
        out.writeInt(this.weekday);
        out.writeInt(this.weekdayMatchInMonth);
        boolean isNotNull = this.untilDate != null;
        out.writeBoolean(isNotNull);
        if (isNotNull) {
            this.untilDate.write(out);
        }
    }

    public TimePoint getNextDate(CalendarEntry entry, TimePeriod period) {
        TimePoint periodStart = period.getStart();
        if (this.untilDate != null && this.untilDate.isBefore(periodStart)) {
            return null;
        }
        TimePoint nextDate = new TimePoint(entry.getStartDate());
        TimePoint periodEnd = period.getEnd();
        while (!period.matches(nextDate) && !nextDate.isAfter(periodEnd)) {
            nextDate.add(this.interval);
        }
        if (this.weekday != -1 && this.weekdayMatchInMonth != 0) {
            int offset = 0;
            boolean addInterval = false;
            if (this.weekdayMatchInMonth > 0) {
                do {
                    if (addInterval) {
                        nextDate.add(this.interval);
                    }
                    nextDate.setDay(1);
                    int currentWeekday = nextDate.getDayOfWeek();
                    offset = currentWeekday <= this.weekday ? this.weekday - currentWeekday : 7 + this.weekday - currentWeekday;
                    addInterval = true;
                    nextDate.setDay(1 + (offset += (this.weekdayMatchInMonth - 1) * 7));
                } while (!period.matches(nextDate) && !nextDate.isAfter(periodEnd));
            } else {
                int daysInMonth = nextDate.getDaysInMonth();
                do {
                    if (addInterval) {
                        nextDate.add(this.interval);
                    }
                    nextDate.setDay(daysInMonth);
                    int currentWeekday = nextDate.getDayOfWeek();
                    offset = currentWeekday >= this.weekday ? currentWeekday - this.weekday : 7 - this.weekday + currentWeekday;
                    addInterval = true;
                    nextDate.setDay(daysInMonth - (offset -= (this.weekdayMatchInMonth + 1) * 7));
                } while (!period.matches(nextDate) && !nextDate.isAfter(periodEnd));
            }
        }
        if (this.untilDate != null && nextDate.isAfter(this.untilDate)) {
            nextDate = null;
        } else if (!period.matches(nextDate)) {
            nextDate = null;
        }
        return nextDate;
    }
}

