/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser.protocols;

import de.enough.polish.browser.ProtocolHandler;
import de.enough.polish.io.RedirectHttpConnection;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.HashMap;
import de.enough.polish.util.Locale;
import java.io.IOException;
import javax.microedition.io.StreamConnection;

public class HttpProtocolHandler
extends ProtocolHandler {
    private static String USER_AGENT = "J2ME-Polish/" + System.getProperty("microedition.platform");
    private static boolean userAgentSet = false;
    private HashMap requestProperties;

    public static void setUserAgent(String userAgent) {
        USER_AGENT = userAgent;
        userAgentSet = true;
    }

    public static String getUserAgent() {
        return USER_AGENT;
    }

    public HttpProtocolHandler() {
        this("http", new HashMap());
    }

    public HttpProtocolHandler(HashMap requestProperties) {
        this("http", requestProperties);
    }

    public HttpProtocolHandler(String protocolName) {
        this(protocolName, new HashMap());
    }

    public HttpProtocolHandler(String protocolName, HashMap requestProperties) {
        super(protocolName);
        if (requestProperties == null) {
            requestProperties = new HashMap();
        }
        this.requestProperties = requestProperties;
        if (requestProperties.get("User-Agent") == null || userAgentSet) {
            if (USER_AGENT != null) {
                requestProperties.put("User-Agent", USER_AGENT);
            } else {
                requestProperties.remove("User-Agent");
            }
        }
        if (requestProperties.get("Accept") == null) {
            requestProperties.put("Accept", "text/html, text/xml, text/*, image/png, image/*, application/xhtml+xml, */*");
        }
        if (requestProperties.get("Accept-Language") == null) {
            requestProperties.put("Accept-Language", Locale.LANGUAGE);
        }
        if (requestProperties.get("UA-pixels") == null && StyleSheet.currentScreen != null) {
            requestProperties.put("UA-pixels", StyleSheet.currentScreen.getWidth() + "x" + StyleSheet.currentScreen.getHeight());
        }
    }

    public StreamConnection getConnection(String url) throws IOException {
        return new RedirectHttpConnection(url, this.requestProperties);
    }
}

