/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser.html;

import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;

public class HtmlSelect {
    private static final Style NO_STYLE = new Style();
    public static final String SELECT = "select";
    private final String name;
    private int size;
    private boolean isMultiple;
    private int selectedIndex;
    private final ArrayList optionNames;
    private final ArrayList optionValues;
    private final ArrayList optionStyles;
    private Style style;

    public HtmlSelect(String name, int size, boolean isMultiple, Style style) {
        if (name == null) {
            name = "";
        }
        this.name = name;
        this.size = size;
        this.isMultiple = isMultiple;
        this.style = style;
        this.selectedIndex = -1;
        this.optionNames = new ArrayList();
        this.optionValues = new ArrayList();
        this.optionStyles = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public String getValue(int index) {
        return (String)this.optionValues.get(index);
    }

    public void addOption(String name) {
        this.addOption(name, name, false, null);
    }

    public void addOption(String name, String value, boolean selected, Style optionStyle) {
        if (selected) {
            this.selectedIndex = this.optionNames.size();
        }
        this.optionNames.add(name);
        this.optionValues.add(value);
        if (optionStyle != null) {
            this.optionStyles.add(optionStyle);
        } else {
            this.optionStyles.add(NO_STYLE);
        }
    }

    public ChoiceGroup getChoiceGroup() {
        try {
            int choiceType = 1;
            if (this.isMultiple) {
                choiceType = 2;
            } else if (this.size == 1) {
                choiceType = 4;
            }
            ChoiceGroup choiceGroup = new ChoiceGroup(null, choiceType, StyleSheet.browseroptionStyle);
            if (this.style != null) {
                choiceGroup.setStyle(this.style);
            }
            for (int i = 0; i < this.optionNames.size(); ++i) {
                choiceGroup.append((String)this.optionNames.get(i), null, StyleSheet.browseroptionitemStyle);
            }
            if (this.selectedIndex != -1) {
                choiceGroup.setSelectedIndex(this.selectedIndex, true);
            }
            choiceGroup.setAttribute("name", this.name);
            choiceGroup.setAttribute(SELECT, this);
            return choiceGroup;
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.browser.html.HtmlSelect", 130, (Object)"Unable to create choice group", e);
            return null;
        }
    }
}

