/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser.css;

import de.enough.polish.io.ResourceLoader;
import de.enough.polish.io.StringReader;
import de.enough.polish.ui.Color;
import de.enough.polish.ui.Dimension;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.backgrounds.ImageBackground;
import de.enough.polish.ui.backgrounds.SimpleBackground;
import de.enough.polish.ui.backgrounds.TiledImageBackground;
import de.enough.polish.util.Debug;
import de.enough.polish.util.HashMap;
import de.enough.polish.util.TextUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class CssInterpreter {
    private static final HashMap colorMap = new HashMap();
    private static final int BUFFER_SIZE = 100;
    private final Reader reader;
    private final char[] readBuffer;
    private int bufferStartIndex;
    private int bufferEndIndex;
    private boolean isInComment;
    private boolean hasNextToken;
    private Hashtable styles;
    private ResourceLoader resourceLoader;

    public CssInterpreter(String cssCode) {
        this(new StringReader(cssCode), null);
    }

    public CssInterpreter(String cssCode, ResourceLoader resourceLoader) {
        this(new StringReader(cssCode), resourceLoader);
    }

    public CssInterpreter(Reader reader) {
        this(reader, null);
    }

    public CssInterpreter(Reader reader, ResourceLoader resourceLoader) {
        this.reader = reader;
        this.resourceLoader = resourceLoader;
        this.readBuffer = new char[100];
        this.bufferStartIndex = 100;
        this.hasNextToken = true;
    }

    protected boolean hasNextToken() {
        return this.hasNextToken || this.bufferStartIndex < this.bufferEndIndex;
    }

    protected String nextToken(StringBuffer strBuffer) throws IOException {
        if (this.bufferStartIndex >= this.bufferEndIndex) {
            int read = this.reader.read(this.readBuffer);
            if (read == -1) {
                return null;
            }
            this.bufferStartIndex = 0;
            this.bufferEndIndex = read;
            this.hasNextToken = read == 100;
        }
        boolean comment = this.isInComment;
        boolean checkNextCharForEndComment = false;
        boolean checkNextCharForStartComment = false;
        for (int index = this.bufferStartIndex; index < this.bufferEndIndex; ++index) {
            char c = this.readBuffer[index];
            if (comment && c == '*') {
                checkNextCharForEndComment = true;
                continue;
            }
            if (checkNextCharForEndComment && c == '/') {
                comment = false;
                this.isInComment = false;
                continue;
            }
            if (comment) {
                checkNextCharForEndComment = false;
                continue;
            }
            if (c == '/') {
                checkNextCharForStartComment = true;
                strBuffer.append(c);
                continue;
            }
            if (checkNextCharForStartComment && c == '*') {
                checkNextCharForStartComment = false;
                comment = true;
                strBuffer.deleteCharAt(strBuffer.length() - 1);
                continue;
            }
            checkNextCharForStartComment = false;
            if (c == ';' || c == '{' || c == '}') {
                String result = strBuffer.toString().trim();
                this.bufferStartIndex = c == '}' && result.length() > 0 ? index : index + 1;
                strBuffer.delete(0, strBuffer.length());
                return result;
            }
            if (c == '\n') continue;
            strBuffer.append(c);
        }
        this.bufferStartIndex = this.bufferEndIndex;
        return this.nextToken(strBuffer);
    }

    public Style nextStyle() throws IOException {
        Style style;
        Style originalStyle;
        if (!this.hasNextToken()) {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        String styleName = this.nextToken(strBuffer);
        if (styleName == null) {
            return null;
        }
        if (styleName.length() == 0) {
            throw new IllegalArgumentException("Invalid empty style name.");
        }
        if (styleName.charAt(0) == '.') {
            styleName = styleName.substring(1);
        }
        if ((styleName = styleName.toLowerCase()).endsWith(":hover")) {
            styleName = styleName.substring(0, styleName.length() - ":hover".length());
            originalStyle = this.getStyle(styleName);
            styleName = styleName + "focused";
            if (originalStyle == null) {
                style = new Style();
            } else {
                style = originalStyle.clone(true);
                originalStyle.addAttribute(1, style);
            }
        } else if (styleName.endsWith(":pressed")) {
            styleName = styleName.substring(0, styleName.length() - ":pressed".length());
            originalStyle = this.getStyle(styleName);
            styleName = styleName + "pressed";
            if (originalStyle == null) {
                style = new Style();
            } else {
                style = originalStyle.clone(true);
                originalStyle.addAttribute(292, style);
            }
        } else {
            style = new Style();
        }
        style.name = styleName;
        String blockName = null;
        HashMap backgroundAttributes = null;
        HashMap borderAttributes = null;
        while (this.hasNextToken()) {
            String property = this.nextToken(strBuffer);
            if (property.length() == 0) {
                if (blockName == null) break;
                blockName = null;
                continue;
            }
            int splitPos = property.indexOf(58);
            if (splitPos == -1) {
                if (blockName != null) {
                    throw new IOException("invalid block nesting in style " + style.name + ": " + blockName + "-" + property);
                }
                blockName = property;
                continue;
            }
            String attributeValue = property.substring(splitPos + 1).trim();
            String attributeName = property.substring(0, splitPos).trim();
            if (blockName != null) {
                attributeName = blockName + "-" + attributeName;
            }
            if (attributeName.startsWith("background-")) {
                if (backgroundAttributes == null) {
                    backgroundAttributes = new HashMap();
                }
                backgroundAttributes.put(attributeName, attributeValue);
                continue;
            }
            if (attributeName.startsWith("border-")) {
                if (borderAttributes == null) {
                    borderAttributes = new HashMap();
                }
                borderAttributes.put(attributeName, attributeValue);
                continue;
            }
            try {
                this.addAttribute(attributeName, attributeValue, style);
            }
            catch (IllegalArgumentException e) {}
        }
        if (backgroundAttributes != null) {
            this.addBackground(backgroundAttributes, style);
        }
        if (borderAttributes != null) {
            this.addBorder(borderAttributes, style);
        }
        return style;
    }

    private void addBorder(HashMap borderAttributes, Style style) {
    }

    private void addBackground(HashMap backgroundAttributes, Style style) {
        String colorValue = (String)backgroundAttributes.get("background-color");
        String imageValue = (String)backgroundAttributes.get("background-image");
        String repeatValue = (String)backgroundAttributes.get("background-repeat");
        String positionValue = (String)backgroundAttributes.get("background-position");
        Color color2 = colorValue != null ? this.parseColor(colorValue) : new Color(-1);
        if (imageValue == null || "none".equals(imageValue)) {
            style.background = new SimpleBackground(color2);
        } else {
            String imageUrl = this.parseUrl(imageValue);
            Image image = null;
            if (this.resourceLoader != null) {
                try {
                    image = Image.createImage(this.resourceLoader.getResourceAsStream(imageUrl));
                }
                catch (IOException e) {
                    Debug.debug("error", "de.enough.polish.browser.css.CssInterpreter", 332, (Object)("Unable to load background-image " + imageValue), e);
                }
            }
            int anchor = 0;
            Dimension xOffset = new Dimension(0);
            Dimension yOffset = new Dimension(0);
            if (positionValue != null) {
                String[] positions = TextUtil.splitAndTrim(positionValue, ' ');
                boolean horizontalSet = false;
                boolean verticalSet = false;
                String remaining = null;
                for (int i = 0; i < positions.length; ++i) {
                    String pos = positions[i];
                    if ("top".equals(pos)) {
                        verticalSet = true;
                        anchor |= 0x10;
                        continue;
                    }
                    if ("bottom".equals(pos)) {
                        verticalSet = true;
                        anchor |= 0x20;
                        continue;
                    }
                    if ("left".equals(pos)) {
                        horizontalSet = true;
                        anchor |= 4;
                        continue;
                    }
                    if ("right".equals(pos)) {
                        horizontalSet = true;
                        anchor |= 8;
                        continue;
                    }
                    remaining = pos;
                }
                if (!horizontalSet || !verticalSet) {
                    boolean isCenter;
                    boolean bl = isCenter = remaining == null || "center".equals(remaining) || "50%".equals(remaining);
                    if (horizontalSet) {
                        if (isCenter) {
                            anchor |= 2;
                        } else if ("0%".equals(remaining)) {
                            anchor |= 0x10;
                        } else if ("100%".equals(remaining)) {
                            anchor |= 0x20;
                        } else {
                            yOffset.setValue(remaining);
                        }
                    } else if (verticalSet) {
                        if (isCenter) {
                            anchor |= 1;
                        } else if ("0%".equals(remaining)) {
                            anchor |= 4;
                        } else if ("100%".equals(remaining)) {
                            anchor |= 8;
                        } else {
                            xOffset.setValue(remaining);
                        }
                    } else if (positions.length == 1 && isCenter) {
                        anchor = 3;
                    } else {
                        anchor = 20;
                        xOffset.setValue(positions[0]);
                        if (positions.length > 1) {
                            yOffset.setValue(positions[1]);
                        }
                    }
                }
            } else {
                anchor = 20;
            }
            if (repeatValue == null || "no-repeat".equals(repeatValue)) {
                style.background = image != null ? new ImageBackground(color2.getColor(), image, anchor, xOffset, yOffset) : new ImageBackground(color2.getColor(), imageUrl, anchor, xOffset, yOffset);
            } else {
                int repeat = 1;
                if ("repeat-x".equals(repeatValue)) {
                    repeat = 2;
                } else if ("repeat-y".equals(repeatValue)) {
                    repeat = 3;
                }
                style.background = image != null ? new TiledImageBackground(color2.getColor(), image, repeat, anchor, 0, 0, false, xOffset, yOffset) : new TiledImageBackground(color2.getColor(), imageUrl, repeat, anchor, 0, 0, false, xOffset, yOffset);
            }
        }
    }

    protected Style getStyle(String styleName) {
        Style style = null;
        if (this.styles != null) {
            style = (Style)this.styles.get(styleName);
        }
        if (style == null) {
            style = StyleSheet.getStyle(styleName);
        }
        return style;
    }

    protected void addAttribute(String name, String value, Style style) {
        if ("font-color".equals(name) || "color".equals(name)) {
            style.addAttribute(-17, this.parseColor(value));
            return;
        }
        if ("margin".equals(name)) {
            String[] values = TextUtil.split(value, ' ');
            if (values.length == 1) {
                style.addAttribute(32713, new Dimension(value));
            } else if (values.length == 2) {
                Dimension vertical = new Dimension(values[0]);
                Dimension horizontal = new Dimension(values[1]);
                style.addAttribute(-4, vertical);
                style.addAttribute(-3, horizontal);
                style.addAttribute(-5, vertical);
                style.addAttribute(-2, horizontal);
            } else if (values.length == 3) {
                Dimension horizontal = new Dimension(values[1]);
                style.addAttribute(-4, new Dimension(values[0]));
                style.addAttribute(-3, horizontal);
                style.addAttribute(-5, new Dimension(values[2]));
                style.addAttribute(-2, horizontal);
            } else {
                style.addAttribute(-4, new Dimension(values[0]));
                style.addAttribute(-3, new Dimension(values[1]));
                style.addAttribute(-5, new Dimension(values[2]));
                style.addAttribute(-2, new Dimension(values[3]));
            }
            return;
        }
        if ("margin-right".equals(name)) {
            style.addAttribute(-3, new Dimension(value));
            return;
        }
        if ("margin-top".equals(name)) {
            style.addAttribute(-4, new Dimension(value));
            return;
        }
        if ("margin-bottom".equals(name)) {
            style.addAttribute(-5, new Dimension(value));
            return;
        }
        if ("padding".equals(name)) {
            String[] values = TextUtil.split(value, ' ');
            if (values.length == 1) {
                style.addAttribute(-6, new Dimension(value));
            } else if (values.length == 2) {
                Dimension vertical = new Dimension(values[0]);
                Dimension horizontal = new Dimension(values[1]);
                style.addAttribute(-9, vertical);
                style.addAttribute(-8, horizontal);
                style.addAttribute(-10, vertical);
                style.addAttribute(-7, horizontal);
            } else if (values.length == 3) {
                Dimension horizontal = new Dimension(values[1]);
                style.addAttribute(-9, new Dimension(values[0]));
                style.addAttribute(-8, horizontal);
                style.addAttribute(-10, new Dimension(values[2]));
                style.addAttribute(-7, horizontal);
            } else {
                style.addAttribute(-9, new Dimension(values[0]));
                style.addAttribute(-8, new Dimension(values[1]));
                style.addAttribute(-10, new Dimension(values[2]));
                style.addAttribute(-7, new Dimension(values[3]));
            }
            return;
        }
        if ("padding-left".equals(name)) {
            style.addAttribute(-7, new Dimension(value));
            return;
        }
        if ("padding-right".equals(name)) {
            style.addAttribute(-8, new Dimension(value));
            return;
        }
        if ("padding-top".equals(name)) {
            style.addAttribute(-9, new Dimension(value));
            return;
        }
        if ("padding-bottom".equals(name)) {
            style.addAttribute(-10, new Dimension(value));
            return;
        }
    }

    protected String parseUrl(String value) {
        int endPos;
        String url = null;
        int startPos = value.indexOf(34);
        if (startPos != -1 && (endPos = value.indexOf(34, startPos + 1)) != -1) {
            url = value.substring(startPos + 1, endPos);
        }
        if (url == null && value.startsWith("url")) {
            startPos = value.indexOf(40);
            endPos = value.indexOf(41);
            if (startPos != -1 && endPos > startPos) {
                url = value.substring(startPos + 1, endPos).trim();
            }
        }
        if (url == null) {
            url = value;
        }
        if (url.length() > 0 && url.charAt(0) != '/' && !url.startsWith("http")) {
            url = '/' + url;
        }
        return url;
    }

    protected Color parseColor(String value) {
        int valueLength = value.length();
        if ("transparent".equals(value)) {
            return new Color(-1);
        }
        try {
            if (value.charAt(0) == '#') {
                if (valueLength <= 4) {
                    StringBuffer buffer = new StringBuffer((valueLength - 1) * 2);
                    for (int i = 1; i < valueLength; ++i) {
                        char c = value.charAt(i);
                        buffer.append(c).append(c);
                    }
                    long color2 = Long.parseLong(buffer.toString(), 16);
                    return new Color((int)color2);
                }
                long color3 = Long.parseLong(value.substring(1), 16);
                return new Color((int)color3, false);
            }
            if (value.startsWith("rgb") || value.startsWith("argb")) {
                String[] chunks;
                int startPos = value.indexOf(40);
                int endPos = value.indexOf(41);
                if (startPos != -1 && endPos != -1 && (chunks = TextUtil.splitAndTrim(value.substring(startPos + 1, endPos), ',')).length >= 3 && chunks.length <= 4) {
                    int color4 = 0;
                    for (int i = 0; i < chunks.length; ++i) {
                        int chunkColor;
                        String chunk = chunks[i];
                        int chunkLength = chunk.length();
                        if (chunk.charAt(chunkLength - 1) == '%') {
                            int percent = Integer.parseInt(chunk.substring(0, chunkLength - 1).trim());
                            chunkColor = percent * 255 / 100;
                        } else {
                            chunkColor = Integer.parseInt(chunk);
                        }
                        color4 |= chunkColor << (chunks.length - i - 1) * 8;
                    }
                    return new Color(color4);
                }
            } else {
                Color color5 = (Color)colorMap.get(value);
                if (color5 != null) {
                    return color5;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid color: " + value);
    }

    public void registerStyles() throws IOException {
        Style style;
        if (this.styles == null) {
            this.styles = new Hashtable();
        }
        while ((style = this.nextStyle()) != null) {
            this.styles.put(style.name, style);
        }
    }

    public Hashtable getAllStyles() {
        if (this.styles == null) {
            try {
                this.registerStyles();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.styles;
    }

    static {
        colorMap.put("aqua", new Color(65535));
        colorMap.put("black", new Color(0));
        colorMap.put("blue", new Color(255));
        colorMap.put("fuchsia", new Color(0xFF00FF));
        colorMap.put("gray", new Color(0x808080));
        colorMap.put("green", new Color(32768));
        colorMap.put("lime", new Color(65280));
        colorMap.put("maroon", new Color(0x800000));
        colorMap.put("navy", new Color(128));
        colorMap.put("olive", new Color(0x808000));
        colorMap.put("orange", new Color(16753920));
        colorMap.put("purple", new Color(0x800080));
        colorMap.put("red", new Color(0xFF0000));
        colorMap.put("silver", new Color(0xC0C0C0));
        colorMap.put("teal", new Color(32896));
        colorMap.put("white", new Color(0xFFFFFF));
        colorMap.put("yellow", new Color(0xFFFF00));
    }
}

